using System;
using System.Windows.Forms;

namespace XCircuiTest
{
	public class ColorChooser
	{
		private static System.Drawing.Color color = System.Drawing.Color.Black;

		private static void OnChooseColor(object sender, EventArgs args)
		{
			ColorDialog dlg = new ColorDialog();
			dlg.FullOpen = true;
			dlg.Color = color;
			if (dlg.ShowDialog() == DialogResult.OK)
			{
				XCircuit.Application.AddColor(dlg.Color);
				color = dlg.Color;
			}
		}

		public static void XC_init()
		{
			XCircuit.MenuItem item = XCircuit.MenuItem.GetMenuItem("Add New Color");
			item.Reset();
			item.Click += new EventHandler(OnChooseColor);
		}
	}
}
