//
//

#ifndef DBUS__DBusGnomeApplet_HH
#define DBUS__DBusGnomeApplet_HH

#include <sigc++/sigc++.h>
#include "DBus.hh"
#include <string>

namespace workrave
{
  class DBus;
}




using namespace std;

class org_workrave_GnomeAppletInterface
{
public:
  static org_workrave_GnomeAppletInterface *instance(workrave::DBus *dbus, const std::string &service, const std::string &path);
  
  typedef sigc::slot<void, DBusError *     , guint32   > GetSocketId_slot;
  virtual guint32 GetSocketId(    /**/   ) = 0;
  virtual void GetSocketId_async(     GetSocketId_slot slot   ) = 0;
  typedef sigc::slot<void, DBusError *     , guint32   > GetSize_slot;
  virtual guint32 GetSize(    /**/   ) = 0;
  virtual void GetSize_async(     GetSize_slot slot   ) = 0;
  typedef sigc::slot<void, DBusError *     , guint32   > GetOrientation_slot;
  virtual guint32 GetOrientation(    /**/   ) = 0;
  virtual void GetOrientation_async(     GetOrientation_slot slot   ) = 0;
  typedef sigc::slot<void, DBusError *   > SetMenuStatus_slot;
  virtual void SetMenuStatus(  const    std::string     &menu  , bool     &status  ) = 0;
  virtual void SetMenuStatus_async(      const      std::string     &menu    , bool     &status    , SetMenuStatus_slot slot   ) = 0;
  typedef sigc::slot<void, DBusError *     , bool     &  > GetMenuStatus_slot;
  virtual void GetMenuStatus(  const    std::string     &menu  , bool      &status  ) = 0;
  virtual void GetMenuStatus_async(      const      std::string     &menu    , GetMenuStatus_slot slot   ) = 0;
  typedef sigc::slot<void, DBusError *   > SetMenuActive_slot;
  virtual void SetMenuActive(  const    std::string     &menu  , bool     &active  ) = 0;
  virtual void SetMenuActive_async(      const      std::string     &menu    , bool     &active    , SetMenuActive_slot slot   ) = 0;
  typedef sigc::slot<void, DBusError *     , bool     &  > GetMenuActive_slot;
  virtual void GetMenuActive(  const    std::string     &menu  , bool      &active  ) = 0;
  virtual void GetMenuActive_async(      const      std::string     &menu    , GetMenuActive_slot slot   ) = 0;
};



#endif // DBUS__HH
