/* mutex.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: mutex.h,v 1.4 2004/03/18 07:02:18 ralf Exp $ */

#ifndef MUTEX_H
#define MUTEX_H

#include "aguixdefs.h"

#ifdef WANT_THREADS
#include <pthread.h>
#endif

class MutEx
{
public:
  MutEx();
  virtual ~MutEx();
  MutEx( const MutEx &other );
  MutEx &operator=( const MutEx &other );
  void lock();
  void unlock();
  bool trylock();
protected:
#ifdef WANT_THREADS
  pthread_mutex_t mutex;
  pthread_mutex_t dmutex;
  pthread_cond_t condvar;
  pthread_t owner;
  int owncount;
#endif  
};

#endif
