/* ownop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: ownop.h,v 1.14 2003/06/04 21:53:24 ralf Exp $ */

#ifndef OWNOP_H
#define OWNOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/stringgadget.h>

class Worker;

typedef struct { const char *flag;
                 int catcode;
               } ownop_flags_t;
static const ownop_flags_t ownop_flags[] = { { "{Rs{Infotext}{Defaulttext}}", 0 },
                                             { "{pop 0}", 38 },
                                             { "{top 0}", 39 },
                                             { "{size 0}", 49 },
                                             { "{vEnvname}", 50 },
                                             { "{scripts}", 53 },
                                             { "{p}", 1 },
                                             { "{op}", 2 },
                                             { "{lp}", 3 },
                                             { "{rp}", 4 },
                                             { "{dp}", 37 },
                                             { "{f}", 5 },
                                             { "{F}", 6 },
                                             { "{a}", 7 },
                                             { "{A}", 8 },
                                             { "{fE}", 9 },
                                             { "{FE}", 10 },
                                             { "{aE}", 11 },
                                             { "{AE}", 12 },
                                             { "{uf}", 13 },
                                             { "{uF}", 14 },
                                             { "{ua}", 15 },
                                             { "{uA}", 16 },
                                             { "{ufE}", 17 },
                                             { "{uFE}", 18 },
                                             { "{uaE}", 19 },
                                             { "{uAE}", 20 },
                                             { "{of}", 21 },
                                             { "{oF}", 22 },
                                             { "{oa}", 23 },
                                             { "{oA}", 24 },
                                             { "{ofE}", 25 },
                                             { "{oFE}", 26 },
                                             { "{oaE}", 27 },
                                             { "{oAE}", 28 },
                                             { "{ouf}", 29 },
                                             { "{ouF}", 30 },
                                             { "{oua}", 31 },
                                             { "{ouA}", 32 },
                                             { "{oufE}", 33 },
                                             { "{ouFE}", 34 },
                                             { "{ouaE}", 35 },
                                             { "{ouAE}", 36 } };

class OwnOp:public FunctionProto
{
public:
  OwnOp();
  virtual ~OwnOp();
  virtual OwnOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run( WPUContext *, ActionMessage * );
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  typedef enum {OWNOP_START_NORMAL=0,
                OWNOP_START_IN_TERMINAL,
                OWNOP_START_IN_TERMINAL_AND_WAIT4KEY,
                OWNOP_SHOW_OUTPUT} ownstart_t;
  void setSeparateEachEntry(bool);
  void setRecursive(bool);
  void setOwnStart(ownstart_t);
  void setComStr(const char*);
  void setViewStr(const char*);
  void setInBackground( bool );
  void setTakeDirs( bool );
  char *getFlag();
protected:
  static const char *name;
  // Infos to save
  bool separate_each_entry;
  bool recursive;
  bool inbackground;
  bool take_dirs;
  
  ownstart_t ownstart;

  char *com_str;
  char *view_str;
  
  // temp variables
  Lister *startlister,*endlister;
  class WPUContext *use_wpu;
  
  int normalmodeown();
};

#endif
