/* aguixcolor.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef AGUIXCOLOR_HH
#define AGUIXCOLOR_HH

#include "aguixdefs.h"
#include <functional>

class AGUIXColor {
public:
    typedef enum { USER_COLOR, SYSTEM_COLOR } color_type_t;
    
    AGUIXColor( int col, color_type_t type = USER_COLOR );
    
    int getColor() const;
    color_type_t getColorType() const;

    struct compare_func : public std::binary_function<const AGUIXColor&, const AGUIXColor&, bool>
    {
        bool operator() ( const AGUIXColor &c1, const AGUIXColor &c2 ) const
        {
            if ( c1.getColorType() == AGUIXColor::SYSTEM_COLOR &&
                 c2.getColorType() == AGUIXColor::USER_COLOR ) return true;
            if ( c1.getColorType() == AGUIXColor::USER_COLOR &&
                 c2.getColorType() == AGUIXColor::SYSTEM_COLOR ) return false;
            return c1.getColor() < c2.getColor();
        }
    };
private:
    int m_color;
    color_type_t m_color_type;
};

#endif
