/* nwc_virtualdir.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "nwc_virtualdir.hh"
#include "nwc_file.hh"
#include <iostream>

namespace NWC
{

  VirtualDir::VirtualDir( const std::string &fullname,
                          bool follow_symlinks,
                          bool search_vfs ) : Dir( fullname, follow_symlinks ),
                                              _search_vfs( search_vfs )
  {
  }

  VirtualDir::VirtualDir( const FSEntry &entry,
                          bool follow_symlinks,
                          bool search_vfs ) : Dir( entry, follow_symlinks ),
                                              _search_vfs( search_vfs )
  {
  }

  VirtualDir::~VirtualDir()
  {
  }

  void VirtualDir::handleDirEntry( const std::string &filename )
  {
    addEntry( filename );

    if ( _search_vfs == true ) {
      FSEntry te( filename + "#" );
      if ( te.entryExists() == true ) {
        //TODO use worker filetypes to test for virtual file and use specific handler
        addEntry( filename + "#" );
      }
    }
  }

  File *VirtualDir::createFile( const FSEntry &ent )
  {
    return new File( ent );
  }

  Dir *VirtualDir::createDir( const FSEntry &ent )
  {
    return new VirtualDir( ent, getFollowSymlinks(), _search_vfs );
  }

  FSEntry *VirtualDir::clone() const
  {
    return new VirtualDir( *this );
  }

  void VirtualDir::setSearchVFS( bool nv )
  {
    _search_vfs = nv;
  }

  bool VirtualDir::getSearchVFS() const
  {
    return _search_vfs;
  }

}
