/* flattypelist.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "flattypelist.hh"
#include "wconfig.h"
#include "wcfiletype.hh"

namespace FlatTypeList {
  void addSubTypes( std::vector<flattypelist_t> *l1,
		    const std::list<WCFiletype*> *types, int depth )
  {
    flattypelist_t ftl;
    std::list<WCFiletype*>::const_iterator it1;
    const std::list<WCFiletype*> *subtypes;
    
    if ( ( l1 == NULL ) || ( types == NULL ) ) return;

    for ( it1 = types->begin(); it1 != types->end(); it1++ ) {
      ftl.filetype = *it1;
      ftl.depth = depth;
      l1->push_back( ftl );
      (*it1)->sortSubTypeList();
      subtypes = (*it1)->getSubTypeList();
      if ( subtypes != NULL ) {
	if ( subtypes->size() > 0 ) {
	  addSubTypes( l1, subtypes, depth + 1 );
	}
      }    
    }
  }
  
  std::vector<flattypelist_t> *getFlatTypeList( List *types )
  {
    std::vector<flattypelist_t> *l1;
    flattypelist_t ftl;
    const std::list<WCFiletype*> *subtypes;
    int id;
    WCFiletype *ft;
    
    if ( types == NULL ) return NULL;
    
    l1 = new std::vector<flattypelist_t>;
    id = types->initEnum();
    ft = (WCFiletype*)types->getFirstElement( id );
    while ( ft != NULL ) {
      ftl.filetype = ft;
      ftl.depth = 0;
      l1->push_back( ftl );
      ft->sortSubTypeList();
      subtypes = ft->getSubTypeList();
      if ( subtypes != NULL ) {
	if ( subtypes->size() > 0 ) {
	  addSubTypes( l1, subtypes, 1 );
	}
      }
      ft = (WCFiletype*)types->getNextElement( id );
    }
    types->closeEnum( id );
    
    return l1;
  }
  
  std::string getStringForName( flattypelist_t &type )
  {
    std::string s1( type.depth * 2, ' ' );
    s1 += type.filetype->getName();
    return s1;
  }

  void buildLV( FieldListView *lv,
                std::vector<flattypelist_t> *l1,
                WCFiletype *highlightft )
  {
    int row;
    std::string s1;
    std::vector<flattypelist_t>::iterator it1;
    
    if ( ( lv == NULL ) || ( l1 == NULL ) ) return;
    
    lv->setSize( 0 );
    for ( it1 = l1->begin(); it1 != l1->end(); it1++ ) {
      row = lv->addRow();
      lv->setText( row, 0, getStringForName( *it1 ) );
      lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );

      if ( (*it1).filetype == highlightft ) lv->setActiveRow( row );
    }
    lv->redraw();
  }
};
