/* filereq.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: filereq.cc,v 1.19 2005/05/15 15:54:50 ralf Exp $ */

#include "filereq.h"
#include "worker_locale.h"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/button.h>
#include <aguix/text.h>
#include <aguix/message.h>
#include <aguix/util.h>
#include <aguix/fieldlistview.h>
#include <aguix/stringgadget.h>
#include <aguix/request.h>

FileRequester::FileRequester(AGUIX *parent)
{
  aguix=parent;
  selfes=NULL;
  actdir=NULL;
  verz=NULL;
  last_entry_str = "";
}

FileRequester::~FileRequester()
{
  reset();
  if(actdir!=NULL) _freesafe(actdir);
  if(verz!=NULL) delete verz;
}

int FileRequester::request( const char *title,
                            const char *dir,
                            const char *oktext,
                            const char *canceltext,
                            const char *infotext)
{
  if((title==NULL)||(dir==NULL)||(oktext==NULL)||(canceltext==NULL)||(infotext==NULL)) return -1;
  if((actdir==NULL)&&(strlen(dir)==0)) return -1;
  reset();
  int w=200;
  int w2=strlen(oktext)+4+strlen(canceltext)+4;
  w2*=aguix->getCharWidth();
  w2+=30;
  if(w2>w) w=w2;
  w2=strlen(infotext)+2;
  w2*=aguix->getCharWidth();
  w2+=10;
  if(w2>w) w=w2;
  int h=3*aguix->getCharHeight()+50+150;

  AWindow *win = new AWindow( aguix, 10, 10, w, h, 0, title );
  win->create();
  win->setMinSize(w,h);
  int ty,dh;
  ty=5;
  win->add(new Text(aguix,5,ty,infotext,1));
  ty+=aguix->getCharHeight()+5;
  lv = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, w - 10, 150, 0 ) );
  lv->setHBarState(2);
  lv->setVBarState(2);
  ty+=lv->getHeight();
  sg=(StringGadget*)win->add(new StringGadget(aguix,5,ty,w-10,dir,0));
//  sg->move(5,cnb->getY()-5-sg->getHeight());
//  dh-=sg->getHeight();
  ty+=sg->getHeight()+5;
//  int dh=h-dy;
  int dw=(strlen(oktext)+2)*aguix->getCharWidth();
  Button *okb=(Button*)win->add(new Button(aguix,5,ty,dw,oktext,1,0,0));
  dw=(strlen(canceltext)+2)*aguix->getCharWidth();
  Button *cnb=(Button*)win->add(new Button(aguix,w-5-dw,ty,dw,canceltext,1,0,0));
//  dh-=h-cnb->getY()+5;
  ty+=okb->getHeight()+5;
  h=ty;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMinSize(w,h);
  win->show();
  AGMessage *msg;
  verz=new Verzeichnis();
  if(strlen(dir)>0) {
    setDir(dir);
  } else {
    setDir(actdir);
  }
  int endmode=-1;
  int lastrow = -1;
  Time lasttime=0;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=0;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=1;
          else if(msg->button.button==cnb) endmode=0;
          break;
        case AG_SIZECHANGED:
          okb->move(5,msg->size.newh-5-okb->getHeight());
          dw=cnb->getWidth();
          cnb->move(msg->size.neww-dw-5,msg->size.newh-5-okb->getHeight());
          sg->move(5,cnb->getY()-5-sg->getHeight());
          sg->resize(msg->size.neww-10,sg->getHeight());
          dh=sg->getY()-10-aguix->getCharHeight();
          lv->resize(msg->size.neww-10,dh);
          break;
        case AG_STRINGGADGET_DEACTIVATE:
          if(msg->stringgadget.sg==sg) {
            setDir(sg->getText());
          }
          break;
        case AG_FIELDLV_ONESELECT:
          if ( msg->fieldlv.lv == lv ) {
            if ( lv->isValidRow( lastrow ) == true  ) {
              if ( msg->fieldlv.row == lastrow ) {
                // eventl. Doppelklick
                if ( aguix->isDoubleClick( msg->fieldlv.time, lasttime ) == true ) {
                  ArrayList *files = verz->getFiles();
                  FileEntry *fe = (FileEntry*)files->getElementAt( lastrow );
                  if ( fe != NULL ) {
                    if ( fe->isDir() == true ) {
                      char *tstr = (char*)_allocsafe( strlen( actdir ) + 1 + strlen( fe->name ) + 2 );
                      sprintf( tstr, "%s/%s", actdir, fe->name );
                      setDir( tstr );
                      _freesafe( tstr );
                    } else {
                      endmode = 2;
                    }
                  }
                }
                if ( endmode == -1 ) {
                  lastrow = -1;
                  lasttime = 0;
                }
              } else {
                lastrow = msg->fieldlv.row;
                lasttime = msg->fieldlv.time;
              }
            } else {
              lastrow = msg->fieldlv.row;
              lasttime = msg->fieldlv.time;
            }
          }
          break;
        case AG_FIELDLV_MULTISELECT:
          if ( msg->fieldlv.lv == lv ) {
            lastrow = -1;
            lasttime = 0;
          }
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(endmode==1) {
    // Ok
    selfes=new List();
    ArrayList *files=verz->getFiles();
    FileEntry *fe=(FileEntry*)files->getElementAt(1);
    int row = 1;
    while ( fe != NULL ) {
      if ( lv->getSelect( row ) == true ) {
        selfes->addElement( fe->duplicate() );
      }
      fe = (FileEntry*)files->getNextElement();
      row++;
    }
  } else if(endmode==2) {
    selfes=new List();
    ArrayList *files=verz->getFiles();
    FileEntry *fe=(FileEntry*)files->getElementAt(1);
    int row = 1;
    while ( fe != NULL ) {
      if ( row == lastrow ) {
        selfes->addElement( fe->duplicate() );
        break;
      }
      fe = (FileEntry*)files->getNextElement();
      row++;
    }
    endmode=1;
  }
  delete win;
  delete verz;
  verz=NULL;
  return endmode;
}

void FileRequester::reset()
{
  if(selfes!=NULL) {
    FileEntry *fe=(FileEntry*)selfes->getFirstElement();
    while(fe!=NULL) {
      delete fe;
      fe=(FileEntry*)selfes->getNextElement();
    }
    delete selfes;
    selfes=NULL;
  }
#if 0
  if ( last_entry_str != NULL ) {
    _freesafe( last_entry_str );
    last_entry_str = NULL;
  }
#else
  last_entry_str = "";
#endif
}

void FileRequester::setDir(const char *dir)
{
  char *tstr=HandlePath(dir);
  int row;
  
  verz->closeDir();
  if(verz->readDir(tstr)!=0) {
    if(actdir!=NULL) {
      if(verz->readDir(actdir)!=0) return;
    } else verz->readDir("/");
  }
  _freesafe(tstr);
  tstr=dupstring(verz->getDir());
  if(actdir!=NULL) _freesafe(actdir);
  actdir=tstr;
  sg->setText(actdir);
  verz->sort(0);
  ArrayList *files=verz->getFiles();
  FileEntry *fe=(FileEntry*)files->getFirstElement();
  lv->setSize( 0 );
  while(fe!=NULL) {
    row = lv->addRow();
    lv->setText( row, 0, fe->name );
    if(fe->isDir()==false) {
      lv->setPreColors( row, FieldListView::PRECOLOR_ONLYSELECT );
    } else {
      lv->setFG( row, FieldListView::CC_NORMAL, 3 );
      lv->setFG( row, FieldListView::CC_SELECT, 2 );
      lv->setFG( row, FieldListView::CC_ACTIVE, 3 );
      lv->setFG( row, FieldListView::CC_SELACT, 2 );
      lv->setBG( row, FieldListView::CC_NORMAL, 0 );
      lv->setBG( row, FieldListView::CC_SELECT, 3 );
      lv->setBG( row, FieldListView::CC_ACTIVE, 0 );
      lv->setBG( row, FieldListView::CC_SELACT, 3 );
    }
    fe=(FileEntry*)files->getNextElement();
  }
  lv->redraw();
}

FileEntry *FileRequester::getFirstFE()
{
  if(selfes==NULL) return NULL;
  return (FileEntry*)selfes->getFirstElement();
}

FileEntry *FileRequester::getNextFE()
{
  if(selfes==NULL) return NULL;
  return (FileEntry*)selfes->getNextElement();
}


#define FR_RE_TESTOKAY \
{ \
  bool okay = false; \
  int trow2; \
  if ( sg2 != NULL ) { \
    if ( strlen( sg2->getText() ) > 0 ) { \
      endmode = 1; \
      okay = true; \
    } \
  } else { \
    trow2 = lv->getActiveRow(); \
    if ( lv->isValidRow( trow2 ) == true ) { \
      if ( lv->getData( trow2 ) == 0 ) { \
        if ( lv->getText( trow2, 0 ).length() > 0 ) { \
          endmode = 1; \
          okay = true; \
        } \
      } \
    } \
  } \
  if ( okay == false ) { \
    req->request( catalog.getLocale( 124 ), \
                  ( allowEnterName == true ) ? "Please select a file or enter a name!" : "Please select a file!", \
                  catalog.getLocale( 11 ) ); \
  } \
}

/*
 * Works like normal request but only allow to select one entry
 * when allowEnterName is true, the user can enter an own name
 * ( e.g. for file creation)
 */
int FileRequester::request_entry( const char *title,
                                  const char *dir,
                                  const char *oktext,
                                  const char *canceltext,
                                  const char *infotext,
                                  bool allowEnterName )
{
  int w, h, ty, tw;
  AWindow *win;
  AGMessage *msg;
  int endmode=-1;
  StringGadget *sg2;
  Button *b[2];
  Text *ttext;
  char *use_dir = NULL;
  int lastrow = -1, trow;
  Time lasttime=0;
  Requester *req;
  
  if ( ( title == NULL ) ||
       ( oktext == NULL ) ||
       ( canceltext == NULL ) ||
       ( infotext == NULL ) ) return -1;

  reset();

  if ( actdir == NULL ) {
    if ( dir == NULL ) {
      use_dir = HandlePathExt( "." );
      if ( use_dir == NULL ) {
        use_dir = dupstring( "/" );
      }
    } else {
      if ( Datei::fileExistsExt( dir ) == Datei::D_FE_DIR ) {
        use_dir = dupstring( dir );
      } else {
        use_dir = dupstring( "/" );
      }
    }
  } else use_dir = dupstring( actdir );

  w = h = 10;
  win = new AWindow( aguix, 10, 10, w, h, 0, title );
  win->create();

  ty=5;
  ttext = (Text*)win->add( new Text( aguix, 5, ty, infotext, 1 ) );
  ty += ttext->getHeight() + 5;

  tw = 40 * aguix->getCharWidth();
  
  sg = (StringGadget*)win->add( new StringGadget( aguix, 5, ty, tw, use_dir, 0 ) );
  ty += sg->getHeight();

  lv = (FieldListView*)win->add( new FieldListView( aguix, 5, ty, 200, 250, 0 ) );
  lv->setHBarState( 2 );
  lv->setVBarState( 2 );
  ty += lv->getHeight() + 5;
  
  if ( allowEnterName == true ) {
    sg2 = (StringGadget*)win->add( new StringGadget( aguix, 5, ty, tw, "", 0 ) );
    ty += sg2->getHeight() + 5;
  } else sg2 = NULL;
  
  win->maximizeX();
  w = win->getWidth();
  
  b[0] = (Button*)win->add( new Button( aguix, 0, ty, oktext, 1, 0, 0 ) );
  b[1] = (Button*)win->add( new Button( aguix, 0, ty, canceltext, 1, 0, 0 ) );
  ty += b[0]->getHeight() + 5;
  
  tw = AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)b, NULL, 2 );
  if ( tw > w ) w = tw;
  sg->resize( w - 10, sg->getHeight() );
  if ( sg2 != NULL ) sg2->resize( w - 10, sg->getHeight() );
  lv->resize( w - 10, lv->getHeight() );

  h = ty;
  b[0]->takeFocus();
  win->setDoTabCycling( true );
  win->resize( w, h );
  win->setMinSize( w, h );
  win->show();
  
  verz = new Verzeichnis();
  setDirOneSelect( use_dir );
  _freesafe( use_dir );

  req = new Requester( aguix );

  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) endmode = 0;
          break;
        case AG_BUTTONCLICKED:
          if ( msg->button.button == b[0] ) {
            FR_RE_TESTOKAY;
          } else if ( msg->button.button == b[1] ) endmode = 0;
          break;
        case AG_SIZECHANGED:
          AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, (GUIElement**)b, NULL, 2 );
          sg->resize( msg->size.neww - 10, sg->getHeight() );
          if ( sg2 != NULL ) sg2->resize( msg->size.neww - 10, sg->getHeight() );
          
          b[0]->move( b[0]->getX(), msg->size.newh - 5 - b[0]->getHeight() );
          b[1]->move( b[1]->getX(), msg->size.newh - 5 - b[1]->getHeight() );
          if ( sg2 != NULL ) sg2->move( sg->getX(), b[0]->getY() - 5 - sg->getHeight() );
          
          if ( sg2 != NULL ) {
            lv->resize( msg->size.neww - 10, sg2->getY() - lv->getY() - 5 );
          } else {
            lv->resize( msg->size.neww - 10, b[0]->getY() - 5 - lv->getY() - 5 );
          }
          break;
        case AG_STRINGGADGET_DEACTIVATE:
          if ( msg->stringgadget.sg == sg ) {
            setDirOneSelect( sg->getText() );
            //if ( sg2 != NULL ) sg2->setText( "" );
          } else if ( msg->stringgadget.sg == sg2 ) {
            trow = lv->getActiveRow();
            if ( lv->isValidRow( trow ) == true ) {
              lv->setActiveRow( -1 );
            }
          }
          break;
        case AG_FIELDLV_ONESELECT:
          if ( msg->fieldlv.lv == lv ) {
            if ( lv->isValidRow( lastrow ) == true ) {
              if ( msg->fieldlv.row == lastrow ) {
                // eventl. Doppelklick
                if ( aguix->isDoubleClick( msg->fieldlv.time, lasttime ) == true ) {
                  ArrayList *files = verz->getFiles();
                  FileEntry *fe = (FileEntry*)files->getElementAt( lastrow );
                  if ( fe != NULL ) {
                    if ( fe->isDir() == true ) {
                      char *tstr = (char*)_allocsafe( strlen( actdir ) + 1 + strlen( fe->name ) + 2 );
                      sprintf( tstr, "%s/%s", actdir, fe->name );
                      setDirOneSelect( tstr );
                      _freesafe( tstr );
                      //if ( sg2 != NULL ) sg2->setText( "" );
                      lastrow = -1;
                      lasttime = 0;
                    } else {
                      endmode = 2;
                    }
                  } else {
                    lastrow = -1;
                    lasttime = 0;
                  }
                } else {
                  lastrow = msg->fieldlv.row;
                  lasttime = msg->fieldlv.time;
                }
              } else {
                lastrow = msg->fieldlv.row;
                lasttime = msg->fieldlv.time;
              }
            } else {
              lastrow = msg->fieldlv.row;
              lasttime = msg->fieldlv.time;
            }
            if ( lv->isValidRow( lastrow ) == true ) {
              if ( lv->getData( lastrow ) == 0 ) {
                // change sg2-text only for selected files
                if ( sg2 != NULL ) sg2->setText( lv->getText( lastrow, 0 ).c_str() );
              }
            }
          }
          break;
        case AG_FIELDLV_MULTISELECT:
          if ( msg->fieldlv.lv == lv ) {
            lastrow = -1;
            lasttime = 0;
            
            trow = lv->getActiveRow();
            if ( lv->isValidRow( trow ) == true ) {
              if ( lv->getData( trow ) == 0 ) {
                // change sg2-text only for selected files
                if ( sg2 != NULL ) sg2->setText( lv->getText( trow, 0 ).c_str() );
              }
            }
          }
          break;
        case AG_KEYPRESSED:
          if ( win->isParent( msg->key.window, false ) == true ) {
            switch ( msg->key.key ) {
              case XK_KP_Enter:
              case XK_Return:
                if ( b[1]->getHasFocus() == false ) {
                  FR_RE_TESTOKAY;
                }
                break;
              case XK_Escape:
                endmode = 0;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage( msg );
    }
  }
  if ( ( endmode == 1 ) || ( endmode == 2 ) ) {
    // okay or doubleclick
#if 0
    char *tstr = (char*)_allocsafe( strlen( actdir ) + 1 + strlen( sg2->getText() ) + 1 );
    if ( last_entry_str != NULL ) _freesafe( last_entry_str );
    last_entry_str = tstr;
#else
    last_entry_str = actdir;
    last_entry_str += "/";
    if ( sg2 != NULL ) {
      last_entry_str += sg2->getText();
    } else {
      trow = lv->getActiveRow();
      if ( lv->isValidRow( trow ) == true ) {
        if ( lv->getText( trow, 0 ).length() > 0 ) {
          if ( lv->getData( trow ) == 0 ) {
            last_entry_str += lv->getText( trow, 0 );
          } else last_entry_str = "";
        } else last_entry_str = "";
      } else last_entry_str = "";
    }
#endif
  }

  delete win;
  delete verz;
  verz = NULL;
  
  delete req;
  
  return endmode;
}

#undef FR_RE_TESTOKAY

void FileRequester::setDirOneSelect( const char *dir )
{
  char *tstr=HandlePath( dir );
  int row;
  
  verz->closeDir();
  if(verz->readDir(tstr)!=0) {
    if(actdir!=NULL) {
      if(verz->readDir(actdir)!=0) return;
    } else verz->readDir("/");
  }
  _freesafe(tstr);
  tstr=dupstring(verz->getDir());
  if(actdir!=NULL) _freesafe(actdir);
  actdir=tstr;
  sg->setText(actdir);
  verz->sort(0);
  ArrayList *files=verz->getFiles();
  FileEntry *fe=(FileEntry*)files->getFirstElement();
  lv->setSize( 0 );
  while(fe!=NULL) {
    row = lv->addRow();
    lv->setText( row, 0, fe->name );
    if(fe->isDir()==false) {
      lv->setPreColors( row, FieldListView::PRECOLOR_ONLYACTIVE );
      lv->setData( row, 0 );
    } else {
      lv->setFG( row, FieldListView::CC_NORMAL, 3 );
      lv->setFG( row, FieldListView::CC_SELECT, 3 );
      lv->setFG( row, FieldListView::CC_ACTIVE, 2 );
      lv->setFG( row, FieldListView::CC_SELACT, 2 );
      lv->setBG( row, FieldListView::CC_NORMAL, 0 );
      lv->setBG( row, FieldListView::CC_SELECT, 0 );
      lv->setBG( row, FieldListView::CC_ACTIVE, 3 );
      lv->setBG( row, FieldListView::CC_SELACT, 3 );
      lv->setData( row, 1 );
    }
    fe=(FileEntry*)files->getNextElement();
  }
  lv->redraw();
}

std::string FileRequester::getLastEntryStr()
{
  return last_entry_str;
}

