/* awindow.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: awindow.h,v 1.39 2005/06/23 18:13:00 ralf Exp $ */

#ifndef AWINDOW_H
#define AWINDOW_H

#include "aguixdefs.h"
#include "aguix.h"
#include "lowlevelfunc.h"
#include "text.h"
#include "request.h"
#include "acontainer.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "widget.h"
#include <list>
#include <string>

class AWindow : public Widget {
public:
  AWindow( AGUIX *parent,
	   int x,
	   int y,
	   int width,
	   int height,
	   int bg,
	   std::string title );
  ~AWindow();
  AWindow( const AWindow &other );
  AWindow &operator=( const AWindow &other );

  Display *getDisplay() const;
  Window getWindow() const;
  Screen *getScreen() const;
  GC *getGC() const;
  AGUIX *getAGUIX() const;
  int setResizable(int state);
  void setMaxSize(int mwidth,int mheight);
  void setMinSize(int mwidth,int mheight);
  void show();
  void show(Window);
  void hide();
  void hide(Window);
  void minimize();
  void toFront();
  void move( int nx, int ny );
  void resize( int nw, int nh );
  void sizeChanged(int width,int height);
  void redraw();
  const char *getTitle() const;
  void setTitle( std::string new_title );
  int getBG() const;
  void setBG(int bg);
  void ReactMessage(Message *msg);
  bool handleMessage(XEvent *,Message *msg);
  void resizeSubWin(Window win,int w,int h);
  void moveSubWin(Window win,int x,int y);
  bool hasSubWin(Window win) const;
  Window getSubWindow(Window parent,int x,int y,int w,int h);
  void removeSubWin(Window subwin);
  bool isParent(Window childwin,bool) const;
  bool isParent( Window ) const;
  Widget *findWidgetForWindow( Window );
  void setCursor(int type);
  void unsetCursor();
  
  void invalidFocus();
  void applyFocus( Widget *newfocus );
  bool isOwner( Widget *f ) const;

  void maximizeX();
  void maximizeY();
  int getBorderWidth() const;
  void setBorderWidth( int nv );

  int addTextFromString( const char *text,
			 int tx,
			 int ty,
			 int vspace,
			 Text ***return_texts,
			 int *return_count,
			 int *return_y );
  void centerScreen();
  bool contains( Widget *elem ) const;
  Widget *getFocusOwner() const;
  void nextFocus();
  void prevFocus();
  void setDoTabCycling( bool nv );
  bool getDoTabCycling() const;
  bool isTopParent( Window childwin );
  bool isVisible() const;
  void useStippleBackground();
  void forbidUserInput();
  void permitUserInput();
  bool getForbidInput() const;
  void setTransientForAWindow( const AWindow *twin = NULL );
#ifdef USE_XIM
  XIC getXIC() const;
  int createXIC();
  void closeXIC();
  void XICdestroyed();
#endif
  bool isTopLevel() const;
  int request( const char *reqtitle,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( const char *reqtitle,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int getMapNr() const;
  AContainer *setContainer( AContainer *newcont, bool autoResize = false );
  void removeContainer( AContainer *cont );
  void removeFromContainer( Widget *twid );

  void contMaximize( bool applyMinSize = false, bool applyMaxSize = false );
  Widget *add( Widget *w );
  void remove( Widget *w );
  void destroy();
  int create();
protected:
  bool onScreen;
  int _bg;
  int maxw,maxh,minw,minh;
  Window win;
  std::list<Window> subwins;
  int border;

  bool doTabCycling;
  int forbidinput;
#ifdef USE_XIM
  XIC inputcontext;
#endif
  Requester *req;
  
  int mapNr;
  AContainer *container;
  bool contAutoResize;
  int msgW, msgH;
  void doCreateStuff();
  void doDestroyStuff();
  int setParent( class AWindow *parent );
  int setWMTitle();
  const std::list<Widget*> &getChilds() const;

  typedef enum { SEARCH_WIDGET, SEARCH_NEXT, SEARCH_FINISHED } focus_search_mode_t;
  int searchNextFocus( focus_search_mode_t &search_mode,
		       const Widget *element,
		       Widget **new_element,
		       Widget **prev_element = NULL );
public:
  Widget *searchNextFocus( const Widget *current );
  Widget *searchPrevFocus( const Widget *current );
private:
  std::list<Widget*> _childs;
  typedef std::list<Widget*>::iterator childs_it;
  typedef std::list<Widget*>::const_iterator childs_const_it;
  std::string _title;
};

#endif
