/* request.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: request.cc,v 1.34 2005/03/24 07:11:40 ralf Exp $ */

#include "request.h"
#include "aguix.h"
#include "awindow.h"
#include "button.h"
#include "text.h"
#include "message.h"
#include "stringgadget.h"
#include "bevelbox.h"
#include "acontainer.h"
#include "acontainerbb.h"
#include "choosebutton.h"

#define ACCEPT_ENTER_FOR_CHOOSE 1

Requester::Requester(AGUIX *parent)
{
  aguix=parent;
  transientawin = NULL;
}

Requester::Requester( class AGUIX *parent, class AWindow *twin )
{
  aguix = parent;
  transientawin = twin;
}

Requester::~Requester()
{
}

int Requester::request(const char *title,const char *text,const char *buttons)
{
  return request( title, text, buttons, REQUEST_NONE );
}

int Requester::request(const char *title,const char *text,const char *buttons, request_flags_t flags)
{
  return request( title, text, buttons, NULL, flags );
}

int Requester::request(const char *title,const char *text,const char *buttons, AWindow *twin, request_flags_t flags)
{
  int i;
  Button **buts;
  int w, h, nbuttons;
  char **buttonss;

  nbuttons=createLines(buttons,&buttonss);
  w = h = 10;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,title);
  if ( twin != NULL ) {
    win->setTransientForAWindow( twin );
  } else if ( transientawin != NULL ) {
    win->setTransientForAWindow( transientawin );
  } else {
    if ( aguix->getTransientWindow() != NULL ) {
      win->setTransientForAWindow( aguix->getTransientWindow() );
    }
  }
  int ty;
  ty=5;

  BevelBox *bb = (BevelBox*)win->add( new BevelBox( aguix, 5, ty, 10, 10, 1 ) );
  ty += 5;

  win->addTextFromString( text, 10, ty, 5, NULL, NULL, &ty );
  ty += 5;
  bb->resize( bb->getWidth(), ty - bb->getY() );
  ty += 5;

  win->maximizeX();
  w = win->getWidth() + 10;

  buts=(Button**)_allocsafe(nbuttons*sizeof(Button*));
  for(i=0;i<nbuttons;i++) {
    buts[i]=(Button*)win->add(new Button(aguix,0,ty,buttonss[i],1,0,i));
  }
  ty+=buts[0]->getHeight()+5;
  AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)buts, NULL, nbuttons );

  win->maximizeX();
  w = win->getWidth() + 10;

  for ( i = 0; i < nbuttons; i++ ) {
    buts[i]->setAcceptFocus( true );
  }
  buts[0]->takeFocus();
  win->setDoTabCycling( true );
  h=ty;
  win->resize(w,h);
  win->useStippleBackground();
  bb->resize( w - 10, bb->getHeight() );
  win->setMinSize(w,h);
  win->setMaxSize( w, h );
  win->centerScreen();
  win->show();
  AGMessage *msg;
  int endmode=-1;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) {
	    if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
	      endmode = 0;
	    } else {
	      endmode = nbuttons - 1;
	    }
	  }
          break;
        case AG_BUTTONCLICKED:
	  for(i=0;i<nbuttons;i++) {
	    if(msg->button.button==buts[i]) {
	      endmode=i;
	      break;
	    }
	  }
          break;
	case AG_KEYPRESSED:
	  if ( win->isParent( msg->key.window, false ) == true ) {
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
#ifdef ACCEPT_ENTER_FOR_CHOOSE
		for ( i = 0; i < nbuttons; i++ ) {
		  if ( buts[i]->hasFocus() == true ) {
		    endmode = i;
		    break;
		  }
		}
#else
		if ( buts[0]->hasFocus() == true ) endmode = 0;
#endif
		break;
	      case XK_Escape:
		if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
		  endmode = 0;
		} else {
		  endmode = nbuttons - 1;
		}
		break;
	      case XK_F1:
	        endmode=0;
	        break;
	      case XK_F2:
	        endmode=1;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F3:
	        endmode=2;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F4:
	        endmode=3;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F5:
	        endmode=4;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F6:
	        endmode=5;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F7:
	        endmode=6;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F8:
	        endmode=7;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F9:
	        endmode=8;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F10:
	        endmode=9;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_Left:
		win->prevFocus();
		break;
  	      case XK_Right:
		win->nextFocus();
		break;
	    }
	  }
	  break;
        case AG_SIZECHANGED:
	  for ( i = 0; i < nbuttons; i++ ) {
	    buts[i]->move( buts[i]->getX(), msg->size.newh - win->getBorderWidth() - buts[i]->getHeight() );
	  }
	  AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, (GUIElement**)buts, NULL, nbuttons );
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  for(i=0;i<nbuttons;i++) _freesafe(buttonss[i]);
  _freesafe(buttonss);
  _freesafe(buts);
  return endmode;
}

int Requester::string_request( const char *title, const char *text, const char *default_str, const char *buttons, char **return_str )
{
  return string_request( title, text, default_str, buttons, return_str, REQUEST_NONE );
}

int Requester::string_request( const char *title, const char *text, const char *default_str, const char *buttons, char **return_str, request_flags_t flags)
{
  return string_request( title, text, default_str, buttons, return_str, NULL, flags );
}

int Requester::string_request( const char *title, const char *text, const char *default_str, const char *buttons,char **return_str, AWindow *twin, request_flags_t flags)
{
  Button **buts;
  int w, h, nbuttons;
  char **buttonss;
  StringGadget *sg;
  int i, ty;
  
  nbuttons=createLines(buttons,&buttonss);
  w = h = 10;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,title);
  if ( twin != NULL ) {
    win->setTransientForAWindow( twin );
  } else if ( transientawin != NULL ) {
    win->setTransientForAWindow( transientawin );
  } else {
    if ( aguix->getTransientWindow() != NULL ) {
      win->setTransientForAWindow( aguix->getTransientWindow() );
    }
  }
  ty=5;

  BevelBox *bb = (BevelBox*)win->add( new BevelBox( aguix, 5, ty, 10, 10, 1 ) );
  ty += 5;

  win->addTextFromString( text, 10, ty, 5, NULL, NULL, &ty );
  ty += 5;
  bb->resize( bb->getWidth(), ty - bb->getY() );
  ty += 5;

  sg=(StringGadget*)win->add(new StringGadget(aguix,5,ty,100,default_str,0));
  sg->setAcceptFocus( true );
  ty+=sg->getHeight()+5;
  buts=(Button**)_allocsafe(nbuttons*sizeof(Button*));
  for ( i = 0; i < nbuttons; i++ ) {
    buts[i] = (Button*)win->add( new Button( aguix, 0, ty, buttonss[i], 1, 0, i ) );
  }
  ty += buts[0]->getHeight() + 5;
  AGUIX::scaleElementsW( w, 5, 10, -1, false, false, (GUIElement**)buts, NULL, nbuttons );

  win->maximizeX();
  w = win->getWidth() + 5;

  for ( i = 0; i < nbuttons; i++ ) {
    buts[i]->setAcceptFocus( true );
  }
  h=ty;
 
  sg->setXOffset( 0 );
  if ( default_str != NULL ) {
    if ( flags == REQUEST_CURSORLEFT ) {
      sg->setCursor( 0 );
    } else if ( flags == REQUEST_CURSORRIGHT ) {
      sg->setCursor( (int)strlen( default_str ) );
    } else if ( flags == REQUEST_SELECTALL ) {
      sg->selectAll();
    }
  }

  sg->takeFocus();
  win->useStippleBackground();
  bb->resize( w - 10, bb->getHeight() );
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMinSize(w,h);
  win->centerScreen();
  win->show();
  AGMessage *msg;
  int endmode=-1;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) {
	    if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
	      endmode = 0;
	    } else {
	      endmode = nbuttons - 1;
	    }
	  }
          break;
        case AG_BUTTONCLICKED:
	  for(i=0;i<nbuttons;i++) {
	    if(msg->button.button==buts[i]) {
	      endmode=i;
	      break;
	    }
	  }
          break;
	case AG_STRINGGADGET_OK:
	  if(msg->stringgadget.sg==sg) endmode=0;
	  break;
	case AG_STRINGGADGET_CANCEL:
	  if ( msg->stringgadget.sg == sg ) {
	    if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
	      endmode = 0;
	    } else {
	      endmode = nbuttons - 1;
	    }
	  }
	  break;
	case AG_KEYPRESSED:
	  if ( win->isParent( msg->key.window, false ) == true ) {
	    // key release only accept when not first key we get
	    // means a key is pressed when we started and if we use this
	    // key it could confuse the user
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
#ifdef ACCEPT_ENTER_FOR_CHOOSE
		for ( i = 0; i < nbuttons; i++ ) {
		  if ( buts[i]->hasFocus() == true ) {
		    endmode = i;
		    break;
		  }
		}
#else
		if ( buts[0]->hasFocus() == true ) endmode = 0;
#endif
		break;
	      case XK_Escape:
		if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
		  endmode = 0;
		} else {
		  endmode = nbuttons - 1;
		}
		break;
	      case XK_F1:
	        endmode=0;
	        break;
	      case XK_F2:
	        endmode=1;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F3:
	        endmode=2;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F4:
	        endmode=3;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F5:
	        endmode=4;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F6:
	        endmode=5;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F7:
	        endmode=6;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F8:
	        endmode=7;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F9:
	        endmode=8;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_F10:
	        endmode=9;
		if(endmode>=nbuttons) endmode = -1;
	        break;
	      case XK_Left:
		win->prevFocus();
		break;
  	      case XK_Right:
		win->nextFocus();
		break;
	    }
	  }
	  break;
        case AG_SIZECHANGED:
	  for ( i = 0; i < nbuttons; i++ ) {
	    buts[i]->move( buts[i]->getX(), msg->size.newh - win->getBorderWidth() - buts[i]->getHeight() );
	  }
	  AGUIX::scaleElementsW( msg->size.neww, 5, -1, -1, true, true, (GUIElement**)(&sg), NULL, 1 );
	  AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, (GUIElement**)buts, NULL, nbuttons );
	  bb->resize( msg->size.neww - 10, bb->getHeight() );
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  if ( return_str != NULL ) {
    *return_str = dupstring( sg->getText() );
  }
  win->close();
  delete win;
  for(i=0;i<nbuttons;i++) _freesafe(buttonss[i]);
  _freesafe(buttonss);
  _freesafe(buts);
  return endmode;
}

int Requester::request_choose( const char *title, const char *text, const char *choose_text, bool &choose_var, const char *buttons )
{
  return request_choose( title, text, choose_text, choose_var, buttons, REQUEST_NONE );
}

int Requester::request_choose( const char *title, const char *text, const char *choose_text, bool &choose_var, const char *buttons, request_flags_t flags )
{
  return request_choose( title, text, choose_text, choose_var, buttons, NULL, flags );
}

int Requester::request_choose( const char *title,
			       const char *text,
			       const char *choose_text,
			       bool &choose_var,
			       const char *buttons,
			       AWindow *twin,
			       request_flags_t flags )
{
  int i;
  Button **buts;
  int nbuttons;
  char **buttonss;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cfixnr = AContainer::ACONT_MINH +
                     AContainer::ACONT_MINW +
                     AContainer::ACONT_MAXH +
                     AContainer::ACONT_MAXW +
                     AContainer::ACONT_NORESIZE;
  int lines;
  char **liness;

  nbuttons = createLines( buttons, &buttonss );
  AWindow *win = new AWindow( aguix );
  win->create( NULL, 10, 10, 10, 10, 0, title );
  if ( twin != NULL ) {
    win->setTransientForAWindow( twin );
  } else if ( transientawin != NULL ) {
    win->setTransientForAWindow( transientawin );
  } else {
    if ( aguix->getTransientWindow() != NULL ) {
      win->setTransientForAWindow( aguix->getTransientWindow() );
    }
  }

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  lines = createLines( text, &liness );

  AContainerBB *ac1_1 = static_cast<AContainerBB*>( ac1->add( new AContainerBB( win, 1, lines ), 0, 0 ) );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );

  for ( i = 0; i < lines; i++ ) {
    ac1_1->add( new Text( aguix, 0, 0, liness[i], 1 ),
		0, i, cincwnr );
  }
  
  for ( i = 0; i < lines; i++ ) _freesafe( liness[i] );
  _freesafe( liness );

  AContainer *ac1_2 = ac1->add( new AContainer( win, 3, 1 ), 0, 1 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( -1 );
  ac1_2->setBorderWidth( 0 );
  ChooseButton *cb1 = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0,
								   0, choose_var,
								   choose_text, LABEL_RIGHT, 1, 1 ),
						 1, 0, cfixnr );
  AContainer *ac1_3 = ac1->add( new AContainer( win, nbuttons, 1 ), 0, 2 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( -1 );
  ac1_3->setBorderWidth( 0 );

  buts = (Button**)_allocsafe( nbuttons * sizeof( Button* ) );
  for ( i = 0; i < nbuttons; i++ ) {
    buts[i] = (Button*)ac1_3->add( new Button( aguix, 0, 0, buttonss[i], 1, 0, i ),
				   i, 0, cfix );
  }
  for ( i = 0; i < nbuttons; i++ ) {
    buts[i]->setAcceptFocus( true );
  }
  buts[0]->takeFocus();

  win->setDoTabCycling( true );
  win->contMaximize( true, true );

  win->useStippleBackground();
  win->centerScreen();
  win->show();

  AGMessage *msg;
  int endmode = -1;
  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) {
	    if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
	      endmode = 0;
	    } else {
	      endmode = nbuttons - 1;
	    }
	  }
          break;
        case AG_BUTTONCLICKED:
	  for ( i = 0; i < nbuttons; i++ ) {
	    if ( msg->button.button == buts[i] ) {
	      endmode = i;
	      break;
	    }
	  }
          break;
	case AG_KEYPRESSED:
	  if ( win->isParent( msg->key.window, false ) == true ) {
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
#ifdef ACCEPT_ENTER_FOR_CHOOSE
		for ( i = 0; i < nbuttons; i++ ) {
		  if ( buts[i]->hasFocus() == true ) {
		    endmode = i;
		    break;
		  }
		}
#else
		if ( buts[0]->hasFocus() == true ) endmode = 0;
#endif
		break;
	      case XK_Escape:
		if ( ( flags & REQUEST_CANCELWITHLEFT ) != 0 ) {
		  endmode = 0;
		} else {
		  endmode = nbuttons - 1;
		}
		break;
	      case XK_F1:
	        endmode = 0;
	        break;
	      case XK_F2:
	        endmode = 1;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F3:
	        endmode = 2;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F4:
	        endmode = 3;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F5:
	        endmode = 4;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F6:
	        endmode = 5;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F7:
	        endmode = 6;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F8:
	        endmode = 7;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F9:
	        endmode = 8;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_F10:
	        endmode = 9;
		if ( endmode >= nbuttons ) endmode = -1;
	        break;
	      case XK_Left:
		win->prevFocus();
		break;
  	      case XK_Right:
		win->nextFocus();
		break;
	    }
	  }
	  break;
      }
      aguix->ReplyMessage( msg );
    }
  }

  choose_var = ( cb1->getState() == 0 ) ? false : true;

  win->close();
  delete win;
  for ( i = 0; i < nbuttons; i++ ) _freesafe( buttonss[i] );
  _freesafe( buttonss );
  _freesafe( buts );
  return endmode;
}
