#!/usr/bin/python
import re

with open("debian/copyright") as infile:
    lines=infile.readlines()

authors={}

currentAuthor=""
currentEmail=""

for l in lines:
    a=re.match(r"author=(.*)", l)
    if a:
        currentAuthor=a.group(1)
    e=re.match(r"address=(.*)", l)
    if e and currentAuthor:
        currentEmail=e.group(1)
        if currentAuthor not in authors:
            authors[currentAuthor]={}
        if currentEmail not in authors[currentAuthor]:
            authors[currentAuthor][currentEmail]=1
        else:
            authors[currentAuthor][currentEmail]+=1
for a in sorted(authors.keys()):
    mostUsedEmail=max(authors[a], key=lambda x: authors[a][x])
    print a, "<%s>" % mostUsedEmail
