#!/usr/local/bin/perl
# apt_find.cgi
# Show a list of all packages from APT

require './software-lib.pl';
&ReadParse();

&header();
print <<EOF;
<script>
function sel(m)
{
window.opener.ifield.value = m;
window.close();
return false;
}
</script>
EOF

print "<form action=apt_find.cgi>\n";
print "<input type=submit value='$text{'apt_search'}'>\n";
print "<input name=search size=20 value='$in{'search'}'>\n";
print "</form><hr>\n";

# Build the list of all packages
open(PKG, "apt-cache search \"$in{'search'}\" |");
while(<PKG>) {
	if (/^(\S+)\s*-\s*(.*)/) {
		push(@list, [ $1, $2 ]);
		}
	}
close(PKG);
@list = sort { $a->[0] cmp $b->[0] } @list;

print "<table width=100% cellpadding=1 cellspacing=1>\n";
if ($in{'search'}) {
	# Show list of matching packages
	foreach $p (@list) {
		print "<tr> <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
		print "<td><a href='' onClick='sel(\"$p->[0]\")'>",
		      "$p->[0]</td>\n";
		print "<td>$p->[1]</td> </tr>\n";
		}
	}
else {
	# Show packages in categories
	foreach $o (split(/\0/, $in{'open'})) {
		if ($in{'close'} ne $o) {
			$open{$o}++;
			$open .= "&open=$o";
			}
		}
	foreach $p (@list) {
		local $l = uc(substr($p->[0], 0, 1));
		$l = "[0-9]" if ($l !~ /[A-Z]/);
		if ($l ne $letter) {
			print "<tr> <td nowrap colspan=3>\n";
			if ($open{$l}) {
				print "<a href='apt_find.cgi?close=$l$open'><img border=0 src=images/close.gif></a>\n";
				}
			else {
				print "<a href='apt_find.cgi?open=$l$open'><img border=0 src=images/open.gif></a>\n";
				}
			print "$l</td> </tr>\n";
			$letter = $l;
			}
		if ($open{$l}) {
			print "<tr> <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
			print "<td><a href='' onClick='sel(\"$p->[0]\")'>",
			      "$p->[0]</td>\n";
			print "<td>$p->[1]</td> </tr>\n";
			}
		}
	}
print "</table>\n";

&ui_print_footer();

