#!/usr/local/bin/perl
# index.cgi
# Display installed perl modules and a form for installing new ones

require './cpan-lib.pl';
$ver = join(".", map { ord($_) } split(//, $^V));
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
		 undef, undef, undef, &text('index_pversion', $ver));

# Display perl modules
@mods = &list_perl_modules();
if (@mods) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
	      "<td><b>$text{'index_sub'}</b></td> ",
	      "<td><b>$text{'index_desc'}</b></td> ",
	      "<td><b>$text{'index_ver'}</b></td> ",
	      "<td><b>$text{'index_date'}</b></td> </tr>\n";
	foreach $m (sort { lc($a->{'mods'}->[$a->{'master'}]) cmp
			   lc($b->{'mods'}->[$b->{'master'}]) } @mods) {
		local $mi = $m->{'master'};
		print "<tr $cb>\n";
		local $name = &html_escape($m->{'mods'}->[$mi]);
		if ($m->{'rpm'}) {
			$name = "<b>$name</b>";
			}
		print "<td><a href='edit_mod.cgi?idx=$m->{'index'}&midx=$mi'>",
		      $name,"</a></td>\n";
		printf "<td>%d</td>\n", @{$m->{'mods'}} - 1;
		local ($desc, $ver) = &module_desc($m, $mi);
		print "<td>",$desc ? &html_escape($desc) : "<br>","</td>\n";
		print "<td>",$ver || "<br>","</td>\n";
		print "<td nowrap><tt>",&html_escape($m->{'date'}),
		      "</tt></td>\n";
		print "</tr>\n";
		}
	print "</table><p>\n";
	print "<hr>\n";
	}

# Display install form
print "$text{'index_installmsg'}<p>\n";
print "<form action=download.cgi method=post enctype=multipart/form-data>\n";
print "<input type=radio name=source value=3 checked> $text{'index_cpan'}\n";
print "<input name=cpan size=40>\n";
print "<input type=button onClick='window.ifield = document.forms[0].cpan; chooser = window.open(\"cpan.cgi\", \"chooser\", \"toolbar=no,menubar=no,scrollbars=yes,width=400,height=300\")' value=\"...\">\n";
@st = stat($packages_file);
if (@st) {
	$now = time();
	print "<br>&nbsp;&nbsp;&nbsp;\n";
	printf "<input type=checkbox name=refresh value=1 %s> %s\n",
		$st[9]+$config{'refresh_days'}*24*60*60 < $now ? "checked" : "",
		$text{'index_refresh'};
	}
print "<br>\n";

print "<input type=radio name=source value=0> $text{'index_local'}\n";
print "<input name=local size=50>\n";
print &file_chooser_button("local", 0); print "<br>\n";

print "<input type=radio name=source value=1> $text{'index_uploaded'}\n";
print "<input type=file name=upload size=20><br>\n";

print "<input type=radio name=source value=2> $text{'index_ftp'}\n";
print "<input name=url size=50><br>\n";
print "<input type=submit value=\"$text{'index_installok'}\">\n";
print "</form>\n";

&ui_print_footer("/", $text{'index'});

