#!/usr/local/bin/perl
# Add needed firewall rules and syslog entry, and apply configurations

require './bandwidth-lib.pl';
&ReadParse();
$access{'setup'} || &error($text{'setup_ecannot'});

# Add missing firewall rules
$err = &setup_rules($in{'iface'});
&error($err) if ($err);

# Add syslog entry
$conf = &syslog::get_config();
$sysconf = &find_sysconf($conf);
if (!$sysconf) {
	&lock_file($syslog::config{'syslog_conf'});
	if ($syslog::config{'tags'}) {
		local $conf = &syslog::get_config();
		($tag) = grep { $_->{'tag'} eq '*' } @$conf;
		}
	&syslog::create_log({ 'file' => $bandwidth_log,
			      'active' => 1,
			      'section' => $tag,
			      'sel' => [ &get_loglevel() ] });
	&unlock_file($syslog::config{'syslog_conf'});
	$err = &syslog::restart_syslog();
	&error($err) if ($err);
	}

# Save the interface
&lock_file($module_config_file);
$config{'iface'} = $in{'iface'};
&save_module_config();
&unlock_file($module_config_file);

# Setup the rotation cron job
$job = &find_cron_job();
if (!$job) {
	&cron::create_wrapper($cron_cmd, $module_name, "rotate.pl");
	$job = { 'user' => 'root',
		 'active' => 1,
		 'command' => $cron_cmd,
		 'mins' => '0',
		 'hours' => '*',
		 'days' => '*',
		 'months' => '*',
		 'weekdays' => '*',
		};
	&lock_file(&cron::cron_file($job));
	&cron::create_cron_job($job);
	&unlock_file(&cron::cron_file($job));
	}

&webmin_log("setup", undef, $in{'iface'});
&redirect("");

