# raid-monitor.pl
# Check if some RAID device is reporting errors

sub get_raid_status
{
&foreign_require("raid", "raid-lib.pl");
local $conf = &raid::get_raidtab();
local ($raid) = grep { $_->{'value'} eq $_[0]->{'device'} } @$conf;
if ($raid) {
	if (ref($raid->{'errors'})) {
		local ($bad) = grep { $_ eq "_" } @{$raid->{'errors'}};
		if ($bad) {
			return { 'up' => 0,
				 'desc' => $text{'raid_bad'} };
			}
		else {
			return { 'up' => 1 };
			}
		}
	elsif ($raid->{'resync'}) {
		return { 'up' => 0,
			 'desc' => $text{'raid_resync'} };
		}
	else {
		return { 'up' => 1 };
		}
	}
else {
	return { 'up' => -1,
		 'desc' => &text('raid_notfound', $_[0]->{'device'}) };
	}
}

sub show_raid_dialog
{
&foreign_require("raid", "raid-lib.pl");
local $conf = &raid::get_raidtab();
print "<tr> <td><b>$text{'raid_device'}</b></td>\n";
print "<td><select name=device>\n";
foreach $c (@$conf) {
	local $lvl = &raid::find_value('raid-level', $c->{'members'});
	printf "<option value=%s %s>%s - %s\n",
		$c->{'value'},
		$_[0]->{'device'} eq $c->{'value'} ? "selected" : "",
		$c->{'value'},
		$lvl eq 'linear' ? $raid::text{'linear'}
				 : $raid::text{"raid$lvl"};
	}
print "</select></td> </tr>\n";
}

sub parse_raid_dialog
{
&depends_check($_[0], "raid");
$in{'device'} || &error($text{'raid_edevice'});
$_[0]->{'device'} = $in{'device'};
}

