#!/usr/local/bin/perl
# index.cgi
# Display all existing databases

require './mysql-lib.pl';

# Check for MySQL programs
if (!-x $config{'mysqladmin'}) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print ,&text('index_eadmin', "<tt>$config{'mysqladmin'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}
if (!-x $config{'mysql'}) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print &text('index_esql', "<tt>$config{'mysql'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}
$mysql_version = &get_mysql_version(\$out);
if ($mysql_version < 0) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print &text('index_elibrary', "<tt>$config{'mysql'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print &text('index_mysqlver', "$config{'mysql'} -V"),"\n";
	print "<pre>$out</pre>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}
elsif (!$mysql_version) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print &text('index_ever', "<tt>$config{'mysql'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print &text('index_mysqlver', "$config{'mysql'} -V"),"\n";
	print "<pre>$out</pre>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}
open(VERSION, ">$module_config_directory/version");
print VERSION $mysql_version,"\n";
close(VERSION);

$r = &is_mysql_running();
if ($r == 0) {
	# Not running .. need to start it
	&main_header();
	print "<p> <b>$text{'index_notrun'}</b> <p>\n";

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=start.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_start'}\"></td>\n";
		print "<td>",&text('index_startmsg',
		      "<tt>$config{'start_cmd'}</tt>"),"</td> </tr></table>\n";
		print "</form>\n";
		}
	}
elsif ($r == -1 && $access{'user'} && 0) {
	# Running, but the user's password is wrong
	&main_header();
	print "<p> <b>",&text('index_nouser', "<tt>$access{'user'}</tt>"),
	      "</b><p>\n";
	}
elsif ($r == -1) {
	# Running, but webmin doesn't know the root (or user's) password!
	&main_header();
	print "<p> <b>$text{'index_nopass'}</b> <p>\n";
	print "<form action=login.cgi method=post>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'index_ltitle'}</b></td> </tr>\n";
	print "<tr $cb> <td><table cellpadding=2>\n";
	print "<tr> <td><b>$text{'index_login'}</b></td>\n";
	printf "<td><input name=login size=20 value='%s'></td> </tr>\n",
		$access{'user'} || $config{'login'};
	print "<tr> <td><b>$text{'index_pass'}</b></td>\n";
	print "<td><input name=pass size=20 type=password></td>\n";
	print "</tr> </table></td></tr></table>\n";
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=reset value='$text{'index_clear'}'>\n";
	print "</center></form>\n";
	}
else {
	# Check if we can re-direct to a single DB's page
	@alldbs = &list_databases();
	@titles = grep { &can_edit_db($_) } @alldbs;
	$can_all = (@alldbs == @titles);
	if (@titles == 1 && $access{'dbs'} ne '*' && !$access{'perms'} &&
	    !$access{'stop'} && !$access{'create'} && $access{'noconfig'}) {
		# Only one DB, so go direct to it!
		&redirect("edit_dbase.cgi?db=$titles[0]");
		exit;
		}

	# DB is running .. list databases
	&main_header();
	print "<h3>$text{'index_dbs'}</h3>\n";
	@icons = map { "images/db.gif" } @titles;
	@links = map { "edit_dbase.cgi?db=$_" } @titles;
	$can_create = $access{'create'} == 1 ||
		      $access{'create'} == 2 && @titles < $access{'max'};
	if (!@icons) {
		print "<b>$text{'index_nodbs'}</b> <p>\n";
		}
	else {
		print "<a href=newdb_form.cgi>$text{'index_add'}</a> <br>\n"
			if ($can_create);
		if ($config{'style'}) {
			@tables = map { @t = &list_tables($_); scalar(@t) }
				      @titles;
			@titles = map { &html_escape($_) } @titles;
			&split_table([ $text{'index_db'},
				       $text{'index_tables'} ],
				     \@links, \@titles, \@tables) if (@titles);
			}
		else {
			@titles = map { &html_escape($_) } @titles;
			&icons_table(\@links, \@titles, \@icons, 5);
			}
		}
	print "<a href=newdb_form.cgi>$text{'index_add'}</a> <p>\n"
		if ($can_create);

	if ($access{'perms'}) {
		print "<hr>\n";
		print "<h3>$text{'index_global'}</h3>\n";
		@links = ( 'list_users.cgi', 'list_dbs.cgi', 'list_hosts.cgi',
			   'list_tprivs.cgi', 'list_cprivs.cgi' );
		@titles = ( $text{'users_title'}, $text{'dbs_title'},
			    $text{'hosts_title'}, $text{'tprivs_title'},
			    $text{'cprivs_title'} );
		@images = ( 'images/users.gif', 'images/dbs.gif',
			    'images/hosts.gif', 'images/tprivs.gif',
			    'images/cprivs.gif' );
		if ($access{'perms'} == 2) {
			shift(@links); shift(@titles); shift(@images);
			}
		&icons_table(\@links, \@titles, \@images, 5);
		}

	# Show stop button
	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=stop.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_stop'}\"></td>\n";
		print "<td>$text{'index_stopmsg'}</td> </tr></table>\n";
		print "</form>\n";
		}

	# Show backup all button
	if ($can_all && !$access{'edonly'} && $access{'buser'}) {
		print "<hr>\n" if (!$access{'stop'});
		print "<form action=backup_form.cgi>\n";
		print "<input type=hidden name=all value=1>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_backup'}\"></td>\n";
		print "<td>$text{'index_backupmsg'}</td> </tr></table>\n";
		print "</form>\n";
		}

	# Check if the optional perl modules are installed
	&read_acl(\%acl, undef);
	if ($acl{$base_remote_user, 'cpan'}) {
		eval "use DBI";
		push(@needs, "DBI") if ($@);
		$nodbi++ if ($@);
		eval "use DBD::mysql";
		push(@needs, "DBD::mysql") if ($@);
		if (@needs) {
			$needs = &urlize(join(" ", @needs));
			print "<center><b>",&text(@needs == 2 ? 'index_nomods' : 'index_nomod', @needs,
				"/cpan/download.cgi?source=3&cpan=$needs&mode=2&return=/$module_name/&returndesc=".&urlize($text{'index_return'})),
				"</b></center>\n";
			}
		}
	}

&ui_print_footer("/", "index");

sub main_header
{
&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("mysql", "man", "doc", "google"),
	undef, undef, &text('index_version', $mysql_version));
}

