# dhcpd-monitor.pl
# Monitor the DHCP server on this host

# Check the PID file to see if DHCPd is running
sub get_dhcpd_status
{
&foreign_require($_[1], "dhcpd-lib.pl");
local %dconfig = &foreign_config($_[1]);
return { 'up' => -1 } if (!-r $dconfig{'dhcpd_conf'});
if (open(PID, $dconfig{'pid_file'}) && <PID> =~ /(\d+)/ && kill(0, $1)) {
	close(PID);
	local @st = stat($dconfig{'pid_file'});
	return { 'up' => 1,
		 'desc' => &text('up_since', scalar(localtime($st[9]))) };
	}
else {
	return { 'up' => 0 };
	}
}

sub parse_dhcpd_dialog
{
&depends_check($_[0], "dhcpd");
}

1;

