#!/usr/local/bin/perl
# index.cgi
# List all LDAP users for editing

require './ldap-useradmin-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

# Make sure the LDAP NSS client config file exists, or the needed information
# has been provided
if ($config{'auth_ldap'}) {
	if (!-r $config{'auth_ldap'}) {
		print "<p>",&text('index_econfig',
			"<tt>$config{'auth_ldap'}</tt>",
			"$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}
else {
	if (!$config{'ldap_host'} || !$config{'login'} || !$config{'pass'} ||
	    !$config{'user_base'} || !$config{'group_base'}) {
		print "<p>",&text('index_ehost',
			"$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}

# Make sure the LDAP Perl module is installed, and if not offer to install
if (!$got_net_ldap) {
	$missing = $net_ldap_error =~ /ASN1/ ? "Convert::ASN1" : "Net::LDAP";
	print "<p>",&text('index_eperl', "<tt>$missing</tt>",
			  "/cpan/download.cgi?source=3&cpan=$missing&mode=2&".
			  "return=/$module_name/&returndesc=".
			  &urlize($text{'index_return'})),"<p>\n";
	print "$text{'index_eperl2'}\n";
	print "<pre>$net_ldap_error</pre>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Try to login .. may fail
$ldap = &ldap_connect(1);
if (!ref($ldap)) {
	print "<p>",&text('index_eldap', $ldap,
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	exit;
	}

if ($config{'imap_host'}) {
	# Make sure the IMAP Perl module is installed, and if not offer
	# to install
	if (!$got_net_imap) {
		print "<p>",&text('index_eperl', "<tt>Net::IMAP</tt>",
			  "/cpan/download.cgi?source=3&cpan=Net::IMAP&mode=2&".
			  "return=/$module_name/&returndesc=".
			  &urlize($text{'index_return'})),"<p>\n";
		print "$text{'index_eperl2'}\n";
		print "<pre>$net_imap_error</pre>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}

	# Try to connect to the IMAP server
	$imap = &imap_connect(1);
	if (!ref($imap)) {
		print "<p>",&text('index_eimap', $imap,
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}

# If using MD5, make sure needed perl modules are installed
if ($config{'md5'}) {
	# Check if MD5 perl module is installed, and offer to install
	&foreign_require("useradmin", "user-lib.pl");
	if ($err = &useradmin::check_md5()) {
		print "<p>",&text('index_emd5',
				  "../config.cgi?$module_name",
				  "<tt>$err</tt>",
				  "../cpan/download.cgi?source=3&cpan=Digest::MD5&mode=2&return=/$module_name/&returndesc=".&urlize($text{'index_return'})),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}

# Get the list of users
$base = &get_user_base();
$rv = $ldap->search(base => $base,
		    filter => '(objectClass=posixAccount)');
if ($rv->code) {
	&error(&text('index_eusearch', "<tt>$base</tt>", $rv->error));
	}
else {
	if ($rv->count > $uconfig{'display_max'}) {
		# Show user search form
		print "<b>$text{'index_toomany'}</b><br>\n";
		print "<form action=search_user.cgi>\n";
		print "<b>$text{'index_find'}</b> <select name=field>\n";
		print "<option value=uid selected>$text{'user'}\n";
		print "<option value=cn>$text{'real'}\n";
		print "<option value=loginShell>$text{'shell'}\n";
		print "<option value=homeDirectory>$text{'home'}\n";
		print "<option value=uidNumber>$text{'uid'}\n";
		print "</select> <select name=match>\n";
		print "<option value=0 checked>$text{'index_equals'}\n";
		print "<option value=1>$text{'index_contains'}\n";
		print "<option value=2>$text{'index_nequals'}\n";
		print "<option value=3>$text{'index_ncontains'}\n";
		print "</select> <input name=what size=15>&nbsp;&nbsp;\n";
		print "<input type=submit value=\"$text{'find'}\"></form>\n";
		}
	elsif (@users = $rv->all_entries) {
		# Show table of all users
		print "<a href='edit_user.cgi?new=1'>$text{'index_uadd'}</a><br>\n";
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'user'}</b></td> ",
		      "<td><b>$text{'uid'}</b></td> ",
		      "<td><b>$text{'real'}</b></td> ",
		      "<td><b>$text{'home'}</b></td> ",
		      "<td><b>$text{'shell'}</b></td> ",
		      "<td><b>$text{'index_samba'}</b></td> ",
		      "<td><b>$text{'index_cyrus'}</b></td> </tr>\n";
		foreach $u (sort { lc($a->dn()) cmp lc($b->dn()) } @users) {
			%classes = map { $_, 1 } $u->get_value("objectClass");
			print "<tr $cb>\n";
			print "<td><a href='edit_user.cgi?dn=",
				&urlize($u->dn()),"'>",
				$u->get_value('uid'),"</a></td>\n";
			print "<td>",$u->get_value('uidNumber'),"</td>\n";
			print "<td>",$u->get_value('cn') || "<br>",
			      "</td>\n";
			print "<td>",$u->get_value('homeDirectory') || "<br>",
			      "</td>\n";
			print "<td>",$u->get_value('loginShell') || "<br>",
			      "</td>\n";
			print "<td>",$classes{$samba_class} ? $text{'yes'}
						    : $text{'no'},"</td>\n";
			print "<td>",$classes{$cyrus_class} ? $text{'yes'}
						    : $text{'no'},"</td>\n";
			print "</tr>\n";
			}
		print "</table>\n";
		}
	else {
		print "<b>",&text('index_unone', "<tt>$base</tt>"),"</b><p>\n";
		}
	print "<a href='edit_user.cgi?new=1'>$text{'index_uadd'}</a><p>\n";
	}

print "<hr>\n";

# Get the list of groups
$base = &get_group_base();
$rv = $ldap->search(base => $base,
		    filter => '(objectClass=posixGroup)');
if ($rv->code) {
	&error(&text('index_egsearch', "<tt>$base</tt>", $rv->error));
	}
else {
	if ($rv->count > $uconfig{'display_max'}) {
		# Show group search form
		print "<b>$text{'index_gtoomany'}</b><br>\n";
		print "<form action=search_group.cgi>\n";
		print "<b>$text{'index_gfind'}</b> <select name=field>\n";
		print "<option value=cn selected>$text{'gedit_group'}\n";
		print "<option value=memberUid>$text{'gedit_members'}\n";
		print "<option value=gidNumber>$text{'gedit_gid'}\n";
		print "</select> <select name=match>\n";
		print "<option value=0 checked>$text{'index_equals'}\n";
		print "<option value=1>$text{'index_contains'}\n";
		print "<option value=2>$text{'index_nequals'}\n";
		print "<option value=3>$text{'index_ncontains'}\n";
		print "</select> <input name=what size=15>&nbsp;&nbsp;\n";
		print "<input type=submit value=\"$text{'find'}\"></form>\n";
		}
	elsif (@groups = $rv->all_entries) {
		# Show table of all groups
		print "<a href='edit_group.cgi?new=1'>$text{'index_gadd'}</a><br>\n";
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'gedit_group'}</b></td> ",
		      "<td><b>$text{'gedit_gid'}</b></td> ",
		      "<td><b>$text{'gedit_members'}</b></td> </tr>\n";
		foreach $g (sort { lc($a->dn()) cmp lc($b->dn()) } @groups) {
			print "<tr $cb>\n";
			print "<td><a href='edit_group.cgi?dn=",
				&urlize($g->dn()),"'>",
				$g->get_value('cn'),"</a></td>\n";
			print "<td>",$g->get_value('gidNumber'),"</td>\n";
			print "<td>",(join(" ", $g->get_value("memberUid")) ||
				      "<br>"),"</td>\n";
			print "</tr>\n";
			}
		print "</table>\n";
		}
	else {
		print "<b>",&text('index_gnone', "<tt>$base</tt>"),"</b><p>\n";
		}
	print "<a href='edit_group.cgi?new=1'>$text{'index_gadd'}</a><p>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

