#!/usr/local/bin/perl
# edit_cfd.cgi
# Display options for the cfengine daemon on this host

require './cfengine-lib.pl';
&header($text{'cfd_title'}, "", "cfd");
print "<hr>\n";

if (!&has_command($config{'cfd'})) {
	print "<p>",&text('cfd_ecmd', "<tt>$config{'cfd'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Display table of daemon options
$conf = &get_cfd_config();
@secs = grep { $_->{'type'} eq 'section' } @$conf;
&show_classes_table(\@secs, 1);

# Allow starting or stopping of cfd
($pid) = &find_byname("cfd");
print "<hr>\n";
print "<table width=100%><tr>\n";
if ($pid) {
	print "<form action=stop.cgi>\n";
	print "<td><input type=submit value='$text{'cfd_stop'}'></td>\n";
	print "<td>$text{'cfd_stopdesc'}</td>\n";
	print "</form>\n";
	}
else {
	print "<form action=start.cgi>\n";
	print "<td><input type=submit value='$text{'cfd_start'}'></td>\n";
	print "<td>$text{'cfd_startdesc'}</td>\n";
	print "</form>\n";
	}
print "</tr></table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

