# -*- coding: utf-8 -*-
"""
utctime.py - various functions for parsing display UTCTime
(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: utctime.py,v 1.9 2011/05/26 16:02:53 michael Exp $
"""

import time

def strptime(s):
  """
  Parse a UTC time string.
  """
  s = s.split('.')[0].strip()
  return time.strptime(s,'%Y%m%d%H%M%SZ')


def strftimeiso8601(t):
  """
  Return a UTC datetime string.
  """
  return time.strftime('%Y-%m-%dT%H:%M:%SZ',t)
