do_l10n_merge = 0
import sys

def do_system_call( call, log=False ):
  import os
  if log:
    call = call + " >> build-log.txt"
  result = os.system(call)
  if result != 0:
    print("Failure: " + str(result))
    sys.exit()
  return

def print_and_log( msg ):
  print(msg)
  do_system_call('echo ' + msg + ' >> build-log.txt')
  return

# languages to be built

languages = 0
releaseBuild = False
version = "default"
args = sys.argv[1:]
if len(args) > 1:
  for i in range(len(args)):
    if args[i] == "-v":
      version = args[i+1]
    elif args[i] == "-release":
      releaseBuild = True
    elif args[i] == "-locales":
      languages = args[i+1].split(",")

print("Starting Firefox Sync build")
print("Version: " + version)
print("Release Build" if releaseBuild else "Developer Build")
if languages:
  print("Languages: " + ", ".join(languages))
else:
  print("Languages: none")

import os

do_system_call('rm -rf *')
print_and_log('Pulling all locales: ')
for lang in languages:
  print_and_log("pulling " + lang)
  do_system_call('hg clone https://hg.mozilla.org/weave-l10n/' + lang + " " + lang, True)

if do_l10n_merge:
  print_and_log('Comparing and merging locales with en-US: ')
  do_system_call('hg clone https://hg.mozilla.org/weave-l10n/en-US en-US', True)
  for lang in languages:
    print('building ' + lang)
    do_system_call('rm -rf temp/*', True)
    do_system_call('compare-dirs --merge="temp" en-US ' + lang, True)
    do_system_call('cp temp/* ' + lang, True)

print_and_log('cleaning up l10n dirs')
do_system_call('rm -rf temp')
do_system_call('rm -rf */.hg')
do_system_call('rm -rf */.hgtags')

print_and_log('pulling fx-sync')
do_system_call('hg clone https://hg.mozilla.org/services/fx-sync sync-main', True)
do_system_call('cd sync-main && hg update ' + version, True)

print_and_log('adding locales to build')
do_system_call('mkdir -p sync-main/dist/stage/chrome/locale')
for lang in languages:
  os.system('cp -Rv ' + lang + " sync-main/dist/stage/chrome/locale/" + lang + ' >> build-log.txt')

f = open("./sync-main/addon/chrome.manifest.in", "a")
for lang in languages:
  f.write("@jar@locale weave " + lang + " jar:chrome/sync.jar!/locale/" + lang + "/\n")
f.close();

print_and_log('building localized xpi')
buildArgs = ""
if releaseBuild:
  buildArgs = " release_build=1"
do_system_call('cd sync-main && make xpi' + buildArgs, True)
do_system_call('cp sync-main/dist/xpi/* .', True)

print('build complete!')
