#ifndef MISC_H
#define MISC_H

#include <qpoint.h>
#include <iostream>

using namespace std;

enum LoadMode {NewMap,ImportAdd,ImportReplace};
enum SaveMode {PartOfMap,CompleteMap,UndoCommand};

/////////////////////////////////////////////////////////////////////////////
QString qpointToString (const QPoint &p);
extern ostream &operator<< (ostream &stream, QPoint const &p);
float getAngle(const QPoint &);
QPoint normalise (const QPoint &);
QString maskPath (QString );
QString convertToRel (const QString &,const QString &);
QString quotemeta(const QString&);	
int max (int,int);
class BranchObj;
class MapEditor;

/////////////////////////////////////////////////////////////////////////////
class xmlObj
{
public:
    xmlObj();
    QString singleElement(QString,QString);
    QString beginElement(QString,QString);
    QString beginElement(QString);
    QString endElement  (QString);
    QString attribut    (QString,QString);
    QString valueElement(QString,QString);
    QString valueElement(QString,QString,QString);
    void incIndent();
    void decIndent();
    static int actindent;

protected:  
    QString indent();
    int indentwidth;
};

/////////////////////////////////////////////////////////////////////////////

#include <qlabel.h>
#include <qfiledialog.h>
#include <qpixmap.h>

class ImagePreview : public QLabel, public QFilePreview
{
public:
    ImagePreview( QWidget * );
    void previewUrl( const QUrl & );
};

#endif
