#include "floatimageobj.h"
#include "branchobj.h"


/////////////////////////////////////////////////////////////////
// FloatImageObj
/////////////////////////////////////////////////////////////////

int FloatImageObj::counter=0;		// make instance 


FloatImageObj::FloatImageObj ():FloatObj()
{
//    cout << "Const FloatImageObj ()\n";
    setParObj (this);	
    init();
    depth=-1;
}

FloatImageObj::FloatImageObj (QCanvas* c):FloatObj(c)
{
 //   cout << "Const FloatImageObj (c)  called from MapCenterObj (c)\n";
    setParObj (this);	
    init();
    depth=-1;
}

FloatImageObj::FloatImageObj (QCanvas* c, LinkableMapObj* p):FloatObj(c,p)
{
 //   cout << "Const FloatImageObj (c,p)\n";
    init();
}

FloatImageObj::~FloatImageObj ()
{
//	cout << "Destr FloatImageObj "<<this<<"\n";
	delete(icon);
}

void FloatImageObj::init () 
{
	icon=new ImageObj (canvas);
	icon->move (absPos.x(), absPos.y() );
	icon->setVisibility (true);
	bbox.setSize (QSize(icon->size().width(), icon->size().height()));
	filename="";
	originalFilename="no original name available";
	filetype="";
	saveInMap=true;
}

void FloatImageObj::copy (FloatImageObj* other)
{					
	FloatObj::copy (other);
	icon->copy (other->icon);
	filename=other->filename;
	saveInMap=other->saveInMap;
    positionBBox();
}

void FloatImageObj::setZ (const int &i)
{
	icon->setZ (i);
	zPlane=i;
}

int FloatImageObj::z ()
{
	return qRound (icon->z());
}

void FloatImageObj::load (const QPixmap &pixmap)
{
  icon->load(pixmap);
  bbox.setSize (QSize(icon->size().width()+8, icon->size().height()+8));
  positionBBox();
  filetype="PNG";
  filename="noname.png";
}

bool FloatImageObj::load (const QString &fn)
{	
	if( icon->load (fn))
	{
		bbox.setSize (QSize(icon->size().width()+8, icon->size().height()+8));
		positionBBox();
		filename=fn;
		filetype=QPixmap::imageFormat (fn);
		return true;
	} else
		return false;
	
}

void FloatImageObj::save (const QString &fn, const char *format)
{	
	icon->save (fn,format);
}

void FloatImageObj::setOriginalFilename(const QString & fn)
{
	originalFilename=fn;
}

QString FloatImageObj::getOriginalFilename()
{
	return originalFilename;
}

void FloatImageObj::setVisibility(bool v)
{
    LinkableMapObj::setVisibility(v);
	if (v)
	    icon->setVisibility(true);
	else
	    icon->setVisibility(false);
}

void FloatImageObj::move (double x, double y)
{
	FloatObj::move(x,y);
	icon->move (x+4,y+4);
    positionBBox();
}

void FloatImageObj::move (QPoint p)
{
	move (p.x(), p.y());
}

void FloatImageObj::positionBBox()
{
	// TODO
}

void FloatImageObj::calcBBoxSize()
{
	// TODO
}

QString FloatImageObj::saveToDir (const QString &tmpdir,const QString &prefix)
{
	counter++;

	QString posAttr=
		attribut("relPosX",QString().setNum(relPos.x(),10)) +
		attribut("relPosY",QString().setNum(relPos.y(),10)); 

	QString useOrientAttr;
	if (useOrientation)
		useOrientAttr=attribut ("useOrientation","true");
	else	
		useOrientAttr=attribut ("useOrientation","false");
		
	QString saveInMapAttr;
	if (saveInMap)
		saveInMapAttr=attribut ("saveInMap","true");
	else	
		
		saveInMapAttr=attribut ("saveInMap","false");

	QString exportAttr;
	if (floatExport)
		exportAttr=attribut ("floatExport","true");
	else	
		exportAttr=attribut ("floatExport","false");

	QString zAttr=attribut ("zPlane",QString().setNum(zPlane));
	QString url;

	// prevent saving as GIF
	if (filetype=="GIF")
		filetype="PNG";
		
	url="images/"+prefix+"image-" + QString().number(counter,10) + "." +filetype;

	// And really save the image
	icon->save (tmpdir + "/" + url, filetype);

    return singleElement ("floatimage",  
		posAttr + 
		useOrientAttr + 
		saveInMapAttr + 
		exportAttr + 
		zAttr + 
		attribut ("href",QString ("file:")+url)
	);	
}

void FloatImageObj::resetSaveCounter()
{
	counter=0;
}


QRect FloatImageObj::getTotalBBox()
{
	return bbox;
}

QRect FloatImageObj::getBBoxSizeWithChilds()
{
	//FIXME  abstract in linkablemapobj.h, not calculated
	return bboxTotal;
}

void FloatImageObj::calcBBoxSizeWithChilds()
{
	//FIXME  abstract in linkablemapobj.h
}

QString FloatImageObj::getSelectString()
{
	QString s;
	if (parObj)
	{
		if (parObj->getDepth()==0)
			s= "fi:" + QString("%1").arg( ((BranchObj*)(parObj))->getFloatImageNum(this));
		else	
			s= ((BranchObj*)(parObj))->getSelectString() + ",fi:" + QString("%1").arg( ((BranchObj*)(parObj))->getFloatImageNum(this));
	} else
		s="mc:";
	
	return s;

}

