/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


extern Settings settings;

void ExportXHTMLDialog::init()
{
	dia=new ShowTextDialog ();
	xsltprocessor="xsltproc";
	filepath="";
	settingsChanged=false;
}

void ExportXHTMLDialog::readSettings()
{

	dir=settings.readLocalEntry (filepath,"/vym/export/xhtml/exportDir","./" );
	lineEditDir->setText(dir);
	
	
    if ( settings.readLocalEntry (filepath,"/vym/export/xhtml/useImage","yes")=="yes")
		useImage=true;
	else	
		useImage=false;
	imageButton->setChecked(useImage);
		
	if ( settings.readLocalEntry (filepath,"/vym/export/xhtml/useTextColor","no")=="yes")
		useTextColor=true;
	else	
		useTextColor=false;
	textColorButton->setChecked(useTextColor);
	
/* FIXME this was used in old html export, is not yet in new stylesheet
	if ( settings.readEntry ("/vym/export/html/useHeading","no")=="yes")
		useHeading=true;
	else	
		useHeading=false;
	checkBox4_2->setChecked(useHeading);
*/		

	if ( settings.readLocalEntry (filepath,"/vym/export/xhtml/saveSettingsInMap","no")=="yes")
		saveSettingsInMap=true;
	else	
		saveSettingsInMap=false;
	saveSettingsInMapButton->setChecked(saveSettingsInMap);

	if ( settings.readEntry ("/vym/export/xhtml/showWarnings","yes")=="yes")
		showWarnings=true;
	else	
		showWarnings=false;
	warningsButton->setChecked(showWarnings);
	
	if ( settings.readEntry ("/vym/export/xhtml/showOutput","no")=="yes")
		showOutput=true;
	else	
		showOutput=false;
	outputButton->setChecked(showOutput);

	xsl=settings.readLocalEntry 
		(filepath,"/vym/export/xhtml/xsl","/usr/share/vym/styles/vym2xhtml.xsl");
	lineEditXSL->setText(xsl);
	
	css=settings.readLocalEntry 
		(filepath,"/vym/export/xhtml/css","/usr/share/vym/styles/vym.css");	
	lineEditCSS->setText(css);
	
	prescript=settings.readLocalEntry
		(filepath,"/vym/export/xhtml/prescript","");
	lineEditPreScript->setText (prescript);	
	
	postscript=settings.readLocalEntry
		(filepath,"/vym/export/xhtml/postscript","");
	lineEditPostScript->setText (postscript);	

	if (!prescript.isEmpty() || !postscript.isEmpty())
	{
		QMessageBox::warning( 0, tr( "Warning" ),tr(
		"The settings saved in the map "
		"would like to run scripts:\n\n") +
		prescript +"  "+postscript +"\n\n"+
		tr("Please check, if you really\n"
		"want to allow this in your system!"));
		
	}
}

void ExportXHTMLDialog::destroy()
{
	delete (dia);
}

void ExportXHTMLDialog::dirChanged()
{
	dir=lineEditDir->text();
	if (dir.right(1)!="/")
		dir+="/";
	settingsChanged=true;
}

void ExportXHTMLDialog::browseDirectoryPressed()
{
   	QFileDialog fd( this, tr("VYM - Export HTML to directory"));
	fd.setMode (QFileDialog::DirectoryOnly);
	fd.setCaption(tr("VYM - Export HTML to directory"));
	fd.setModal (true);
	fd.show();

	if ( fd.exec() == QDialog::Accepted )
	{
		dir=fd.selectedFile();
		lineEditDir->setText (dir );
		settingsChanged=true;
	}
}

void ExportXHTMLDialog::imageButtonPressed(bool b)
{
	useImage=b;
	settingsChanged=true;
}

void ExportXHTMLDialog::textcolorButtonPressed(bool b)
{
	useTextColor=b;	
	settingsChanged=true;
}

void ExportXHTMLDialog::saveSettingsInMapButtonPressed(bool b)
{
	saveSettingsInMap=b;	
	settingsChanged=true;
}

void ExportXHTMLDialog::warningsButtonPressed(bool b)
{
	showWarnings=b;
	settingsChanged=true;
}


void ExportXHTMLDialog::outputButtonPressed(bool b)
{
	showOutput=b;
	settingsChanged=true;
}

void ExportXHTMLDialog::cssChanged()
{
	css=lineEditCSS->text();
	settingsChanged=true;
}

void ExportXHTMLDialog::browseCSSPressed()
{
   	QFileDialog fd( this, tr("VYM - Path to CSS file"));
	fd.setModal (true);
	fd.addFilter ("Cascading Stylesheet (*.css)");
	fd.show();

	if ( fd.exec() == QDialog::Accepted )
	{
		css=fd.selectedFile();
		lineEditCSS->setText (css );
		settingsChanged=true;
	}
}

void ExportXHTMLDialog::xslChanged()
{
	xsl=lineEditXSL->text();
	settingsChanged=true;
}

void ExportXHTMLDialog::prescriptChanged()
{
	prescript=lineEditPreScript->text();
	settingsChanged=true;
}

void ExportXHTMLDialog::browseXSLPressed()
{
   	QFileDialog fd( this, tr("VYM - Path to XSL file"));
	fd.setModal (true);
	fd.addFilter ("Extensible Styleshee Language (*.xsl)");
	fd.show();

	if ( fd.exec() == QDialog::Accepted )
	{
		xsl=fd.selectedFile();
		lineEditXSL->setText (xsl );
		settingsChanged=true;
	}
}

void ExportXHTMLDialog::postscriptChanged()
{
	postscript=lineEditPostScript->text();
	settingsChanged=true;
}

void ExportXHTMLDialog::browsePreExportButtonPressed()
{
	QFileDialog fd( this, tr("VYM - Path to pre export script"));
	fd.setModal (true);
	fd.addFilter ("Scripts (*.sh *.pl *.py *.php)");
	fd.show();

	if ( fd.exec() == QDialog::Accepted )
	{
		prescript=fd.selectedFile();
		lineEditPreScript->setText (prescript );
		settingsChanged=true;
	}

}

void ExportXHTMLDialog::browsePostExportButtonPressed()
{
	QFileDialog fd( this, tr("VYM - Path to post export script"));
	fd.setModal (true);
	fd.addFilter ("Scripts (*.sh *.pl *.py *.php)");
	fd.show();

	if ( fd.exec() == QDialog::Accepted )
	{
		postscript=fd.selectedFile();
		lineEditPostScript->setText (postscript );
		settingsChanged=true;
	}
}


void ExportXHTMLDialog::doExport (const QString &mapname)
{
	// Save options to settings file 
	// (but don't save at destructor, which
	// is called for "cancel", too)
	settings.setLocalEntry (filepath,"/vym/export/xhtml/exportDir",dir);

	settings.setLocalEntry (filepath,"/vym/export/xhtml/prescript",prescript);
	settings.setLocalEntry (filepath,"/vym/export/xhtml/postscript",postscript);

    if (useImage)
		settings.setLocalEntry (filepath,"/vym/export/xhtml/useImage","yes");
    else
		settings.setLocalEntry (filepath,"/vym/export/xhtml/useImage","no");	
	
  if (useTextColor)
		settings.setLocalEntry (filepath,"/vym/export/xhtml/useTextColor","yes");
    else
		settings.setLocalEntry (filepath,"/vym/export/xhtml/useTextColor","no");	
	
   if (showWarnings)
		settings.writeEntry ("/vym/export/xhtml/showWarnings","yes");
    else
		settings.writeEntry ("/vym/export/xhtml/showWarnings","no");	
			
	if (showOutput)
		settings.writeEntry ("/vym/export/xhtml/showOutput","yes");
	else
		settings.writeEntry ("/vym/export/xhtml/showOutput","no");	
		
	settings.setLocalEntry 
		(filepath,"/vym/export/xhtml/xsl",xsl);
	settings.setLocalEntry 
		(filepath,"/vym/export/xhtml/css",css);	

	//FIXME add option for url image (globe flag) here	
	if (true) 
	{	
		QPixmap pm (flag_url_xpm);
		pm.save (dir + "/flags/url.png","PNG");
	}

	if (!saveSettingsInMap)
		settings.clearLocal("/vym/export/xhtml");
	else	
		settings.setLocalEntry 
			(filepath,"/vym/export/xhtml/saveSettingsInMap","yes");

	// Copy CSS file
	QFile css_src (css);
	QFile css_dst (dir+"vym.css");
	if (!css_src.open ( IO_ReadOnly))
		QMessageBox::warning( 0, tr( "Warning" ),css +tr(" could not be opened!"));
	else
	{
		if (!css_dst.open( IO_WriteOnly))
			QMessageBox::warning( 0, tr( "Warning" ), dir+"vym.css" +tr(" could not be opened!"));
		else
		{	
		
			QTextStream tsout( &css_dst);
			QTextStream tsin ( &css_src);
			QString s= tsin.read();
			tsout << s;
			css_dst.close();
		}	
		css_src.close();
	}

	if (!prescript.isEmpty()) runScript (prescript,dir+mapname+".xml");
	
	Process *xsltProc=new Process ();
	xsltProc->clearArguments();
	xsltProc->addArgument (xsltprocessor);	
	if (useImage)
	{
		xsltProc->addArgument ("--stringparam");
		xsltProc->addArgument ("imagemap");
		xsltProc->addArgument ("images/"+mapname+".png");
	}	
	if (useTextColor)
	{
		xsltProc->addArgument ("--stringparam");
		xsltProc->addArgument ("use.textcolor");
		xsltProc->addArgument ("1");
	}	
	xsltProc->addArgument ("--stringparam");
	xsltProc->addArgument ("mapname");
	xsltProc->addArgument (mapname+".vym");
	
	xsltProc->addArgument ("--output");
	xsltProc->addArgument (dir+mapname+".html");
	xsltProc->addArgument (xsl);
	xsltProc->addArgument (dir+mapname+".xml");
	dia->append ("vym is executing: \n" + xsltProc->arguments().join(" ") );	
	if (!xsltProc->start() )
	{
		QMessageBox::critical( 0, tr( "Critical Error" ),
					   tr("Couldn't start ") + xsltprocessor );
	} else
	{
		xsltProc->waitFinished();
		if (!xsltProc->normalExit() )
			QMessageBox::critical( 0, tr( "Critical Error" ),
			   xsltprocessor +" " +tr("didn't exit normally") +
			   xsltProc->getErrout() );
		else
			if (xsltProc->exitStatus()>0) showOutput=true;
			
	}	
	dia->append ("\n");
	dia->append (xsltProc->getErrout());
	dia->append (xsltProc->getStdout());
	
	if (!postscript.isEmpty()) runScript (postscript,dir+mapname+".html");

	if (showOutput) dia->exec();
}

void ExportXHTMLDialog::setFilePath(const QString &s)
{
	filepath=s;
}

void ExportXHTMLDialog::setMapName(const QString &s)
{
	mapname=s;
}

QString ExportXHTMLDialog::getDir()
{
	return dir;
}

bool ExportXHTMLDialog::warnings()
{
	return showWarnings;
}

bool ExportXHTMLDialog::hasChanged()
{
	return settingsChanged;
}


void ExportXHTMLDialog::runScript(QString spath, QString fpath)
{
	spath.replace ("%f",fpath);
	QStringList args=QStringList::split (' ',spath,false);
		
	Process *scriptProc=new Process ();
	scriptProc->clearArguments();
	scriptProc->setArguments (args);	
	dia->append ("vym is executing: \n" + scriptProc->arguments().join(" ") );	
	if (!scriptProc->start() )
	{
		QMessageBox::critical( 0, tr( "Critical Error" ),
					   tr("Couldn't start ") + spath );
	} else
	{
		scriptProc->waitFinished();
		if (!scriptProc->normalExit() )
			QMessageBox::critical( 0, tr( "Critical Error" ),
			   spath +" " +tr("didn't exit normally") +
			   scriptProc->getErrout() );
		else
			if (scriptProc->exitStatus()>0) showOutput=true;
			
	}	
	dia->append ("\n");
	dia->append (scriptProc->getErrout());
	dia->append (scriptProc->getStdout());
}
