#include "exports.h"

#include <qregexp.h>

#include "linkablemapobj.h"
#include "texteditor.h"


Export::Export()
{
	indentPerDepth="  ";
}

void Export::setPath (const QString &p)
{
	filepath=p;
}

void Export::setMapCenter(MapCenterObj *mc)
{
	mapCenter=mc;
}

void Export::exportMap()
{
	QFile file (filepath);
	if ( !file.open( IO_WriteOnly ) )
	{
		// FIXME experimental, testing
		cout << "Export::exportMap  couldn't open "<<filepath<<endl;
		return;
	}
	QTextStream ts( &file );	// use LANG decoding here...

	// Main loop over all branches
	QString s;
	QString actIndent("");
	int i;
	uint j;
	BranchObj *bo;
	bo=mapCenter->first();
	while (bo) 
	{
		// Make indentstring
		for (i=0;i<bo->getDepth();i++) actIndent+= indentPerDepth;

		// Write heading
		//	write (actIndent + getSectionString(bo) + bo->getHeading()+ "\n");
		if (bo->getDepth()==0)
		{
			ts << (bo->getHeading()+ "\n");
			for (j=0;j<bo->getHeading().length();j++) ts<<"=";
			ts << "\n";
		} else 	if (bo->getDepth()==1)
			ts << ("\n"+getSectionString(bo) + bo->getHeading()+ "\n");
		else	if (bo->getDepth()==2)
			ts << (actIndent + " o " + bo->getHeading()+ "\n");
		else	
			ts << (actIndent + " - " + bo->getHeading()+ "\n");
		
		// If necessary, write note
		if (!bo->getNote().isEmpty())
		{
			s =textConvertToASCII(bo->getNote());
			s=s.replace ("\n","\n"+actIndent);
			ts << (s+"\n\n");
		}
		
		bo=bo->next();
		actIndent="";
	}
	file.close();
}

QString Export::getSectionString(BranchObj *bostart)
{
	QString r;
	BranchObj *bo=bostart;
	int depth=bo->getDepth();
	while (depth>0)
	{
		r=QString("%1").arg(1+bo->getNum(),0,10)+"." + r;
		bo=(BranchObj*)(bo->getParObj());
		depth=bo->getDepth();
	}	
	if (r.isEmpty())
		return r;
	else	
		return r + " ";
}

