//<copyright>
//
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name:       colorviewer.C
//
// Purpose:    Implementation of class ColorViewer
//
// Created:     6 Apr 93    Michael Pichler
//
// Modified:   18 May 94    Michael Pichler
//
//
//</file>



#include "colorviewer.h"
#include "ocolor.h"

#include <InterViews/color.h>
#include <InterViews/canvas.h>



// Set up the connection between the observer (this object) and 
// the observable color

ColorViewer::ColorViewer (OColor* oc)
: Patch (nil)
{
  oc_ = oc;
  oc->attach (this);

  // NB:  It is deadly to set the color here.  I (Shawn M. E. Carnell) don't know why.
  color_ = nil;
}


ColorViewer::~ColorViewer ()
{
  if (oc_)
    oc_->detach (this);
}


/*
// Used during development.
void ColorViewer::print_values ()
{
  cerr << "RGB = " << oc_->getval (OColor::R) << ", "
                   << oc_->getval (OColor::G) << ", "
                   << oc_->getval (OColor::B) << endl;
}
*/


// This is where this object reacts to changes in the observables.
void ColorViewer::update (Observable*)
{
    // Must be careful with getting rid of the old color.
    Resource::unref (color_);

    color_ = new Color (oc_->getval (OColor::R), oc_->getval (OColor::G), oc_->getval (OColor::B));
    Resource::ref (color_);

    redraw ();  // Patch::redraw
}


void ColorViewer::request (Requisition& req) const
{
  req.require_x(Requirement(93.0, fil, 93.0, 0.0));
  // don't bother about y-requirement
}


// I don't know what this is doing exactly.  It bothers me that i couldn't
// find a way to specify explictly the size i wanted this object to have.
// It derives its size from the fixed_span into which it is put (see main). 
void ColorViewer::allocate (Canvas* c, const Allocation& a, Extension& ext)
{
  ext.set (c, a);
  Patch::allocate (c, a, ext);   
}


void ColorViewer::draw (Canvas* c, const Allocation& a) const
{
  if (color_)
    c->fill_rect (a.left(), a.bottom(), a.right(), a.top(), color_);
}


void ColorViewer::disconnect (Observable*)
{
  oc_ = nil;
}
