/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

/********** classe Programme ***********/

#include "vrel.h"

#include "program.h"
#include "instlist.h"
#include "declvar.h"
#include "decllist.h"
#include "envvar.h"
#include "envobject.h"


extern Environnement_objets * pere;


// Constructeur de la classe.
Programme::Programme () 
{
  instruc_main = NULL;
  strcpy(fichierimport[0], vrelfile);
  nbfichiers = 1;
}

// Destructeur de la classe.
Programme::~Programme ()
{
  delete instruc_main;
  delete[] fichierimport;
}

// Passage a un autre fichier. 
void Programme::import (char *file)
{
  extern FILE * yyin;
  extern FILE * tabyyin[];

  int test = 0;
  int i = 0;

  // On verifie que le fichier n'a pas dj t parcouru.
  while ( (i<nbfichiers) && (test == 0) ) {
    if (strcmp(file , fichierimport[i]) == 0)
      test = 1;
    i++;
  }

  // Si le fichier n'a pas dj t parcouru :
  if (test == 0) {
	
    // Mmorisation de la position.
    tabyyin[comptfichier]       = yyin;
    tablinenumber[comptfichier] = lineNumber;
    strcpy (tabvrelfile[comptfichier], vrelfile);
    comptfichier ++;
    
    // Ouverture du nouveau fichier.
    yyin = fopen(file, "r");
    if (yyin  == NULL) {
      perror(file); 
      exit(1); 
    }
    strcpy(fichierimport[nbfichiers], file);
    nbfichiers++;

    if (nbfichiers >= 100) {
      printf("Error: too much imported files\n");
      exit(1);
    }
    
    // Rinitialisation.
    strcpy(vrelfile, file);
    lineNumber = 1;
  }
}

// Ajout d'une variable  la liste des variables globales.
void Programme::adddeclarvar (Declaration_var* declarvar)
{
  varglobal->declaration (declarvar->nomvar);
  if(declarvar->donnee != NULL)
    varglobal->affectation (declarvar->nomvar, declarvar->donnee);
}

//  Ajout de la liste des instructions du main.
void Programme::addmain ( Declaration_var_liste * varlocmain,
			  Instruction_liste * instrucmain )
{
  int line;
  
  line = lineNumber;

  if (instruc_main == NULL) {
    varlocal = varlocmain->varloc;
    instruc_main = instrucmain;
  }
  else {
    printf ("Error: %s, line %d\n2 main in this file\n", vrelfile, line);
    exit(1);
  }
}

// Execution du programme
void Programme::exec ()
{
  if (instruc_main == NULL) {
    printf("Error: no main found in this file\n");
    exit(1);
  }
  
  instruc_main->exec();
}
