/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

#include "vrel.h"

#include "wall.h"
#include "aoi.h"
#include "board.h"
#include "button.h"
#include "doc.h"
#include "door.h"
#include "step.h"
#include "walls.h"
#include "cauldron.h"
#include "earth.h"
#include "gate.h"
#include "host.h"
#include "web.h"
#include "mirage.h"

#include "class.h"
#include "error.h"
#include "envclass.h"


// Construire un tableau de classes 
Environnement_classe::Environnement_classe()
{
  strcpy(nom[0],  "step");     classe[0]  = new Step();
  strcpy(nom[1],  "aoi");      classe[1]  = new Aoi();
  strcpy(nom[2],  "board");    classe[2]  = new Board();
  strcpy(nom[3],  "button");   classe[3]  = new Button();
  strcpy(nom[4],  "doc");      classe[4]  = new Doc();
  strcpy(nom[5],  "door");     classe[5]  = new Door();
  strcpy(nom[6],  "wall");     classe[6]  = new Wall(); 
  strcpy(nom[7],  "walls");    classe[7]  = new Walls();
  strcpy(nom[8],  "cauldron"); classe[8]  = new Cauldron();
  strcpy(nom[9],  "earth");    classe[9]  = new Earth();
  strcpy(nom[10], "gate");     classe[10] = new Gate();
  strcpy(nom[11], "host");     classe[11] = new Host();
  strcpy(nom[13], "web");      classe[13] = new Web();
  strcpy(nom[14], "mirage");   classe[14] = new Mirage();
  nb_classes = 15 ;
}

// Ajouter une classe au tableau des classes 
void Environnement_classe::addClasse(char nom_classe[50], Classe * classe1)
{
  // test si le nom de la classe n'est pas dj utilis 
  for (int i=0; i<nb_classes; i++) {
    if (! strcmp(nom_classe, nom[i]))
      Erreur("Class already declared");
  }

  strcpy(nom[nb_classes], nom_classe);
  classe[nb_classes]=classe1;
  nb_classes++;
  if (nb_classes > MAX_CLASSES)
    Erreur("Number of classes limited to 256");
}
