/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

#ifndef COMPOUND_H
#define COMPOUND_H

#include "decllist.h"
#include "class.h"
#include "datalist.h"
#include "envconstr.h"
#include "envvar.h"
#include "constructor.h"

/**
 * class Compound 
 */
class Compound : public Classe
{
 private:

  Environnement_constr * constr;	///< list of constructors d'une compound

 public:

  Compound(char *, Declaration_var_liste *, Environnement_constr *);
  /**< Constructeur d'une Compound */

  virtual ~Compound() {};

  void exec(Data_liste *);
  /**<
   * - 1. Sauver les variables de classe (et des superclasses ?)
   * - 2. Lancer l'excution du constructeur
   * - 3. Charger l'environnement courant
   */
};

#endif
