/*---------------------------------------------------------------------------*\

	FILE....: callisdn.cpp
	TYPE....: C++ Console program
	AUTHOR..: Ben Kramer
	DATE....: xx/12/2004

	This program is used for testing Voicetronix.  It works like this:
	
	./callisdn <channel> <number> <cid> <audiofile>
	Dials the number on the selected channel, presenting the callerid
	requested, and once the call has been answered plays the audio file.

	This uses the vpb_isdn_call() function.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2004 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "vpbapi.h"
#include "verbose.h"
#include "../kbhit.h"
#include "../threads.h"

int ctwaitforevent(int h, int event_type, int timeout_ms);
void *port_thread(void *pv);
int arg_exists(int argc, char *argv[], char *arg);

int             threads_active; // the number of active threads.
pthread_mutex_t mutex;          // mutex to protect shared data
int             finito;         // flag to signal the program is finished.
float           gain;           // option software record gain

int main(int argc, char * argv[])
{

	int	h;
	int	port=-1;
	char	number[21];
	char	cid[21];
	char	wav_file[256];
	char	buf[160];
	WFILE	*wf;
	int	bytes;

	int	ret;
	VPB_EVENT e;

	if (argc != 5){
		printf("%s <port> <number> <cid> <wav file>\n",argv[0]);
		exit(1);
	}
	else {
		port = atoi(argv[1]);
		strcpy(number,argv[2]);
		strcpy(cid,argv[3]);
		strcpy(wav_file,argv[4]);
		printf("Making call to %s from %s on port %d playing %s\n",number,cid,port,wav_file);
	}

	// verbose(1);

	h = vpb_open(0,port);
	printf("Port [%d] opened on handle [%d]!\n", port,h);
	sleep(5);
	vpb_isdn_call(h,number,cid,0,0);

	// do nothing in main loop until return pressed
	while(!kbhit()){
		ret = vpb_get_event_sync(&e,500);
		if (ret == VPB_OK) {
			printf("=========>  Got an event [%d] on [%d]\n",e.type,e.handle);
			switch(e.type){
				case VPB_ISDN_ANS:
					printf("Call was answered, playing file!\n");
//					vpb_play_file_sync(h,wav_file);
					vpb_play_buf_start(h,VPB_LINEAR);
					vpb_wave_open_read(&wf,wav_file);
					bytes = vpb_wave_read(wf,buf,sizeof(buf));
					while(bytes>0){
						vpb_play_buf_sync(h,buf,bytes);
						bytes = vpb_wave_read(wf,buf,sizeof(buf));
					}
					vpb_play_buf_finish(h);
					printf("Finished playing file!\n");
					break;
				case VPB_ISDN_BUSY:
					printf("The call failed with cause [%d]\n",e.data);
					break;
				case VPB_DROP:
					printf("The caller hung up :(\n");
					printf("shutting down....\n");
					vpb_close(h);
					return 0;
					break;
				default:
					break;
			}

		}


//		vpb_sleep(500);
	}

	printf("shutting down....\n");

	vpb_close(h);

	return 0;
}


int ctwaitforevent(int h, int event_type, int timeout_ms) {
	char      s[VPB_MAX_STR];
	int       ret, state;
	VPB_EVENT e;
	void      *timer;

	vpb_timer_open(&timer, h, 0, timeout_ms);
	if (timeout_ms != 0)
		vpb_timer_start(timer);

	state = 1;
	while(state && !finito) {
		ret = vpb_get_event_ch_async(h, &e);

		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);

			if (e.type == event_type) {
				state = 0;
			}
			if (e.type == VPB_TIMEREXP) {
				state = 0;
			}
			if(e.type == VPB_STATION_OFFHOOK) {
				state = 0;
			}
		}
		else
			vpb_sleep(100);
	}

	vpb_timer_close(timer);
	if (state == 0)
		return e.type;
	else
		return -1;
}

