/*---------------------------------------------------------------------------*\
	vtcommon.h
	Common helpers for VoiceTronix 'vtcore' based drivers.
	Author: Ron Lee
	Date: 	21 June 2006


	Copyright (C) 2006, 2007 Voicetronix www.voicetronix.com.au

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef VTCOMMON_H
#define VTCOMMON_H

#include <linux/autoconf.h>
#if defined( CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
 #define MODVERSIONS
#endif

#include <linux/version.h>

// This was moved out of version.h around 2.6.18
#ifndef UTS_RELEASE
#include <linux/utsrelease.h>
#endif

#ifdef MODVERSIONS
 #if (LINUX_VERSION_CODE > KERNEL_VERSION(2,6,4))
  #include <config/modversions.h>
 #else
  #include <linux/modversions.h>
 #endif
#endif

#include <linux/slab.h>


/* Compatibility helpers */
// Centos4.3 uses a modified 2.6.9 kernel, with no indication that
// it is different from the mainstream (or even Centos4.2 2.6.9)
// kernel, so we must crowbar off the dunce-hat manually here.
#if !defined MONGREL_CENTOS4 && LINUX_VERSION_CODE < KERNEL_VERSION(2,6,14)
 typedef int gfp_t;
 static inline void *kzalloc( size_t n, gfp_t flags ){
	void *p = kmalloc(n,flags);
	if (p) memset(p, 0, n);
	return p;
 }
#endif

// mutex.h and the new mutex handling appeared in 2.6.16, but RH in their
// infinite whatever you care to call it, have again munged things into
// earlier kernel versions, making the usual version tests all but useless.
//
// So... we bring in fs.h here to get mutex.h if it exists, then test for
// the existance of things it should supply, instead of:
// #if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16)

#include <linux/fs.h>

#ifndef DEFINE_MUTEX
 #define DEFINE_MUTEX(x)		DECLARE_MUTEX(x)
 #define mutex_init(x)			init_MUTEX(x)
 #define mutex_lock(x)			down(x)
 #define mutex_lock_interruptible(x)	down_interruptible(x)
 #define mutex_trylock(x)		down_trylock(x)
 #define mutex_unlock(x)		up(x)
#endif

/* boolean return values */
#define RET_OK   1
#define RET_FAIL 0

/* Convenience macros for logging */
#define info(format,...) printk(KERN_INFO NAME ": " format "\n" , ## __VA_ARGS__)
#define warn(format,...) printk(KERN_WARNING NAME ": " format "\n" , ## __VA_ARGS__)
#define crit(format,...) printk(KERN_CRIT NAME ": " format "\n" , ## __VA_ARGS__)


#endif // VTCOMMON_H

