/*-------------------------------------------------------------------------*\

	FILE........: DFT.C
	TYPE........: C Module
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 17/6/96

	DFT calling function.

\*-------------------------------------------------------------------------*/

#include "four_sh3.h"
#include "wind.h"
#include "shift.h"
#include "dftwin.h"
#include "dft.h"

/*--------------------------------------------------------------------------*\

	FUNCTION....: dft()

	AUTHOR......: David Rowe & John Kostogiannis
	DATE CREATED: 27/6/96

	Centres, windows and DFTs a block of speech samples.
	Changed to fixed point.

        int   x[];	NDFT real input samples
        COMPF X[];	NDFT/2 + 2 complex output samples

\*--------------------------------------------------------------------------*/

void dft(int x[], COMPF X[])
{
    int   Sn_fix[NDFT] = { [0 ... NDFT-1] = 0 };  /* windowed input signal */

    /* window speech samples */
    window(Sn_fix, x, NDFT, dftwin, 15);

    /* find DFT of Sn_fix[] */
    four_sh3(&X[-1].imag,&Sn_fix[-1],NDFT,twiddle);

    /* scaling such that energy in frequency domain equals energy in time */
    shift_vector((int*)X, (int*)X, -2, NDFT);
}

