
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_PDF_CONTENT_VIEW
#define _H_PDF_CONTENT_VIEW

#include <Foundation/NSString.h>
#include <AppKit/NSView.h>
#include <AppKit/NSTextField.h>

#include <PDFKit/PDFDocument.h>
#include <PDFKit/PDFImageRep.h>

#include "ExtendedScrollView.h"


@interface PDFContentView : NSView
{
   ExtendedScrollView*      scrollView;
   id                       imageView;
   NSTextField*             messageView;
   BOOL                     messageDisplayed;
   BOOL                     usePDFImageRep;
   int                      pageNum;
   PDFDocument*             pdfDoc;

   // for use with PDFImageRep
   PDFImageRep*             imageRep;
}

- (id) initWithFrame: (NSRect)frameRect;
- (void) dealloc;

- (id) imageView;

- (void) updateView;

- (void) setDocument: (PDFDocument*)_pdfDoc;
- (void) setPage: (int)_pageNum scaledBy: (float)factor;

- (void) sizeToFitPage;
- (void) setPageSize: (NSSize)size;
- (void) displayMessage: (NSString*)message;
- (void) removeMessage;

- (ExtendedScrollView*) scrollView;

- (void) resizeWithOldSuperviewSize: (NSSize)oldBoundsSize;

@end

#endif
