#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
import os
import subprocess
import Image
import StringIO
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp
from videoporama import *
from showprogress import *
from warning import *
from mplayer import *
from interface import *
from GlobalDefines import *

debug = False

class ShowProgress(QDialog,Ui_showprogress) : #OK QT4
    def __init__(self, VideoporamaInstance,parent=None, mplayerdir="", totframe=0, prc=None):
      super(ShowProgress, self).__init__(parent)
      self.setupUi(self)
      self.totframe=int(totframe)
      # Add view result tab with mplayer widget from ekd
      self.mplayer=Mplayer(VideoporamaInstance,taille=(600,450), choixWidget=(Mplayer.PAS_PRECEDENT_SUIVANT,Mplayer.CURSEUR_A_PART,Mplayer.PAS_PARCOURIR), cheminMPlayer=mplayerdir)
      self.tab_3.addTab(self.mplayer,u"View result")
      self.mplayer.setEnabled(False)
      self.tab_3.setCurrentIndex(0)
      if prc.VIDEO_ASPECT_RATIO == "16:9" :
        self.ratio = 16.0/9.0
        self.mplayer.choicewide.setChecked(True)
      elif prc.VIDEO_ASPECT_RATIO == "4:3" :
        self.ratio = 4.0/3.0
      else :
        self.ratio = 4.0/3.0
        self.mplayer.choicenorm.setChecked(True)
      self.mplayer.setRatio(self.ratio)
      self.progressBar1.setMaximum(self.totframe)
      self.connect(self.pushButton1,SIGNAL("clicked()"),self.tmpclose)
      self.FileName=""

    def tmpclose(self) :
      self.emit(SIGNAL("cleantmp"))
      self.close()

    def activideo(self) :
      self.mplayer.listeVideos = [self.FileName]
      self.mplayer.setEnabled(True)
      self.tab_3.setCurrentIndex(1)
      self.mplayer.lectPause()

class Warning(QDialog,Ui_warning) : #OK QT4
    def __init__(self, parent=None):
        super(Warning, self).__init__(parent)
        self.setupUi(self)

#------------------------------------------------------------------------------------------------------------

class process(QThread) :
  
  #domledom : Add IsPreview variable to force output filename and skip error message
  def __init__(self,dom,conf,VideoporamaInstance,OutputOFDXMLObject,wide=0,IsPreview=False,parent=None) :
    super(process, self).__init__(None)
    self.VideoporamaInstance=VideoporamaInstance
    self.wide      =wide
    self.img       =[]    # list of mylabel object
    self.ImgTime   =[]    # list of mylabel.CalcImageTime() result
    self.totimage  =0
    self.err       =0 # define if there's an error in initialisation phase
    self.msgerror  =""
    self.sont      =0
    self.XMLText   =None
    self.IsPreview =IsPreview

    # configurations elements
    self.T=parent.T       # tmp directory
    self.I=parent.I       # ffmpeg directory
    self.MJ=parent.MJ     # mjpegtools directory
    self.S=parent.S       # SOX directory
    self.MP=parent.MP     # mplayer directory

    #Search if the project have overlaid text
    xmlPoint=dom.getElementsByTagName(u"Videoporama")[0]
    xmlText =xmlPoint.getElementsByTagName(u"Text")
    if xmlText.length>0 :
      xmlText=xmlText[0]
      # Be sure this child is type Overlaid (and not type image or Zoompoint)
      if xmlText.getAttribute(u"Type")=="Overlaid":
        self.XMLText=Document()
        xmlRoot=self.XMLText.createElement(u"SaveXML")
        self.XMLText.appendChild(xmlRoot)
        xmlRoot.appendChild(dom.importNode(xmlText,True))
    else :
      self.XMLText=None

    # try to fin the number of core/cpu for encoder how can use it
    try :
      if sys.platform == 'win32':
        try:
          NbrCPU= int(os.environ['NUMBER_OF_PROCESSORS'])
        except:
          NbrCPU=1
      else:
        try:
          NbrCPU=int(os.sysconf('SC_NPROCESSORS_ONLN'))
        except:
          NbrCPU=1
      if NbrCPU<2: self.PThread=""
      else: self.PThread=u" -threads "+unicode(NbrCPU)
      if NbrCPU<2: self.MPThread=""
      else: self.MPThread=u" threads "+unicode(NbrCPU)
    except:
      self.PThread=u""

    if self.IsPreview!=True :
      OFDDeviceType  = LoadValueFromXMLFile(dom,'OFDDeviceType',"",u"Videoporama")
      OFDDeviceModel = LoadValueFromXMLFile(dom,'OFDDeviceModel',"",u"Videoporama")
      OFDOutputCodec = LoadValueFromXMLFile(dom,'OFDOutputCodec',"",u"Videoporama")
      OFDOutputFormat= LoadValueFromXMLFile(dom,'OFDOutputFormat',"",u"Videoporama")
      if OFDOutputFormat=="" :
        self.msgerror=self.msgerror+self.tr("Incorrect output format \n")
        self.err=1
      else:
        xmlroot        =OutputOFDXMLObject.getElementsByTagName(u"VideoporamaOutputFormatDefinition")[0]
        xmlDeviceType  =getElementsByAttributName(xmlroot,OFDDeviceType)
        xmlDeviceModel =getElementsByAttributName(xmlDeviceType,OFDDeviceModel)
        xmlOutputCodec =getElementsByAttributName(xmlDeviceModel,OFDOutputCodec)
        if self.wide==1: xmlGeometry=getElementsByAttributName(xmlOutputCodec,"Wide - 16:9")
        else: xmlGeometry=getElementsByAttributName(xmlOutputCodec,"Normal - 4:3")
        xmlFormat      =getElementsByAttributName(xmlGeometry,OFDOutputFormat)
        
        self.imgpsec    =int(xmlFormat.getAttribute(u'FPS'))
        self.widthpict  =int(xmlFormat.getAttribute(u'Width'))
        self.heightpict =int(xmlFormat.getAttribute(u'Height'))
        self.ext        =xmlFormat.getAttribute(u'Ext')
        self.Commande   =QString(xmlFormat.getAttribute(u'Cmd'))

        # Special case for NTSC
        if self.imgpsec==30 : #NTSC
          self.IMGSEC="30000:1001"
        else :
          self.IMGSEC="25:1"
    else :
      # Preview mode
      self.VIDEO_TYPE_LETTER="p"
      self.IMGSEC     = "25:1"
      self.imgpsec    = 25
      if self.wide == 1:
        self.widthpict  = 854
        self.heightpict = 480
        self.Commande=QString("'%MJPEGDIR%ppmtoy4m' -v 0 -n %FRAMENBR% -F 25:1 -S 420jpeg | '" \
          +u"%FFMPEGDIR%ffmpeg' -y -f yuv4mpegpipe -i - -i '%SOUNDFILE%' " \
          +u"-target pal-vcd -aspect 16:9 - | '%MPLAYERDIR%mplayer' -aspect 16:9 -")
      else:
        self.widthpict  = 640
        self.heightpict = 480
        self.Commande=QString("'%MJPEGDIR%ppmtoy4m' -v 0 -n %FRAMENBR% -F 25:1 -S 420jpeg | '" \
          +u"%FFMPEGDIR%ffmpeg' -y -f yuv4mpegpipe -i - -i '%SOUNDFILE%' " \
          +u"-target pal-vcd -aspect 4:3 -  | '%MPLAYERDIR%mplayer' -aspect 4:3 -")

    # Special case for AAC with ffmpeg 0.5
    print "AACMode="+parent.AACMode
    if parent.AACMode=="libfaac" : 
	print "Transformation AAC"
	self.Commande.replace(u"aac -strict experimental", u"libfaac")

    if self.err==0:
      if self.wide == 1 : self.VIDEO_ASPECT_RATIO="16:9"
      else :              self.VIDEO_ASPECT_RATIO="4:3"

      # Images files
      if self.VideoporamaInstance.win.timeline.columnCount() == 0 :
        self.msgerror=self.msgerror+self.tr("There aren't picture to process \n")
        self.err=1
      else :
        k=0
        self.totimage = 0
        while k<self.VideoporamaInstance.win.timeline.columnCount() :
          self.img.append(self.VideoporamaInstance.win.timeline.cellWidget(0,k))
          self.ImgTime.append(self.img[k].CalcImageTime(self.imgpsec))
          if k==(self.VideoporamaInstance.win.timeline.columnCount()-1): self.totimage+=self.ImgTime[k][1]
          else : self.totimage+=self.ImgTime[k][1]-self.ImgTime[k][5]
          k+=1

      self.sont=0
      try:
        self.w=dom.getElementsByTagName('sndfile')[0].childNodes[0].nodeValue
      except:
        self.w=u"-n"    # -n = null sound for sox
        self.sont=1
      if self.w=="" :
        self.w=u"-n"    # -n = null sound for sox
        self.sont=1

      if (self.IsPreview==True):
        self.o=parent.T+u"preview"
      else:
        try:
          self.o=dom.getElementsByTagName('outputfile')[0].childNodes[0].nodeValue
          if self.o=="" :
            self.msgerror=self.msgerror+self.tr("There isn't output file define \n")
            self.err=1
        except:
          self.msgerror=self.msgerror+self.tr("There isn't output file define \n")
          self.err=1
          None

      self.lumask=lumaList()[0] 

    #Change path for log generation
    os.chdir(validatePath(self.T,False))
    if self.err : self.error(self.msgerror)

  def error(self,texte):
    self.war=Warning(self.VideoporamaInstance.win)
    self.war.texte.setText(texte)
    self.war.show()
    self.war.connect(self.war.closeb,SIGNAL("clicked()"),self.war,SLOT("close()"))

#------------------------------------------------------------------------------------------------------------
# Render process
#------------------------------------------------------------------------------------------------------------
  def run(self):
    # Sound check and abord if no sound file
    if not self.convertsound() : return None
    #------------------------------------------------------------
    # Prepare self.Commande
    #------------------------------------------------------------
    if os.name == 'nt' :      
      self.Commande.replace(u"'%MJPEGDIR%ppmtoy4m'", "\""+self.MJ+"ppmtoy4m.exe\"")
      self.Commande.replace(u"'%FFMPEGDIR%ffmpeg'","\""+self.I+"ffmpeg.exe\"")
      self.Commande.replace(u"'%SOUNDFILE%'", "\""+self.ws+"\"")
      self.Commande.replace(u"'%MPLAYERDIR%mplayer'", "\""+self.MP+"mplayer.exe\"")
      self.Commande.replace(u"-vpre libx264-hq", "-fpre \""+self.I+"..\presets\libx264-hq.ffpreset\"")
    else:
      self.Commande.replace(u"%MJPEGDIR%", self.MJ)
      self.Commande.replace(u"%FFMPEGDIR%",self.I)
      self.Commande.replace(u"%SOUNDFILE%",self.ws)
      self.Commande.replace(u"%MPLAYERDIR%",self.MP)
    self.Commande.replace(u"%FRAMENBR%", unicode(int(self.totimage)))
    self.Commande.replace(u"%THREAD%",self.PThread)
    self.Commande.replace(u"%MPTHREAD%",self.MPThread)
    if self.IsPreview==False :
      if QString(self.o).endsWith(self.ext) : self.ext=u""
      if os.name == 'nt' :      
        self.Commande=self.Commande+u" \""+unicode(self.o)+unicode(self.ext)+u"\""
      else:
        self.Commande=self.Commande+u" '"+unicode(self.o)+unicode(self.ext)+u"'"
    #------------------------------------------------------------
    # Start self.Commande : Open PIPE
    #------------------------------------------------------------
    self.Commande=unicode(self.Commande)
    if os.name == 'nt' : 
      self.Commande=u"\""+self.Commande+"\""
      encodedv_pipe = subprocess.Popen(self.Commande.encode('iso-8859-1'), shell=True, stdin=subprocess.PIPE)
    else :               encodedv_pipe = subprocess.Popen(self.Commande.encode('utf-8'), shell=True, stdin=subprocess.PIPE)
    # Standard input to convert process
    encodedv_stdin = encodedv_pipe.stdin
    #------------------------------------------------------------
    # Render process
    #------------------------------------------------------------
    # First frame (black)
    BlackFrame=QImage(QSize(self.widthpict,self.heightpict),QImage.Format_ARGB32_Premultiplied)
    p=QPainter(BlackFrame)
    p.fillRect(QRect(0,0,self.widthpict,self.heightpict),Qt.black)
    p.end()
    BlackFrame=QImageToPil(BlackFrame)
    # First transition
    transitype = 1              # First transition : Always fondu from black image as first transition
    optTr      = 0              # First transition : No option
    z          = 0              # z = current frame
    SeqNum     = 0              # Start à first sequence
    PrevIm     = None

    for im in self.img :
      self.emit(SIGNAL("image"),im)
      # Prepare variable use for this sequence
      SeqTime,SeqFramNbr,InTrTime,InTrFramNbr,OutTrTime,OutTrFramNbr=self.ImgTime[SeqNum]
      CurrentSeqFrame= 0      # current frame of current image 
      while CurrentSeqFrame<int(SeqFramNbr-OutTrFramNbr) : # Process current image
        ImageRendered=im.getFrameImage(self.imgpsec,CurrentSeqFrame,self.widthpict,self.heightpict,self.IsPreview)

        # Process transition with previous image : Transforme ImageRendered with transition
        if CurrentSeqFrame<InTrFramNbr:
          if PrevIm!=None : PreviousImageRendered=PrevIm.getFrameImage(self.imgpsec,CurrentSeqFrame+(self.ImgTime[SeqNum-1][1]-self.ImgTime[SeqNum-1][5]),self.widthpict,self.heightpict,self.IsPreview)
          else :            PreviousImageRendered=BlackFrame
          ImageRendered=self.choiceTransition(transitype,PreviousImageRendered,ImageRendered,(float(CurrentSeqFrame)/InTrFramNbr)*100,optTr)
        else :
          if PrevIm!=None :
            if PrevIm.ImageCacheMovie!=None :
              PrevIm.ImageCacheMovie=None             # free ImageCacheMovie

        # Add overlaid text if needed
        if self.XMLText!=None: ImageRendered=QImageToPil(ApplyTextToQImage(PilToQImage(ImageRendered),self.XMLText))

        # Write result
        convert_pipe=StringIO.StringIO()
        ImageRendered.save(convert_pipe,"PPM")
        encodedv_stdin.write(convert_pipe.getvalue())

        CurrentSeqFrame+=1                 # frame suivante pour l'image en cours
        z              +=1                 # frame suivante pour la séquence
        self.emit(SIGNAL("frame"),z)

      SeqNum            = SeqNum+1         # Next sequence
      transitype        = int(im.typet)    # Get transition for next sequence
      optTr             = im.opttransi     # Get Option Transition for next sequence
      PrevIm            = im               # Current image become previous image

    #---------------------------------------------------- Last Transition process
    #SeqFramNbr      = OutTrFramNbr             # Out Transition frame number become the number of frame to process
    CurrentSeqFrame = 0      # current frame of current image

    #while CurrentSeqFrame<int(OutTrFramNbr) :
    while z<self.totimage:
      ImageRendered=im.getFrameImage(self.imgpsec,SeqFramNbr+CurrentSeqFrame,self.widthpict,self.heightpict,self.IsPreview)
      ImageRendered=self.choiceTransition(transitype,ImageRendered,BlackFrame,(float(CurrentSeqFrame)/OutTrFramNbr)*100,optTr)
      # Add overlaid text if needed
      if self.XMLText!=None: ImageRendered=QImageToPil(ApplyTextToQImage(PilToQImage(ImageRendered),self.XMLText))
      convert_pipe=StringIO.StringIO()
      ImageRendered.save(convert_pipe,"PPM")
      encodedv_stdin.write(convert_pipe.getvalue())
      CurrentSeqFrame+=1
      z              +=1  #frame suivante pour la séquence
      self.emit(SIGNAL("frame"),z)
    im.ImageCacheMovie=None             # free ImageCacheMovie
    #---------------------------------------------------- Transition process End
    encodedv_pipe.wait()    # Wait until encoding is finished
    encodedv_stdin.close()  # Send signal End of file to encoding process

#------------------------------------------------------------------------------- 
# Sound process
#------------------------------------------------------------------------------- 
  def convertsound(self):
    # definition of sound lenght
    if self.imgpsec==30 : sec=float(self.totimage) * 1001 / 30000
    else :                sec=float(self.totimage) / self.imgpsec

    seconde=unicode(sec % 60).split(u".")
    minute=int(sec / 60)
    heure=int(minute / 60)
    timesnd=u"%s:%s:%s.%s" % (unicode(heure).rjust(2,'0'),unicode(minute).rjust(2,'0'),seconde[0].rjust(2,'0'),seconde[1].ljust(3,'0')[0:3])
    if QString(self.w).endsWith("mp3") | QString(self.w).endsWith("MP3") :
      st=u" -t mp3"
    else :
      st=u""
 
    # Exception for Windows to use mp3 files 
    if os.name == 'nt' and st == u" -t mp3" :
      commande = unicode(self.I)+os.sep+u"ffmpeg -i  \""+unicode(self.w)+u"\" \""+self.T+u"sound_wav.wav\""
      if(subprocess.call(commande.encode('iso-8859-1'))) :
        self.sont = 0
        self.w = self.T+u"sound_wav.wav"
      else :
        self.w = u"-n" 
        self.sont = 1

    # sound conversion
    self.ws=self.T + u"audio.tmp.wav"
    if self.sont == 1 : #Fonction simplifiée, fonctionne sous linux et Windows
      if os.name == 'nt' : 
        Commande=u"\""+unicode(unicode(self.S)+u"sox\" -V3 -r 44100 -n \""+unicode(self.ws)+u"\" fade 00:00:00 "+timesnd+u" 00:00:00.500")
        rc=subprocess.call(Commande.encode('iso-8859-1'))
      else:
        Commande=unicode(unicode(self.S)+u"sox -V3 -r 44100 -n \""+unicode(self.ws)+u"\" fade 00:00:00 "+timesnd+u" 00:00:00.500")
        rc=subprocess.call(Commande.encode('utf-8'),shell=True)
      if (rc):
        self.sont=1
        self.convertsound()
    else :
      # Utilisation de la fonction trim de SoX associé au fichier virtuel "null" (-n)
      if os.name == 'nt' : 
        Commande=u"\""+unicode(unicode(self.S)+u"sox\" -V3 -r 44100 "+st+u" \""+unicode(self.w)+u"\" \""+unicode(self.ws)+u"\" trim 00:00:00.000 "+timesnd)
        rc=subprocess.call(Commande.encode('iso-8859-1'))
      else:
        Commande=unicode(unicode(self.S)+u"sox -V3 -r 44100 "+st+u" \""+unicode(self.w)+u"\" \""+unicode(self.ws)+u"\" trim 00:00:00.000 "+timesnd)
        rc=subprocess.call(Commande.encode('utf-8'),shell=True)
      if (rc):
        self.emit(SIGNAL("text"), self.tr("Error with sound encoding process"))
        return 0

    # Test si le fichier son exist, si non, message d'erreur et arrêt de l'encodage
    if (not IsFileExist(self.ws)) :
      self.emit(SIGNAL("text"),self.tr("Error with sound encoding process \nEncoding process abort"))
      return 0
    else :
      return 1

#------------------------------------------------------------------------------- 
# Transitions
#------------------------------------------------------------------------------- 
  def choiceTransition(self,transitype,previous,image,dissolve,optionTr):
    if int(transitype)==0 :
      return image

    elif int(transitype)==1 :
      resu=self.fadepil(previous,image,dissolve)
      return resu

    elif int(transitype)==2 :
      resu=self.appearpil(previous,image,dissolve,int(optionTr))
      return resu

    elif int(transitype)==3 :
      resu=self.disappearpil(previous,image,dissolve,int(optionTr))
      return resu

    elif int(transitype)==4 :
      resu=self.slidepil(previous,image,dissolve,int(optionTr))
      return resu

    elif int(transitype)==5 :
      resu=self.cubepil(previous,image,dissolve,int(optionTr))
      return resu

    elif int(transitype)==6 :
      resu=self.pushpil(previous,image,dissolve,int(optionTr))
      return resu

    elif int(transitype)==7 :
      resu=self.lumapil(previous,image,dissolve,unicode(self.lumask[int(optionTr)]))
      return resu

  #------------------------------------------------------------------------------- Fade transition
  def fadepil(self,previouspil,impil,dissolve) :
    percent=float(dissolve)/100
    imf=Image.blend(previouspil,impil,percent)
    return imf

  #------------------------------------------------------------------------------- Slide transition
  def slidepil(self,previouspil,impil,dissolve,opt=0) :
    if opt == 0 :   #Since left to right
      a = int(self.widthpict*(100.0-dissolve)/100.0)
      box1=(a,0,self.widthpict,self.heightpict)
      box2=(0,0,self.widthpict-a,self.heightpict)
    elif opt == 1 : #Since right to left
      a = int(dissolve*self.widthpict/100)
      box1=(0,0,a,self.heightpict)
      box2=(self.widthpict-a,0,self.widthpict,self.heightpict)
    elif opt == 2 : #Since up to down
      a = int(self.heightpict-dissolve*self.heightpict/100)
      box1=(0,a,self.widthpict,self.heightpict)
      box2=(0,0,self.widthpict,self.heightpict-a)
    elif opt == 3 : #Since down to up
      a = int(dissolve*self.heightpict/100)
      box1=(0,0,self.widthpict,a)
      box2=(0,self.heightpict-a,self.widthpict,self.heightpict)
    elif opt == 4 : #Since the upper left corner
      a = int(dissolve*self.widthpict/100)
      b = int(dissolve*self.heightpict/100)
      box1=(self.widthpict-a,self.heightpict-b,self.widthpict,self.heightpict)
      box2=(0,0,a,b)
    elif opt == 5 : #Since the upper right corner
      a = int(self.heightpict-dissolve*self.heightpict/100)
      b = int(dissolve*self.widthpict/100)
      box1=(0,a,b,self.heightpict)
      box2=(self.widthpict-b,0,self.widthpict,self.heightpict-a)
    elif opt == 6 : #Since the lower left corner
      a = int(self.widthpict-dissolve*self.widthpict/100)
      b = int(dissolve*self.heightpict/100)
      box1=(a,0,self.widthpict,b)
      box2=(0,self.heightpict-b,self.widthpict-a,self.heightpict)
    elif opt == 7 : #Since the lower right corner
      a = int(dissolve*self.widthpict/100)
      b = int(dissolve*self.heightpict/100)
      box1=(0,0,a,b)
      box2=(self.widthpict-a,self.heightpict-b,self.widthpict,self.heightpict)
 
    ima=impil.crop(box1)
    previouspil.paste(ima,box2)
    return previouspil

  #------------------------------------------------------------------------------- Zoom In transition
  def appearpil(self,previouspil,impil,dissolve,opt=0) :
    previouspil2 = previouspil.copy()
    wt = int(self.widthpict*dissolve/100)
    ht = int(self.heightpict*dissolve/100)
    
    #domledom : add new transition by moving position of the destination
    if (opt==1):  #Border Left Center
      box = (0,int((self.heightpict-ht)/2),wt,int((self.heightpict+ht)/2))
    elif (opt==2):  #Border Right Center
      box = (int(self.widthpict-wt),int((self.heightpict-ht)/2),int(self.widthpict),int((self.heightpict+ht)/2))
    elif (opt==3):  #Border Top Center
      box = (int((self.widthpict-wt)/2),0,int((self.widthpict+wt)/2),ht)
    elif (opt==4):  #Border Bottom Center
      box = (int((self.widthpict-wt)/2),int(self.heightpict-ht),int((self.widthpict+wt)/2),int(self.heightpict))
    elif (opt==5):  #Upper Left Corner
      box = (0,0,wt,ht)
    elif (opt==6):  #Upper Right Corner
      box = (int(self.widthpict-wt),0,int(self.widthpict),ht)
    elif (opt==7):  #Bottom Left Corner
      box = (0,int(self.heightpict-ht),wt,int(self.heightpict))
    elif (opt==8):  #Bottom Right Corner
      box = (int(self.widthpict-wt),int(self.heightpict-ht),int(self.widthpict),int(self.heightpict))
    else:
      box = (int((self.widthpict-wt)/2),int((self.heightpict-ht)/2),int((self.widthpict+wt)/2),int((self.heightpict+ht)/2))
      
    imz = impil.resize((wt,ht))
    previouspil2.paste(imz,box)
    return previouspil2

  #------------------------------------------------------------------------------- Zoom Out transition
  def disappearpil(self,previouspil,impil,dissolve,opt=0) :
    impil2=impil.copy()
    prce = 100-dissolve
    wt = int(self.widthpict*prce/100)
    ht = int(self.heightpict*prce/100)

    #domledom : add new transition by moving position of the destination
    if (opt==1):  #Border Left Center
      box = (0,int((self.heightpict-ht)/2),wt,int((self.heightpict+ht)/2))
    elif (opt==2):  #Border Right Center
      box = (int(self.widthpict-wt),int((self.heightpict-ht)/2),int(self.widthpict),int((self.heightpict+ht)/2))
    elif (opt==3):  #Border Top Center
      box = (int((self.widthpict-wt)/2),0,int((self.widthpict+wt)/2),ht)
    elif (opt==4):  #Border Bottom Center
      box = (int((self.widthpict-wt)/2),int(self.heightpict-ht),int((self.widthpict+wt)/2),int(self.heightpict))
    elif (opt==5):  #Upper Left Corner
      box = (0,0,wt,ht)
    elif (opt==6):  #Upper Right Corner
      box = (int(self.widthpict-wt),0,int(self.widthpict),ht)
    elif (opt==7):  #Bottom Left Corner
      box = (0,int(self.heightpict-ht),wt,int(self.heightpict))
    elif (opt==8):  #Bottom Right Corner
      box = (int(self.widthpict-wt),int(self.heightpict-ht),int(self.widthpict),int(self.heightpict))
    else:
      box = (int((self.widthpict-wt)/2),int((self.heightpict-ht)/2),int((self.widthpict+wt)/2),int((self.heightpict+ht)/2))
      
    imz = previouspil.resize((wt,ht))
    impil2.paste(imz,box)
    return impil2

  #------------------------------------------------------------------------------- Cube transition
  def cubepil(self,previouspil,impil,dissolve,opt=0) :
    base = Image.new("RGB",(self.widthpict,self.heightpict))
    if opt == 0 : #Left2Right
      w1=int(self.widthpict*dissolve/100)
      box1=(0,0,w1,self.heightpict)
      part1 = impil.resize((w1,self.heightpict))
      w2=self.widthpict-w1
      box2=(w1,0,self.widthpict,self.heightpict)
      part2 = previouspil.resize((w2,self.heightpict))
      base.paste(part1,box1)
      base.paste(part2,box2)
    elif opt == 1 : #Right2Left
      w1=int(self.widthpict*dissolve/100)
      part1 = impil.resize((w1,self.heightpict))
      w2=self.widthpict-w1
      box1=(w2,0,self.widthpict,self.heightpict)
      box2=(0,0,w2,self.heightpict)
      part2 = previouspil.resize((w2,self.heightpict))
      base.paste(part1,box1)
      base.paste(part2,box2)
    elif opt == 2 : #Top2Bottom
      h1=int(self.heightpict*dissolve/100)
      box1=(0,0,self.widthpict,h1)
      part1 = impil.resize((self.widthpict,h1))
      h2=self.heightpict-h1
      box2=(0,h1,self.widthpict,self.heightpict)
      part2 = previouspil.resize((self.widthpict,h2))
      base.paste(part1,box1)
      base.paste(part2,box2)
    elif opt == 3 : #Bottom2Top
      h1=int(self.heightpict*dissolve/100)
      part1 = impil.resize((self.widthpict,h1))
      h2=self.heightpict-h1
      box1=(0,h2,self.widthpict,self.heightpict)
      box2=(0,0,self.widthpict,h2)
      part2 = previouspil.resize((self.widthpict,h2))
      base.paste(part1,box1)
      base.paste(part2,box2)

    return base

  #------------------------------------------------------------------------------- Push transition
  def pushpil(self,previouspil,impil,dissolve,opt=0) :
    if opt == 0 :
      base = Image.new("RGB",(self.widthpict*2,self.heightpict))
      base.paste(impil,(0,0,self.widthpict,self.heightpict))
      base.paste(previouspil,(self.widthpict,0,self.widthpict*2,self.heightpict))
      imz=base.crop((int(self.widthpict-dissolve*self.widthpict/100),0,int(self.widthpict*2-(dissolve*self.widthpict/100)),self.heightpict))
    elif opt == 1 :
      base = Image.new("RGB",(self.widthpict*2,self.heightpict))
      base.paste(previouspil,(0,0,self.widthpict,self.heightpict))
      base.paste(impil,(self.widthpict,0,self.widthpict*2,self.heightpict))
      imz=base.crop((int(dissolve*self.widthpict/100),0,int(self.widthpict+(dissolve*self.widthpict/100)),self.heightpict))
    elif opt == 2 :
      base = Image.new("RGB",(self.widthpict,self.heightpict*2))
      base.paste(impil,(0,0,self.widthpict,self.heightpict))
      base.paste(previouspil,(0,self.heightpict,self.widthpict,self.heightpict*2))
      imz=base.crop((0,int(self.heightpict-dissolve*self.heightpict/100),self.widthpict,int(self.heightpict*2-(dissolve*self.heightpict/100))))
      #imz=base.crop((0,int(self.heightpict-dissolve*self.heightpict/100),self.widthpict,self.heightpict))
    elif opt == 3 :
      base = Image.new("RGB",(self.widthpict,self.heightpict*2))
      base.paste(previouspil,(0,0,self.widthpict,self.heightpict))
      base.paste(impil,(0,self.heightpict,self.widthpict,self.heightpict*2))
      imz=base.crop((0,int(dissolve*self.heightpict/100),self.widthpict,int(self.heightpict+(dissolve*self.heightpict/100))))

    return imz.resize((self.widthpict,self.heightpict))

  def map(self,i) :
    if i < limit :
      return 0
    return 255

  def lumapil(self,previouspil,impil,dissolve,mask) :
    global limit
    limit   = int(dissolve*255/100)+1
    luma    = Image.open(mask)
    msk     = luma.point(lambda i : self.map(i),"1")
    mskl    = msk.resize((self.widthpict,self.heightpict))
    lumaout = Image.composite(previouspil,impil,mskl)
    return lumaout
