#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
import Image
import random
from math import *
from __builtin__ import hex as hexp
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from DefZoomPoint import *
from DocHelpDlg import *

#-------------------------------------------------------------------------------------------------------------
# A FAIRE
#   Faire les guides magnétiques
#   Eventuellement : ajouter des options :
#     Gérer les rotations de l'image
#-------------------------------------------------------------------------------------------------------------

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
#class use to add interractive resize to QGraphicsRectItem object
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class QResizeGraphicsRectItem(QtGui.QGraphicsRectItem):
  
    def __init__(self,scene,RectItem,ZValue,TypeItem,xmax,ymax,ZoomPointDlg,parent=None):
      self.RectItem       = RectItem
      self.TypeItem       = TypeItem
      self.IsCapture      = False
      self.BlockRecursion = False       # Flag to stop recursion during resize
      self.ZoomPointDlg    = ZoomPointDlg

      x,y,w,h=self.CalcPosition(xmax,ymax)

      super(QResizeGraphicsRectItem,self).__init__(x,y,w,h,parent) #parent

      #define a pen for the rectangle
      col=QColor(255,0,0)
      pen=QPen(col)
      pen.setWidth(1)
      self.setPen(pen)
      
      #define Mouse cursor
      if self.TypeItem==0:    self.setCursor(Qt.SizeFDiagCursor)  #Upper-Left corner
      elif self.TypeItem==1:  self.setCursor(Qt.SizeBDiagCursor)  #Upper-Right corner
      elif self.TypeItem==2:  self.setCursor(Qt.SizeBDiagCursor)  #Bottom-Left corner
      elif self.TypeItem==3:  self.setCursor(Qt.SizeFDiagCursor)  #Bottom-Right corner

      #define Flags
      try :
        self.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable  | QGraphicsItem.ItemSendsScenePositionChanges | QGraphicsItem.ItemSendsGeometryChanges)
      except :
        self.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable) 
      self.setZValue(ZValue)
      
      #Add this item to the scene
      scene.addItem(self)

    def mousePressEvent(self, event):
      QGraphicsRectItem.mousePressEvent(self,event)
      self.IsCapture = True

    def mouseReleaseEvent(self, event):
      self.IsCapture = False
      QGraphicsRectItem.mouseReleaseEvent(self,event)

    def CalcPosition(self,xmax=-1,ymax=-1):
      ToMove=(xmax==-1 or ymax==-1)
      if ToMove:
        xmax = self.RectItem.scene().sceneRect().width()
        ymax = self.RectItem.scene().sceneRect().height()
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      if self.TypeItem==0:      #Upper-Left corner
        x = self.RectItem.x*xmax
        y = self.RectItem.y*ymax
      elif self.TypeItem==1:    #Upper-Right corner
        x = self.RectItem.x*xmax+xmax*self.RectItem.zoom/100
        y = self.RectItem.y*ymax
      elif self.TypeItem==2:    #Bottom-Left corner
        x = self.RectItem.x*xmax
        y = self.RectItem.y*ymax+ymax*self.RectItem.zoom/100
      elif self.TypeItem==3:    #Bottom-Right corner
        x = self.RectItem.x*xmax+xmax*self.RectItem.zoom/100
        y = self.RectItem.y*ymax+ymax*self.RectItem.zoom/100
      x=x-w/2
      y=y-h/2
      if ToMove: 
        self.setPos(x,y)
        Rect=self.mapRectFromScene(QRectF(x,y,w,h))
        self.setRect(Rect)
      return x,y,w,h
      
    #function call each time a rectangle is move
    def itemChange(self, change, value):
      if (change == QtGui.QGraphicsItem.ItemPositionChange) :
        newpos = value.toPyObject()
        if self.IsCapture==True and self.BlockRecursion==False :
          self.BlockRecursion = True
          if self.TypeItem==0:    newpos=self.ResizeUpperLeft(newpos)     #Upper-Left corner
          elif self.TypeItem==1:  newpos=self.ResizeUpperRight(newpos)    #Upper-Right corner
          elif self.TypeItem==2:  newpos=self.ResizeBottomLeft(newpos)    #Bottom-Left corner
          elif self.TypeItem==3:  newpos=self.ResizeBottomRight(newpos)   #Bottom-Right corner
          self.BlockRecursion = False
        return newpos
      else :
        return QtGui.QGraphicsRectItem.itemChange(self, change, value)

    # Redefine paint to don't allow selection rectangle
    def paint(self,painter,option,widget=0):
      None

    #Resize from Upper-Left corner
    def ResizeUpperLeft(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #Magnetic guide
      if self.ZoomPointDlg.MagneticEdge.isChecked()==True:
        mw = 2*(xmax/100)
        mh = 2*(ymax/100)
        if self.ZoomPointDlg.MagnetX1!=-1 and x+(w/2)>(self.ZoomPointDlg.MagnetX1-mw) and x+(w/2)<(self.ZoomPointDlg.MagnetX1+mw) :
          x=self.ZoomPointDlg.MagnetX1-(w/2)
        if self.ZoomPointDlg.MagnetY1!=-1 and y+(h/2)>(self.ZoomPointDlg.MagnetY1-mh) and y+(h/2)<(self.ZoomPointDlg.MagnetY1+mh) :
          y=self.ZoomPointDlg.MagnetY1-(h/2)
          imgh=self.RectItem.BottomRight.pos().y()-h/2-y+h/2
          NewZoom=(imgh/ymax)*100
          imgw=xmax*NewZoom/100
          x=self.RectItem.BottomRight.pos().x()+w/2-imgw-w/2
      #get value of opposite resize corner
      blockx = self.RectItem.BottomRight.pos().x()-w
      blocky = self.RectItem.BottomRight.pos().y()-h
      #crop rectangle in the image
      if x<-(w/2): x=-w/2
      if x>blockx: x=blockx
      if y < -(h/2): y=-(h/2)
      if y>blocky: y=blocky
      #Last process : respect image geometry
      imgw = blockx-x
      if self.RectItem.IsImageWide==True:               #format 16/9
        imgh = (imgw/16)*9
        if blocky-imgh<-(h/2):
          imgh = blocky-y
          imgw = (imgh/9)*16
          x    = blockx-imgw
        else: 
          y = blocky-imgh
      else:                                             #format 4/3
        imgh = (imgw/4)*3
        if blocky-imgh<-(h/2):
          imgh = blocky-y
          imgw = (imgh/3)*4
          x    = blockx-imgw
        else: 
          y = blocky-imgh

      #Now, update RectItem
      imgw=(self.RectItem.BottomRight.pos().x()-x)
      imgh=(self.RectItem.BottomRight.pos().y()-y)
      self.RectItem.zoom=(imgw/xmax)*100
      self.RectItem.x=(x+(w/2))/xmax
      self.RectItem.y=(y+(h/2))/ymax
      self.RectItem.setPos(self.RectItem.x*xmax,self.RectItem.y*ymax)
      Rect=self.RectItem.mapRectFromScene(QRectF(self.RectItem.x*xmax,self.RectItem.y*ymax,imgw,imgh))
      self.RectItem.setRect(Rect)
      self.RectItem.ZoomPointDlg.SetupInterface()
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos
      
    #Resize from Upper-Right corner
    def ResizeUpperRight(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #Magnetic guide
      if self.ZoomPointDlg.MagneticEdge.isChecked()==True:
        mw = 2*(xmax/100)
        mh = 2*(ymax/100)
        if self.ZoomPointDlg.MagnetX2!=-1 and x+(w/2)>(self.ZoomPointDlg.MagnetX2-mw) and x+(w/2)<(self.ZoomPointDlg.MagnetX2+mw) :
          x=self.ZoomPointDlg.MagnetX2-(w/2)
        if self.ZoomPointDlg.MagnetY1!=-1 and y+(h/2)>(self.ZoomPointDlg.MagnetY1-mh) and y+(h/2)<(self.ZoomPointDlg.MagnetY1+mh) :
          y=self.ZoomPointDlg.MagnetY1-(h/2)
          imgh=self.RectItem.BottomLeft.pos().y()-h/2-y+h/2
          NewZoom=(imgh/ymax)*100
          imgw=xmax*NewZoom/100
          x=self.RectItem.BottomLeft.pos().x()+w/2+imgw-w/2
      #get value of opposite resize corner
      blockx = self.RectItem.BottomLeft.pos().x()+w
      blocky = self.RectItem.BottomLeft.pos().y()-h
      #crop rectangle in the image
      if x<blockx: x=blockx
      if x>xmax-(w/2): x=xmax-(w/2)
      if y < -(h/2): y=-(h/2)
      if y>blocky: y=blocky
      #Last process : respect image geometry
      imgw = x-blockx
      if self.RectItem.IsImageWide==True:               #format 16/9
        imgh = (imgw/16)*9
        if blocky-imgh<-(h/2):
          imgh = blocky-y
          imgw = (imgh/9)*16
          x    = blockx+imgw
        else: 
          y = blocky-imgh
      else:                                             #format 4/3
        imgh = (imgw/4)*3
        if blocky-imgh<-(h/2):
          imgh = blocky-y
          imgw = (imgh/3)*4
          x    = blockx+imgw
        else: 
          y = blocky-imgh
      #Now, update RectItem
      imgw=(x-self.RectItem.BottomLeft.pos().x())
      imgh=(self.RectItem.BottomLeft.pos().y()-y)
      self.RectItem.zoom=(imgw/xmax)*100
      self.RectItem.y=(y+(h/2))/ymax
      self.RectItem.setPos(self.RectItem.x*xmax,self.RectItem.y*ymax)
      Rect=self.RectItem.mapRectFromScene(QRectF(self.RectItem.x*xmax,self.RectItem.y*ymax,imgw,imgh))
      self.RectItem.setRect(Rect)
      self.RectItem.ZoomPointDlg.SetupInterface()
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos
      
    #Resize from Bottom-Left corner
    def ResizeBottomLeft(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #Magnetic guide
      if self.ZoomPointDlg.MagneticEdge.isChecked()==True:
        mw = 2*(xmax/100)
        mh = 2*(ymax/100)
        if self.ZoomPointDlg.MagnetX1!=-1 and x+(w/2)>(self.ZoomPointDlg.MagnetX1-mw) and x+(w/2)<(self.ZoomPointDlg.MagnetX1+mw) :
          x=self.ZoomPointDlg.MagnetX1-(w/2)
        if self.ZoomPointDlg.MagnetY2!=-1 and y+(h/2)>(self.ZoomPointDlg.MagnetY2-mh) and y+(h/2)<(self.ZoomPointDlg.MagnetY2+mh) :
          y=self.ZoomPointDlg.MagnetY2-(h/2)
          imgh=y+h/2-self.RectItem.UpperRight.pos().y()-h/2
          NewZoom=(imgh/ymax)*100
          imgw=xmax*NewZoom/100
          x=self.RectItem.UpperRight.pos().x()+w/2-imgw-w/2
      #get value of opposite resize corner
      blockx = self.RectItem.UpperRight.pos().x()-w
      blocky = self.RectItem.UpperRight.pos().y()+h
      #crop rectangle in the image
      if x<-(w/2): x=-w/2
      if x>blockx: x=blockx
      if y<blocky: y=blocky
      if y>ymax-(h/2): y=ymax-(h/2)
      #Last process : respect image geometry
      imgw = blockx-x
      if self.RectItem.IsImageWide==True:               #format 16/9
        imgh = (imgw/16)*9
        if imgh+blocky>ymax-(h/2):
          imgh = y-blocky
          imgw = (imgh/9)*16
          x    = blockx-imgw
        else: 
          y = blocky+imgh
      else:                                             #format 4/3
        imgh = (imgw/4)*3
        if imgh+blocky>ymax-(h/2):
          imgh = y-blocky
          imgw = (imgh/3)*4
          x    = blockx-imgw
        else: 
          y = blocky+imgh
      #Now, update RectItem
      imgw=(self.RectItem.UpperRight.pos().x()-x)
      imgh=(y-self.RectItem.UpperRight.pos().y())
      self.RectItem.zoom=(imgw/xmax)*100
      self.RectItem.x=(x+(w/2))/xmax
      self.RectItem.setPos(self.RectItem.x*xmax,self.RectItem.y*ymax)
      Rect=self.RectItem.mapRectFromScene(QRectF(self.RectItem.x*xmax,self.RectItem.y*ymax,imgw,imgh))
      self.RectItem.setRect(Rect)
      self.RectItem.ZoomPointDlg.SetupInterface()
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos
      
    #Resize from Bottom-Right corner
    def ResizeBottomRight(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #Magnetic guide
      if self.ZoomPointDlg.MagneticEdge.isChecked()==True:
        mw = 2*(xmax/100)
        mh = 2*(ymax/100)
        if self.ZoomPointDlg.MagnetX2!=-1 and x+(w/2)>(self.ZoomPointDlg.MagnetX2-mw) and x+(w/2)<(self.ZoomPointDlg.MagnetX2+mw) :
          x=self.ZoomPointDlg.MagnetX2-(w/2)
        if self.ZoomPointDlg.MagnetY2!=-1 and y+(h/2)>(self.ZoomPointDlg.MagnetY2-mh) and y+(h/2)<(self.ZoomPointDlg.MagnetY2+mh) :
          y=self.ZoomPointDlg.MagnetY2-(h/2)
          imgh=y+h/2-self.RectItem.UpperLeft.pos().y()-h/2
          NewZoom=(imgh/ymax)*100
          imgw=xmax*NewZoom/100
          x=self.RectItem.UpperLeft.pos().x()+w/2+imgw-w/2
      #get value of opposite resize corner
      blockx = self.RectItem.UpperLeft.pos().x()+w
      blocky = self.RectItem.UpperLeft.pos().y()+h
      #crop rectangle in the image
      if x<blockx:      x=blockx
      if x>xmax-(w/2):  x=xmax-(w/2)
      if y<blocky:      y=blocky
      if y>ymax-(h/2):  y=ymax-(h/2)
      #Last process : respect image geometry
      imgw = x-blockx
      if self.RectItem.IsImageWide==True:               #format 16/9
        imgh = (imgw/16)*9
        if imgh+blocky>ymax-(h/2):
          imgh = y-blocky
          imgw = (imgh/9)*16
          x    = blockx+imgw
        else: 
          y = blocky+imgh
      else:                                             #format 4/3
        imgh = (imgw/4)*3
        if imgh+blocky>ymax-(h/2):
          imgh = y-blocky
          imgw = (imgh/3)*4
          x    = blockx+imgw
        else: 
          y = blocky+imgh
      #Now, update RectItem
      imgw=(x-self.RectItem.UpperLeft.pos().x())
      imgh=(y-self.RectItem.UpperLeft.pos().y())
      self.RectItem.zoom=(imgw/xmax)*100
      self.RectItem.setPos(self.RectItem.x*xmax,self.RectItem.y*ymax)
      Rect=self.RectItem.mapRectFromScene(QRectF(self.RectItem.x*xmax,self.RectItem.y*ymax,imgw,imgh))
      self.RectItem.setRect(Rect)
      self.RectItem.ZoomPointDlg.SetupInterface()
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
#class use to crop rectangle into the image
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class QMyGraphicsRectItem(QtGui.QGraphicsRectItem):

    # x,y and zoom are always give in %
    def __init__(self,scene,ZValue,x,y,zoom,xmax,ymax,IsImageWide,ZoomPointDlg,parent=None):
      self.x               = x
      self.y               = y
      self.zoom            = float(zoom)
      self.ZoomPointDlg    = ZoomPointDlg
      self.IsImageWide     = IsImageWide
      self.BlockZoomChange = False            # flag to block zoom changing during change % to pixel
      self.IsCapture       = False

      #Init item
      super(QMyGraphicsRectItem,self).__init__(self.x*xmax,self.y*ymax,xmax*self.zoom/100,ymax*self.zoom/100,parent)
      self.setPos(self.x*xmax,self.y*ymax)
      Rect=self.mapRectFromScene(QRectF(self.x*xmax,self.y*ymax,xmax*self.zoom/100,ymax*self.zoom/100))
      self.setRect(Rect)

      #define Mouse cursor
      self.setCursor(Qt.SizeAllCursor)

      #define a pen for the rectangle
      col=QColor(255,0,0)
      pen=QPen(col)
      pen.setWidth(1)
      self.setPen(pen)

      #define Flags
      try :
        self.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable | QGraphicsItem.ItemSendsScenePositionChanges | QGraphicsItem.ItemSendsGeometryChanges)
      except :
        self.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable)

      self.setZValue(ZValue)

      #Add this item to the scene and create resize box
      scene.addItem(self)
      self.UpperLeft  =QResizeGraphicsRectItem(scene,self,ZValue+1,0,xmax,ymax,self.ZoomPointDlg)
      self.UpperRight =QResizeGraphicsRectItem(scene,self,ZValue+1,1,xmax,ymax,self.ZoomPointDlg)
      self.BottomLeft =QResizeGraphicsRectItem(scene,self,ZValue+1,2,xmax,ymax,self.ZoomPointDlg)
      self.BottomRight=QResizeGraphicsRectItem(scene,self,ZValue+1,3,xmax,ymax,self.ZoomPointDlg)

    def paint(self,painter,option,widget=0):
      None

    def mousePressEvent(self, event):
      QGraphicsRectItem.mousePressEvent(self,event)
      self.IsCapture = True

    def mouseReleaseEvent(self, event):
      self.IsCapture = False
      QGraphicsRectItem.mouseReleaseEvent(self,event)

    #function call each time a rectangle is move
    def itemChange(self, change, value):
      if (change == QtGui.QGraphicsItem.ItemPositionChange) :
        newpos = value.toPyObject()
        if self.IsCapture==True:
          xmax = self.scene().sceneRect().width()
          ymax = self.scene().sceneRect().height()
          self.x = newpos.x()/xmax
          self.y = newpos.y()/ymax
          #calcul width and height
          w = float(float(xmax)*float(self.zoom)/100)
          if self.IsImageWide==True:                            #format 16/9
            h = float((w/16)*9)
            if h>ymax:
              h = float(float(ymax)*float(self.zoom)/100)
              w = float((h/9)*16)
          else:                                                 #format 4/3
            h = float((w/4)*3)
            if h>ymax:
              h = float(float(ymax)*float(self.zoom)/100)
              w = float((h/3)*4)
          #crop rectangle in the image
          if self.x*xmax < 0: self.x=0
          if self.x*xmax > xmax-w: self.x=(xmax-w)/xmax
          if self.y*ymax < 0: self.y=0
          if self.y*ymax > ymax-h: self.y=(ymax-h)/ymax

          if self.ZoomPointDlg.MagneticEdge.isChecked()==True:
            mw = 2*(xmax/100)
            mh = 2*(ymax/100)
            if self.ZoomPointDlg.MagnetX1!=-1 and self.x*xmax>(self.ZoomPointDlg.MagnetX1-mw) and self.x*xmax<(self.ZoomPointDlg.MagnetX1+mw) :
              self.x=self.ZoomPointDlg.MagnetX1/xmax
            if self.ZoomPointDlg.MagnetX2!=-1 and (self.x*xmax+w)>(self.ZoomPointDlg.MagnetX2-mw) and (self.x*xmax+w)<(self.ZoomPointDlg.MagnetX2+mw) :
              self.x=(self.ZoomPointDlg.MagnetX2-w)/xmax
            if self.ZoomPointDlg.MagnetY1!=-1 and self.y*ymax>(self.ZoomPointDlg.MagnetY1-mh) and self.y*ymax<(self.ZoomPointDlg.MagnetY1+mh) :
              self.y=self.ZoomPointDlg.MagnetY1/ymax
            if self.ZoomPointDlg.MagnetY2!=-1 and (self.y*ymax+h)>(self.ZoomPointDlg.MagnetY2-mh) and (self.y*ymax+h)<(self.ZoomPointDlg.MagnetY2+mh) :
              self.y=(self.ZoomPointDlg.MagnetY2-h)/ymax

          newpos.setX(self.x*xmax)
          newpos.setY(self.y*ymax)
          self.ZoomPointDlg.SetupInterface()
        return newpos
      else :
        return QtGui.QGraphicsRectItem.itemChange(self, change, value)
        
    #function call by videoporama class each time zoom is change
    def zoomChange(self, NewZoom):
      if self.BlockZoomChange == False :
        xmax = self.scene().sceneRect().width()
        ymax = self.scene().sceneRect().height()
        self.zoom = NewZoom
        Pos=self.scenePos()
        self.x=Pos.x()/xmax
        self.y=Pos.y()/ymax
        #calcul width and height
        w = float(float(xmax)*float(self.zoom)/100)
        if self.IsImageWide==True:                            #format 16/9
          h = float((w/16)*9)
          if h>ymax:
            h = float(float(ymax)*float(self.zoom)/100)
            w = float((h/9)*16)
        else:                                                 #format 4/3
          h = float((w/4)*3)
          if h>ymax:
            h = float(float(ymax)*float(self.zoom)/100)
            w = float((h/3)*4)
        #crop rectangle in the image
        if self.x*xmax < 0: self.x=0
        if self.x*xmax > xmax-w: self.x=(xmax-w)/xmax
        if self.y*ymax < 0: self.y=0
        if self.y*ymax > ymax-h: self.y=(ymax-h)/ymax
        #en deux temps : d'abord bouger pour que les équivalents item repasse à zéro !
        if Pos.x()!=self.x*xmax or Pos.y()!=self.y*ymax: self.setPos(self.x*xmax,self.y*ymax)
        #les coordonnées scene sont maintenant ok : on peu retailler
        Rect=self.mapRectFromScene(QRectF(self.x*xmax,self.y*ymax,w,h))
        self.setRect(Rect)
        self.ZoomPointDlg.SetupInterface()

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
# DefZoomPoint dialog box
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class DefZoomPointDlg(QDialog,Ui_DefZoomPointDlg) : #OK QT4

    def __init__(self,timelineImage,item,VideoporamaInstance,parent=None):
      super(DefZoomPointDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      self.StopMAJSpinbox      = False
      self.VideoporamaInstance = VideoporamaInstance
      self.timelineImage       = timelineImage
      self.item                = item
      self.scene               = None
      self.MagnetX1            = -1
      self.MagnetX2            = -1
      self.MagnetY1            = -1
      self.MagnetY2            = -1
      self.MagneticEdge.setChecked(True)

    def FirstInit(self):
      #Calc display width in system unit
      self.xmax =float(self.SceneBox.width())
      if self.VideoporamaInstance.imgformat==1 :
        self.ymax=(self.xmax/16)*9
      else :
        self.ymax=(self.xmax/4)*3
      if self.ymax>self.SceneBox.height() :
        self.ymax=float(self.SceneBox.height())
        if self.VideoporamaInstance.imgformat==1 :
          self.xmax=(self.ymax/9)*16
        else :
          self.xmax=(self.ymax/3)*4

      self.scene = QGraphicsScene()
      self.SceneBox.setScene(self.scene)
      self.SceneBox.setInteractive(True)
      self.scene.setSceneRect(QRectF(0,0,self.xmax,self.ymax))
      self.SceneBox.fitInView(QRectF(0,0,self.xmax,self.ymax),Qt.KeepAspectRatio)

      #--------------------------------------------------------------------
      # Set the QMyGraphicsRectItem
      #--------------------------------------------------------------------
      self.cadre=QMyGraphicsRectItem(self.scene,100,self.item.x,self.item.y,self.item.zoom,self.xmax,self.ymax,self.VideoporamaInstance.imgformat==1,self)

      #--------------------------------------------------------------------
      # Set handler
      #--------------------------------------------------------------------
      self.VideoporamaInstance.qtapp.connect(self.ZoomPointXValue,SIGNAL("valueChanged(double)"),self.ChgZoomPointXValue)
      self.VideoporamaInstance.qtapp.connect(self.ZoomPointYValue,SIGNAL("valueChanged(double)"),self.ChgZoomPointYValue)
      self.VideoporamaInstance.qtapp.connect(self.ZoomPointZoomValue,SIGNAL("valueChanged(double)"),self.ChgZoomPointZoomValue)
      self.VideoporamaInstance.qtapp.connect(self.Ok,SIGNAL("pressed()"),self.VideoporamaInstance.TableZoomPoint_DefZoomPointOk)
      self.VideoporamaInstance.qtapp.connect(self.Cancel,SIGNAL("pressed()"),self.onCancel)
      self.VideoporamaInstance.qtapp.connect(self.MagneticEdge,SIGNAL("stateChanged(int)"),self.ChgMagnetic)
      self.VideoporamaInstance.qtapp.connect(self.HelpBt,SIGNAL("pressed()"),self.onHelp)

      # Prepare image
      self.image = self.timelineImage.ToRenderImageForDisplay(0,self.xmax,self.ymax,0,0,0,0,True,DontRenderImageText=False,DontRenderZoomPointText=True)

      # Calc guides positions
      VirtX=float(self.item.ImageItem.RealImageSizeWidth)
      if self.VideoporamaInstance.imgformat==1 : VirtY=(VirtX/16)*9
      else :                                     VirtY=(VirtX/4)*3
      if VirtY<float(self.item.ImageItem.RealImageSizeHeight) :
        VirtY=float(self.item.ImageItem.RealImageSizeHeight)
        if self.VideoporamaInstance.imgformat==1 : VirtX=(VirtY/9)*16
        else :                                     VirtX=(VirtY/3)*4
        Ratio=float(self.ymax)/VirtY
      else :
        Ratio=float(self.xmax)/VirtX

      self.MagnetX1=-1
      self.MagnetX2=-1
      self.MagnetY1=-1
      self.MagnetY2=-1
      if (float(self.item.ImageItem.RealImageSizeWidth)*Ratio!=self.image.width()) :
        # bandes noires sur les cotés
        self.MagnetX1=(float(self.xmax)-(float(self.item.ImageItem.RealImageSizeWidth)*Ratio))/2
        self.MagnetX2=self.MagnetX1+(float(self.item.ImageItem.RealImageSizeWidth)*Ratio)
      if (float(self.item.ImageItem.RealImageSizeHeight)*Ratio!=self.image.height()) :
        # bandes noires en haut et en bas
        self.MagnetY1=(float(self.ymax)-(float(self.item.ImageItem.RealImageSizeHeight)*Ratio))/2
        self.MagnetY2=self.MagnetY1+(float(self.item.ImageItem.RealImageSizeHeight)*Ratio)

      self.SetupInterface()

    def onHelp(self):
      self.docw=DocHelp(self.VideoporamaInstance,self)
      self.docw.SetSourceDocument(self.VideoporamaInstance.qtapp.translate("Documentation","en-zoombox.html"))
      self.docw.show() 

    def onCancel(self):
      self.close()

    def closeEvent(self, CloseEvent):
      None

    def resizeEvent(self, event) :
      if self.scene!=None:
        #Calc display width in system unit
        self.xmax =float(self.SceneBox.width())
        if self.VideoporamaInstance.imgformat==1 :
          self.ymax=(self.xmax/16)*9
        else :
          self.ymax=(self.xmax/4)*3
        if self.ymax>self.SceneBox.height() :
          self.ymax=float(self.SceneBox.height())
          if self.VideoporamaInstance.imgformat==1 :
            self.xmax=(self.ymax/9)*16
          else :
            self.xmax=(self.ymax/3)*4

        self.scene.setSceneRect(QRectF(0,0,self.xmax,self.ymax))
        self.SceneBox.fitInView(QRectF(0,0,self.xmax,self.ymax),Qt.KeepAspectRatio)

        #Move and resize cadre item
        self.cadre.xmax=self.xmax
        self.cadre.ymax=self.ymax
        self.cadre.setPos(self.cadre.x*self.xmax,self.cadre.y*self.ymax)
        Rect=self.cadre.mapRectFromScene(QRectF(self.cadre.x*self.xmax,self.cadre.y*self.ymax,(self.cadre.zoom/100)*self.xmax,(self.cadre.zoom/100)*self.ymax))
        self.cadre.setRect(Rect)
        #Don't need to move Resize Rectangles because SetupInterface how do this job !

        # Update guides positions
        VirtX=float(self.item.ImageItem.RealImageSizeWidth)
        if self.VideoporamaInstance.imgformat==1 : VirtY=(VirtX/16)*9
        else :                                     VirtY=(VirtX/4)*3
        if VirtY<float(self.item.ImageItem.RealImageSizeHeight) :
          VirtY=float(self.item.ImageItem.RealImageSizeHeight)
          if self.VideoporamaInstance.imgformat==1 : VirtX=(VirtY/9)*16
          else :                                     VirtX=(VirtY/3)*4
          Ratio=float(self.ymax)/VirtY
        else :
          Ratio=float(self.xmax)/VirtX

        self.MagnetX1=-1
        self.MagnetX2=-1
        self.MagnetY1=-1
        self.MagnetY2=-1
        if (float(self.item.ImageItem.RealImageSizeWidth)*Ratio!=self.image.width()) :
          # bandes noires sur les cotés
          self.MagnetX1=(float(self.xmax)-(float(self.item.ImageItem.RealImageSizeWidth)*Ratio))/2
          self.MagnetX2=self.MagnetX1+(float(self.item.ImageItem.RealImageSizeWidth)*Ratio)
        if (float(self.item.ImageItem.RealImageSizeHeight)*Ratio!=self.image.height()) :
          # bandes noires en haut et en bas
          self.MagnetY1=(float(self.ymax)-(float(self.item.ImageItem.RealImageSizeHeight)*Ratio))/2
          self.MagnetY2=self.MagnetY1+(float(self.item.ImageItem.RealImageSizeHeight)*Ratio)

        # Prepare image
        self.image = self.timelineImage.ToRenderImageForDisplay(0,self.xmax,self.ymax,0,0,0,0,True,DontRenderImageText=False,DontRenderZoomPointText=True)
        # Update all
        self.SetupInterface()

    def SetupInterface(self):
      if self.StopMAJSpinbox: return
      self.StopMAJSpinbox=True
      if self.VideoporamaInstance.ConfDisplayUnit=="0" :
        # Define the value and max value (in %)
        self.ZoomPointXValue.setRange(0,99-self.cadre.zoom)
        self.ZoomPointXValue.setValue(self.cadre.x*100)
        self.ZoomPointXValue.setSingleStep(int(100/20)) 
        self.ZoomPointYValue.setRange(0,99-self.cadre.zoom)
        self.ZoomPointYValue.setValue(self.cadre.y*100)
        self.ZoomPointYValue.setSingleStep(int(100/20)) 
        self.ZoomPointZoomValue.setRange(1,100)
        self.ZoomPointZoomValue.setValue(self.cadre.zoom)
        self.ZoomPointZoomValue.setSingleStep(int(100/20)) 
        # Setup label associated with each edit
        self.ZoomPointXLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.ZoomPointYLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.ZoomPointZoomLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
      else :
        # Define the value and max value (in pixel)
        w=self.xmax*self.cadre.zoom/100
        h=self.ymax*self.cadre.zoom/100
        self.ZoomPointXValue.setRange(0,self.xmax-w)
        self.ZoomPointXValue.setValue(self.cadre.x*self.xmax)
        self.ZoomPointXValue.setSingleStep(int(self.xmax/20))
        self.ZoomPointYValue.setRange(0,self.ymax-h)
        self.ZoomPointYValue.setValue(self.cadre.y*self.ymax)
        self.ZoomPointYValue.setSingleStep(int(self.ymax/20))
        self.ZoomPointZoomValue.setRange(1,self.xmax)
        self.ZoomPointZoomValue.setValue(self.xmax*(self.cadre.zoom/100)) 
        self.ZoomPointZoomValue.setSingleStep(int(self.xmax/20)) 
        # Setup label associated with each edit
        self.ZoomPointXLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.xmax-w)))
        self.ZoomPointYLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.ymax-h)))
        self.ZoomPointZoomLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.xmax)))

      # Repaint
      if self.scene!=None:
        # Remove old image if exist
        for item in self.scene.items() :
          if item.data(0).toString()=="image" :
            self.scene.removeItem(item)

        PixImage=QPixmap.fromImage(self.image).copy()

        # Draw selection rectangle for self.cadre
        p=QPainter(PixImage)

        # draw rect out of the rectangle
        p.setPen(Qt.NoPen)
        p.setBrush(QBrush(toqcolor(QString("555555").toInt(16)[0])))
        p.setOpacity(0.75)
        p.drawRect(QRectF(0,0,self.xmax,self.cadre.y*self.ymax))
        p.drawRect(QRectF(0,self.cadre.y*self.ymax,self.cadre.x*self.xmax,(self.cadre.zoom/100)*self.ymax))
        p.drawRect(QRectF(self.cadre.x*self.xmax+(self.cadre.zoom/100)*self.xmax,self.cadre.y*self.ymax,self.xmax,(self.cadre.zoom/100)*self.ymax))
        p.drawRect(QRectF(0,self.cadre.y*self.ymax+(self.cadre.zoom/100)*self.ymax,self.xmax,self.ymax))
        p.setOpacity(1)
        p.setBrush(Qt.NoBrush)

        # draw guides
        p.setCompositionMode(QPainter.RasterOp_SourceXorDestination)
        if self.MagneticEdge.isChecked()==True:
          col=QColor(255,0,0)
          pen=QPen(col)
          pen.setWidth(1)
          pen.setJoinStyle(Qt.RoundJoin)
          pen.setStyle(Qt.DotLine)
          p.setPen(pen)
          if self.MagnetX1!=-1: p.drawLine(self.MagnetX1,0,self.MagnetX1,self.ymax)
          if self.MagnetX2!=-1: p.drawLine(self.MagnetX2,0,self.MagnetX2,self.ymax)
          if self.MagnetY1!=-1: p.drawLine(0,self.MagnetY1,self.xmax,self.MagnetY1)
          if self.MagnetY2!=-1: p.drawLine(0,self.MagnetY2,self.xmax,self.MagnetY2)
        p.setCompositionMode(QPainter.CompositionMode_SourceOver)
        p.end()

        # Add image to the background of the scene
        im=self.scene.addPixmap(PixImage)
        im.setData(0,QVariant(QString("image")))
        im.setZValue(20)
        im.setPos(0,0)

      self.StopMAJSpinbox=False
      #Move Resize Rectangle
      self.cadre.UpperLeft.CalcPosition()
      self.cadre.UpperRight.CalcPosition()
      self.cadre.BottomLeft.CalcPosition()
      self.cadre.BottomRight.CalcPosition()

    def ChgMagnetic(self) :
      self.SetupInterface()

    def ChgZoomPointXValue(self,Value):
      if self.StopMAJSpinbox: return
      if self.VideoporamaInstance.ConfDisplayUnit=="0" : Value=Value/100         # Define value in %
      else :                                             Value=Value/self.ymax   # Define value in Pixel
      self.cadre.x=Value
      self.cadre.setPos(Value*self.xmax,self.cadre.y*self.ymax)
      Rect=self.cadre.mapRectFromScene(QRectF(self.cadre.x*self.xmax,self.cadre.y*self.ymax,self.xmax*self.cadre.zoom/100,self.ymax*self.cadre.zoom/100))
      self.cadre.setRect(Rect)
      self.SetupInterface()
      self.repaint()

    def ChgZoomPointYValue(self,Value):
      if self.StopMAJSpinbox: return
      if self.VideoporamaInstance.ConfDisplayUnit=="0" : Value=Value/100         # Define value in %
      else :                                             Value=Value/self.ymax   # Define value in Pixel
      self.cadre.y=Value
      self.cadre.setPos(self.cadre.x*self.xmax,Value*self.ymax)
      Rect=self.cadre.mapRectFromScene(QRectF(self.cadre.x*self.xmax,self.cadre.y*self.ymax,self.xmax*self.cadre.zoom/100,self.ymax*self.cadre.zoom/100))
      self.cadre.setRect(Rect)
      self.SetupInterface()
            
    def ChgZoomPointZoomValue(self,Value):
      if self.StopMAJSpinbox: return
      if self.VideoporamaInstance.ConfDisplayUnit=="0" :  None                        # Define value in %
      else:                                               Value=(Value/self.xmax)*100 # Define value in Pixel
      self.cadre.zoom=Value
      self.cadre.zoomChange(Value)
      self.SetupInterface()
