/*
 * Copyright (c) 2003-2006 Erez Zadok
 * Copyright (c) 2003-2006 Charles P. Wright
 * Copyright (c) 2005-2006 Josef Sipek
 * Copyright (c) 2005      Arun M. Krishnakumar
 * Copyright (c) 2005-2006 David P. Quigley
 * Copyright (c) 2003-2004 Mohammad Nayyer Zubair
 * Copyright (c) 2003      Puja Gupta
 * Copyright (c) 2003      Harikesavan Krishnan
 * Copyright (c) 2003-2006 Stony Brook University
 * Copyright (c) 2003-2006 The Research Foundation of State University of New York
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package.
 *
 * This Copyright notice must be kept intact and distributed with all sources.
 */

#ifndef __UNIONFS_UTILS_H_
#define __UNIONFS_UTILS_H_

#include <sys/statfs.h>

#define MAY_READ 4
#define MAY_WRITE 2

#define UUID_LEN 16

typedef u_int8_t uint8_t;
typedef u_int32_t uint32_t;
typedef u_int64_t uint64_t;

/* Branch information */
struct unionfs_branch {
	char *path;
	int perms;
};

struct fmaphdr {
	uint32_t magic;
	uint32_t version;
	uint8_t usedbranches;
	uint8_t uuid[UUID_LEN];
};

int unionfs_query(const char *file_path, struct unionfs_branch **ufs_branches);
int unionfs_dump(const char *union_path, const char *prefix);
int unionfs_find_union(const char *union_path, char **actual_path);
int unionfs_add(const char *union_path, const char *branch_path, int branch_number, int perms);
int unionfs_remove(const char *union_path, int branch);
int unionfs_get_branch(const char *union_path, const char *branch_path);
int unionfs_mode(const char *union_path, int branch_number, int perms);

int unionfs_debug_get_value(int fd, int *val);
int unionfs_debug_set_value(int fd, int *val);
int unionfs_debug_refcounts(int fd, int *num_branches, int **counts);
int unionfs_debug_inc_gencount(int fd);

int unionfs_create_forwardmap(char *filename);
int unionfs_open_forwardmap(struct fmaphdr *header, char *forwardmap);
int unionfs_create_reversemap(char *filename, char *path, char *forwardmap);
int unionfs_dump_map(char *filename, int debug_level);

#endif
