/*
 * Copyright (c) 2003-2006 Erez Zadok
 * Copyright (c) 2003-2006 Charles P. Wright
 * Copyright (c) 2005-2006 Josef Sipek
 * Copyright (c) 2005      Arun M. Krishnakumar
 * Copyright (c) 2005-2006 David P. Quigley
 * Copyright (c) 2003-2004 Mohammad Nayyer Zubair
 * Copyright (c) 2003      Puja Gupta
 * Copyright (c) 2003      Harikesavan Krishnan
 * Copyright (c) 2003-2006 Stony Brook University
 * Copyright (c) 2003-2006 The Research Foundation of State University of New York
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package.
 *
 * This Copyright notice must be kept intact and distributed with all sources.
 */

#ifndef __UNIONDBG_H_
#define __UNIONDBG_H_

#include "config.h"

#ifdef HAVE_STDLIB_H
	#include <stdlib.h>
#else /* HAVE_STDLIB_H */
	#error Need stdlib.h to compile
#endif /* HAVE_STDLIB_H */

#ifdef HAVE_STDIO_H
	#include <stdio.h>
#else /* HAVE_STDIO_H */
	#error Need stdio.h to compile
#endif /* HAVE_STDIO_H */

#ifdef HAVE_UNISTD_H
	#include <unistd.h>
#else /* HAVE_UNISTD_H */
	#error Need unistd.h to compile
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_STRING_H
	#include <string.h>
#else /* HAVE_STRING_H */
	#error Need string.h to compile
#endif /* HAVE_STRING_H */

#ifdef HAVE_FCNTL_H
	#include <fcntl.h>
#else /* HAVE_FCNTL_H */
	#error Need fcntl.h to compile
#endif /* HAVE_FCNTL_H */

#ifdef HAVE_SYS_IOCTL_H
        #include <sys/ioctl.h>
#else   /* HAVE_SYS_IOCTL_H */
        #error Need sys/ioctl.h to compile
#endif /* HAVE_SYS_IOCTL_H */

#ifdef HAVE_ERRNO_H
        #include <errno.h>
#else /* HAVE_ERRNO_H */
	#error Need errno.h to compile
#endif /* HAVE_ERRNO_H */

int unionfs_debug_get_value(int fd, int *val);
int unionfs_debug_set_value(int fd, int *val);
int unionfs_debug_refcounts(int fd, int *num_branches, int **counts);
int unionfs_debug_inc_gencount(int fd);

#endif
