/*
 * Copyright (c) 2003-2006 Erez Zadok
 * Copyright (c) 2003-2006 Charles P. Wright
 * Copyright (c) 2005-2006 Josef Sipek
 * Copyright (c) 2005      Arun M. Krishnakumar
 * Copyright (c) 2005-2006 David P. Quigley
 * Copyright (c) 2003-2004 Mohammad Nayyer Zubair
 * Copyright (c) 2003      Puja Gupta
 * Copyright (c) 2003      Harikesavan Krishnan
 * Copyright (c) 2003-2006 Stony Brook University
 * Copyright (c) 2003-2006 The Research Foundation of State University of New York
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package.
 *
 * This Copyright notice must be kept intact and distributed with all sources.
 */
/*
 *  $Id: uniondbg.c,v 1.4 2006/12/09 23:35:51 ezk Exp $
 */

#include "uniondbg.h"

#define MAY_READ 4
#define MAY_WRITE 2

static int opt_d = 0;
static int opt_c = 0;
static int opt_g = 0;
static int optcount;
static const char *progname;

void usage(void)
{
	fprintf(stderr, "Usage:\n"
		"%s -d file [val]\n\tto set/get debugging values\n"
		"%s -c file\n\tto print out branch reference counts (in kernel debug output)\n"
		"%s -g file\n\tto increment the super block generation count\n",
		progname, progname, progname);
	exit(1);
}

int main(int argc, char *argv[])
{
	int fd, ret, val = 0;
	int i;

	progname = argv[0];

	/* check that minimum number of args were specified */
	if (argc < 3)
		usage();

	if (strcmp(argv[1], "-d") == 0) {
		if (argc > 4)
			usage();
		opt_d++;
		optcount++;
	}
	if (strcmp(argv[1], "-c") == 0) {
		if (argc > 3)
			usage();
		opt_c++;
		optcount++;
	}
	if (strcmp(argv[1], "-g") == 0) {
		if (argc > 3)
			usage();
		opt_g++;
		optcount++;
	}

	/* check that at least one option was used */
	if (!optcount)
		usage();

	/* open file on which ioctl will operate */
	fd = open(argv[2], O_RDONLY);
	if (fd < 0) {
		perror(argv[2]);
		exit(1);
	}

	/* if specified 3rd arg, want to set debug level */
	if (opt_d) {
		if (argc == 4) {
			val = atoi(argv[3]);
			ret = unionfs_debug_set_value(fd, &val );
			if (ret < 0) {
				perror("ioctl set");
				exit(1);
			}
		} else {
			ret = unionfs_debug_get_value(fd, &val );
			if (ret < 0) {
				perror("ioctl get");
				exit(1);
			}
			printf("debug ioctl returned value %d\n", val);
		}
		goto out;
	}

	/* branch refcounts */
	if (opt_c) {
		int *counts = NULL;
		int branches;
		ret = unionfs_debug_refcounts(fd, &branches, &counts);

		if (ret < 0) {
			perror("ioctl branchcount");
			if ( counts ) free(counts);
			exit(1);
		}

		printf("%d total branches.\n", branches);
		for (i = 0; i < branches; i++) {
			printf("%d: %d\n", i, counts[i]);
		}
		free(counts);
		goto out;
	}

	/* Update generation number. */
	if (opt_g) {
		ret = unionfs_debug_inc_gencount(fd);
		if (ret < 0) {
			perror("ioctl incgen");
			exit(1);
		}
		printf("New generation %d\n", ret);
		goto out;
	}

      out:
	close(fd);
	exit(0);
}

/*
 *
 * vim:shiftwidth=8
 * vim:tabstop=8
 *
 * For Emacs:
 * Local variables:
 * c-basic-offset: 8
 * c-comment-only-line-offset: 0
 * c-offsets-alist: ((statement-block-intro . +) (knr-argdecl-intro . 0)
 *              (substatement-open . 0) (label . 0) (statement-cont . +))
 * indent-tabs-mode: t
 * tab-width: 8
 * End:
 */
