%{!?kernel: %{expand: %%define kernel %(uname -r)}}
%define kversion %(echo %{kernel} | sed -e s/-[a-z]*$// - )
%define krelver %(echo %{kversion} | tr -s '-' '_')
%if %(echo %{kernel} | egrep -c [a-z])
   %{expand:%%define ktype -%(echo %{kernel} | sed 's/[0-9]//g; s/\.//g; s/-//g')}
%endif

%define unionfsrel 1

Summary: Unionfs control tools and shared library
Name: unionfs_utils
Version: 0.2pre
License: GPL
Release: %{unionfsrel}_%{krelver}
Requires: kernel%{?ktype} = %{kversion}, /sbin/depmod
Group: System/Filesystem
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
Unionfs is a stackable unification file system, which can appear to
merge the contents of several directories (branches), while keeping
their physical content separate.  Unionfs is useful for unified source
tree management, merged contents of split CD-ROM, merged separate
software package directories, data grids, and more.  Unionfs allows
any mix of read-only and read-write branches, as well as insertion and
deletion of branches anywhere in the fan-out.

This package contains the tools and a shared library used to control
a unionfs mount.

%prep
%setup

%build
sh bootstrap
sh configure --prefix=$RPM_BUILD_ROOT/usr/
make all

%install
mkdir -p $RPM_BUILD_ROOT
make install

%clean
make clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/bin/unionctl
/usr/bin/uniondbg
/usr/bin/unionimap
/usr/lib/libunionfs_utils.a
/usr/lib/libunionfs_utils.la
/usr/lib/libunionfs_utils.so
/usr/lib/libunionfs_utils.so.0
/usr/lib/libunionfs_utils.so.0.0.0
/usr/include/unionfs_utils.h

%doc AUTHORS ChangeLog COPYING NEWS README
/usr/man/man3/*
/usr/man/man8/*

%changelog
