/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef UG_CATEGORY_CMD_H
#define UG_CATEGORY_CMD_H

#include <ug_category.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct	UgCategoryCmd_			UgCategoryCmd;
typedef struct	UgCategoryCmdIter_		UgCategoryCmdIter;
typedef struct	UgRelationCmd_			UgRelationCmd;

extern const	UgDataClass*			UgCategoryCmdClass;
extern const	UgDataClass*			UgRelationCmdClass;


// ----------------------------------------------------------------------------
// UgCategoryCmd
//
// UgData
// |
// `- UgCategory  (abstract class)
//    |
//    +- UgCategoryCmd  (uget-cmd)
//    |
//    `- UgCategoryGtk  (uget-gtk)
//
struct UgCategoryCmd_
{
	UG_CATEGORY_MEMBERS;
//	const UgDataClass*	data_class;			// UG_DATA_MEMBERS
//	gchar*				name;
//	struct {
//		guint			active;
//		guint			finished;			// finished: completed and paused
//		guint			recycled;
//	} limit;
//	GList*				indices;			// used when program save/load category
//	UgDataset*			defaults;			// default setting of UgDataset
//	struct {
//		UgWatchFunc		func;				// watch (global)
//		gpointer		data;
//	} watch;

	UgCategoryCmd*		primary;
	GQueue*				queued;
	GQueue*				active;
	GQueue*				finished;
	GQueue*				recycled;
};

UgCategoryCmd*	ug_category_cmd_new  (UgCategoryCmd* primary);
void			ug_category_cmd_free (UgCategoryCmd* ccmd);

void	ug_category_cmd_add    (UgCategoryCmd* ccmd, UgDataset* dataset);
void	ug_category_cmd_remove (UgCategoryCmd* ccmd, UgDataset* dataset);
void	ug_category_cmd_switch (UgCategoryCmd* ccmd, UgDataset* dataset, UgCategoryHints hint);
void	ug_category_cmd_clear  (UgCategoryCmd* ccmd, UgCategoryHints hint, guint from_nth);

void	ug_category_cmd_move_to (UgCategoryCmd* ccmd, UgDataset* dataset, UgCategoryCmd* ccmd_dest);

// return 0: no active job
// return 1: no active job, some job stop by user
// return 2: running
gint	ug_category_cmd_run    (UgCategoryCmd* ccmd);

// get all jobs in this category, call g_list_free(list) to free returned list
GList*	ug_category_cmd_get_list (UgCategoryCmd* ccmd);

// return number of category still active
guint	ug_category_cmd_list_run (GList* category_cmd_list);

// ----------------------------------------------------------------------------
// UgCategoryCmdIter : iterator for UgCategoryCmd
//
struct UgCategoryCmdIter_
{
	UgCategoryCmd*		ccmd;
	GQueue*				queue;
	GList*				link;
};

// ----------------------------------------------------------------------------
// UgRelationCmd : relation of UgCategoryCmd, UgDataset, and UgPlugin.
//
// UgData
// |
// `- UgDataList
//    |
//    `- UgRelation  (abstract class)
//       |
//       +- UgRelationCmd  (uget-cmd)
//       |
//       `- UgRelationGtk  (uget-gtk)
//
struct UgRelationCmd_
{
	UG_RELATION_MEMBERS (UgRelationCmd);
//	const UgDataClass*	data_class;		// UG_DATA_LIST_MEMBERS (UgRelationCmd)
//	UgRelationCmd*		next;
//	UgRelationCmd*		prev;
//	guint				index;			// use index when program save/load file.
//	UgCategoryHints		hints;
//	UgPlugin*			plugin;			// plug-in
//	struct {
//		UgWatchFunc		func;			// watch
//		gpointer		data;
//	} watch;

	UgCategoryCmdIter	primary;
	UgCategoryCmdIter	secondary;
};


#ifdef __cplusplus
}
#endif

#endif  // UG_CATEGORY_CMD_H

