#include <config.h>
#include "ucarp.h"
#include "garp.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

int gratuitous_arp(const int dev_desc_fd, const int enable_virtual)
{
    static unsigned char arp[28] = {
            0x00, 0x01,
            0x08, 0x00,
            0x06, 0x04,
            0x00, 0x02,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff
    };    
    unsigned char *pkt;
    struct ether_header *eh_ptr;

    memcpy(&arp[8], hwaddr, sizeof hwaddr);    
    if (enable_virtual == 0) {
        arp[7] = 0x01;
        memcpy(&arp[24], &vaddr.s_addr, (size_t) 4U);
        memset(&arp[14], 0xff, ETHER_ADDR_LEN);
    } else {
        arp[7] = 0x02;
        memcpy(&arp[14], &vaddr.s_addr, (size_t) 4U);
        memset(&arp[24], 0xff, ETHER_ADDR_LEN);        
    }
    if ((pkt = ALLOCA(sizeof *eh_ptr + sizeof arp)) == NULL) {
        perror("out of memory to send gratuitous arp");
        return -1;
    }
    memcpy(pkt + sizeof *eh_ptr, arp, sizeof arp);
    eh_ptr = (struct ether_header *) pkt;
    memcpy(eh_ptr->ether_shost, &arp[8], ETHER_ADDR_LEN);
    memcpy(eh_ptr->ether_dhost, &arp[18], ETHER_ADDR_LEN);
    eh_ptr->ether_type = htons(ETHERTYPE_ARP);    
    if (write(dev_desc_fd, pkt, sizeof *eh_ptr + sizeof arp) < 0) {
#ifdef DEBUG
        perror("write");
#endif
        ALLOCA_FREE(pkt);
        return -1;
    }
    ALLOCA_FREE(pkt);
    
    return 0;
}
