# Copyright 2009-2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""The default glib/gtk main loop integration reactor for testing."""


def install(options=None):
    """Install the reactor and parse any options we might need."""
    reactor_name = None
    if options is not None and options.use_gui:
        reactor_name = 'twisted.internet.gtk2reactor'
    else:
        reactor_name = 'twisted.internet.glib2reactor'

    glibreactor = __import__(reactor_name, None, None, [''])
    glibreactor.install()
