#!/usr/bin/env python
# Copyright (C) 2007-2008 Canonical, Ltd.
# Author: Kees Cook <kees@ubuntu.com>
# License: GPLv3
import sys, os
import lpl_common
import re

def get_stuff(str):
    package = None
    target = None
    targeted_to = None
    if ' (' in str:
        package, target = str.split(' (',1)
        target = target.split(')')[0]
        if ' ' in target:
            target, targeted_to = target.split(' ',1)

    return package, target, targeted_to

def set_status(task, package, targeted_to, status):
    if status != "-" and task.status != status:
        print '%s,%s: status => %s' % (package,targeted_to,status)
        task.transitionToStatus(status=status)

def set_importance(task, package, targeted_to, importance):
    if importance != "-" and task.importance != importance:
        print '%s,%s: importance => %s' % (package,targeted_to,importance)
        task.transitionToImportance(importance=importance)

def set_assignee(task, package, targeted_to, assignee):
    if assignee != "-" and task.assignee != assignee:
        print '%s,%s: assignee => %s' % (package,targeted_to,assignee)
        task.transitionToAssignee(assignee=assignee)

if len(sys.argv) < 6:
    print 'Usage: reassign.py PKG STATUS IMPORTANCE ASSIGNEE TARGET bug [bug ...]'
    print '  Required arguments can be "-" to leave a field unchanged.'
    sys.exit(1)

pkg = sys.argv[1]
status = " ".join( [x.capitalize() for x in sys.argv[2].split(' ')] )
valid_status = ['New','Invalid','Fix Released','Fix Committed','Incomplete',"Won't Fix",'Confirmed','Triaged','In Progress','-']
if status not in valid_status:
    raise ValueError, 'Status must be one of "'+'", "'.join(valid_status)

importance = sys.argv[3]
if importance not in ['Critical','High','Medium','Low','Wishlist','-']:
    raise ValueError, "Invalid Importance"

launchpad = lpl_common.connect()

assignee = '-'
if sys.argv[4] != 'None' and sys.argv[4] != '-':
    assignee = launchpad.people[sys.argv[4]]

target_releases = []
if sys.argv[5] != None and sys.argv[5] != '-':
    target_releases = re.split(',', sys.argv[5])

for num in sys.argv[6:]:
    bug = launchpad.bugs[num]
    none_list = []
    nominated_list = []

    for task in bug.bug_tasks:
        package, target, targeted_to = get_stuff(task.bug_target_name)

        #print "package:%s targeted_to:%s" % (package, targeted_to)

        if target and target.lower() != 'ubuntu':
            print 'skipping target "%s" (%s)' % (target, package)
            continue
        if task.status in ['Fix Released', 'Incomplete', 'Invalid', "Won't Fix"]:
            print 'skipping (pkg:%s targeted_to:%s status:%s)' % (package, targeted_to, task.status)
            continue
        if len(target_releases) > 0 and targeted_to not in target_releases:
            print 'skipping (pkg:%s targeted_to:%s target_releases:%s)' % (package, targeted_to, target_releases)
            continue
        if pkg == "-" or package == pkg:
            # keep track of these for later
            if targeted_to == None:
                none_list.append(package)
                print 'delaying processing (pkg:%s targeted_to:%s)' % (package, targeted_to)
                continue
            else:
                nominated_list.append(package)

            #print "checking %s,%s: %s %s %s" % (package, targeted_to, task.status, task.importance, task.assignee)
            set_status(task,package,targeted_to,status)
            set_importance(task,package,targeted_to,importance)
            set_assignee(task,package,targeted_to,assignee)
        else:
            print 'skipping package "%s"' % (package)

    # process bugs that don't have a targeted_to and don't have nominations
    for p in none_list:
        if p in nominated_list:
            print 'skipping (pkg:%s has nominations)' % (p)
        else:
            for task in bug.bug_tasks:
                package = None
                targeted_to = None
                target = None
                package, target, targeted_to = get_stuff(task.bug_target_name)
                if (pkg == "-" or pkg == p) and p == package:
                    set_status(task,package,targeted_to,status)
                    set_importance(task,package,targeted_to,importance)
                    set_assignee(task,package,targeted_to,assignee)

