#!/bin/bash
#
# This can be used to add a tag to bug mail you are reading
# usage
#  | b-tag.sh bitesize
# 
# modify PYTHONPATH to your bzr branch of python-launchpad-bugs or remove it
# modify Bug.authentication to the path of your cookie file
TAG=$1
BUG=$(tac | egrep -m 1 "https://(bugs\.launchpad|launchpad.net\/bugs)" | awk -F '/' {'print $5'})
echo "Tagging bug $BUG with $1"
PYTHONPATH=~/source_trees/python-launchpad-bugs/main python - <<- EOF
import launchpadbugs.connector as Connector
import os
Bug=Connector.ConnectBug()
Bug.authentication=os.path.expanduser("~/.mozilla/firefox/h58ouawo.New20060101/cookies.sqlite")
bugnumber=$BUG
bug = Bug(bugnumber)
bug.tags.append("$TAG")
bug.commit(force_changes=True, ignore_lp_errors=False)
EOF
