//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Ashif S. Harji 2005
// 
// OwnerShip.cc -- 
// 
// Author           : Ashif S. Harji
// Created On       : Sun Jan  9 16:09:19 2005
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Aug  6 17:52:24 2005
// Update Count     : 10
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_Cormonitor CM {
    void main() {
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " CM::main enter" << endl;
	uThisTask().yield();
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " CM::main exit" << endl;
    } // CM::main
  public:
    void mem() {
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " CM::mem enter" << endl;
	resume();
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " CM::mem exit" << endl;
    } // CM::mem
}; // CM

_Coroutine C {
    CM &m;
    int i;

    void main() {
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " C::main enter" << endl;
	if ( i == 1 ) m.mem();
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " C::main exit" << endl;
    } // C::main
  public:
    C( CM &m ) : m( m ), i( 0 ) {}

    void mem() {
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " C::mem enter" << endl;
	i += 1;
	resume();
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " C::mem exit" << endl;
    } // C::mem
}; // C

_Task T {
    C &c;

    void main() {
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " T::main enter" << endl;
	c.mem();
	osacquire( cout ) << uThisTask().getName() << " (" << &uThisTask() << ") " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") " << this << " T::main exit" << endl;
    } // T::main
  public:
    T( C &c, const char *name ) : c( c ) {
	setName( name );
    } // T::T
}; // T

void uMain::main() {
    CM m;
    C c( m );
    T t1( c, "T1" ), t2( c, "T2" );
} // uMain::main
