//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1999
// 
// ServerINET2.cc -- Server for INET/datagram socket test. Server reads data
// from multiple clients. The server reads the data from the client and writes
// it back.
// 
// Author           : Peter A. Buhr
// Created On       : Thu Apr 29 16:02:50 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Aug  8 17:10:50 2004
// Update Count     : 23
// 

#include <uC++.h>
#include <uSocket.h>
#include <uIOStream.h>

#define EOD '\377'
#define BufferSize (8 * 1024)

uTask reader {
    uSocketServer &server;

    void main() {
		uDuration timeout( 10, 0 );						// timeout for read
        char buf[BufferSize];
		int len;

		try {
			for ( ;; ) {
				len = server.recvfrom( buf, sizeof(buf), 0, &timeout );
				// uCerr << uAcquire << "Server::reader read len:" << len << endl << uRelease;
				server.sendto( buf, len );				// write byte back to client
			} // for
		} catch( uSocketServer::uReadTimeout ) {
		} // try
    } // reader::main
  public:
    reader( uSocketServer &server ) : server( server ) {
    } // reader::reader
}; // reader

void uMain::main() {
	switch ( argc ) {
	  case 1:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << endl;
		uExit( -1 );
	} // switch

	short unsigned int port;
	uSocketServer server( &port, SOCK_DGRAM );			// create and bind a server socket to free port

	uCout << port << endl;								// print out free port for clients
	{
		reader rd( server );							// execute until EOD
	}
} // uMain

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Server ServerINET2.cc" //
// End: //
