//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Ashif S. Harji 2000
// 
// Disinherit.cc -- 
// 
// Author           : Ashif S. Harji
// Created On       : Mon Feb 14 14:22:08 2000
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Aug 13 08:56:39 2004
// Update Count     : 22
// 


#include <uC++.h>
#include <uIOStream.h>
#include <uIOManip.h>
#include <uDeadlineMonotonicStatic.h>
#include <uStaticPriorityQ.h>
#include <uStaticPIQ.h>


uMutex<uStaticPriorityQ, uStaticPriorityQ> class Monitor2 {
  public:
    void call1( int id, uDuration delay ){
	for (int i = 0; i < 3; i+=1 ){
	    uCout << uAcquire << setw(3) << id << " blocks in monitor 2 for " << delay << " at priority " <<
		uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() << endl << uRelease;
	    
	    uTimeout( delay );
	    
	    uCout << uAcquire << setw(3) << id << " wakes up in monitor 2 " << " at priority " <<
		uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() << endl << uRelease;
	} // for

	uCout << uAcquire << setw(3) << id << " leaves monitor 2 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
    } // call1

    void call2( int id, uDuration delay ) {
	uCout << uAcquire << setw(3) << id << " blocks in monitor 2 for " << delay << " at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() << endl << uRelease;
	
	uTimeout( delay );
	
	uCout << uAcquire << setw(3) << id << " leaves monitor 2 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
    } // call2
}; // Monitor2


uMutex<uStaticPriorityQ, uStaticPriorityQ> class Monitor1 {
  public:
    void call( int id, uDuration delay1, uDuration delay2, Monitor2 &m2 ) {

	uCout << uAcquire << setw(3) << id << " blocks in monitor 1 for " << delay1 << " at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() << endl << uRelease;

	uTimeout(delay1);

	// call Monitor2
	if (id == 1 ) { 
	uCout << uAcquire << setw(3) << id << " calls monitor 2 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
	    m2.call1(id, delay2);
	} else {
	uCout << uAcquire << setw(3) << id << " calls monitor 2 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
	    m2.call2(id, delay2);
	} // if
	    
	uCout << uAcquire << setw(3) << id << " leaves monitor 1 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
    } // call
}; // Monitor1


Monitor1 monitor1;
Monitor2 monitor2;

uMutex<uStaticPriorityQ, uStaticPriorityQ> uPeriodicTask<uStaticPIQ> task1 {
    uDuration D1, D2;
    int id;

    void main() {
	uTimeout(D1);
	uCout << uAcquire << setw(3) << id << " calls monitor 1 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
	monitor1.call( id, D1, D2, monitor2 );
    } // Philosopher::main
  public:
    task1( int id, uDuration period, uDuration delay1, uDuration delay2, uCluster &clust ) :
	    uPeriodicBaseTask( period, uTime(0,0), uThisProcessor().uGetClock().uGetTime() + uDuration(90), period, clust ),
//	    uPeriodicBaseTask( period, uTime(0,0), uTime(0,0), period, clust),
	    D1( delay1 ), D2( delay2 ), id( id ) {
    } // task1::task1
}; // task1


uMutex<uStaticPriorityQ, uStaticPriorityQ> uPeriodicTask<uStaticPIQ> task2 {
    uDuration D1;
    int id;

    void main() {
	uTimeout( D1 );
	uCout << uAcquire << setw(3) << id << " calls monitor 2 at priority " <<
	    uThisTask().uGetActivePriorityValue() << ", " << uThisTask().uGetActiveQueueValue() <<
	    endl << uRelease;
	    monitor2.call2( id, D1 );
    } // Philosopher::main
  public:
    task2( int id, uDuration period, uDuration delay, uCluster &clust ) :
	    uPeriodicBaseTask( period, uTime(0,0), uThisProcessor().uGetClock().uGetTime() + uDuration( 90 ), period, clust ), 
//	    uPeriodicBaseTask( period, uTime(0,0), uTime(0,0), period, clust),
	    D1( delay ), id( id ) {
    } // task2::task2
}; // task2

void uMain::main() {
    uDeadlineMonotonicStatic rq ;				// create real-time scheduler
    uRealTimeCluster RTClust( rq );			// create real-time cluster with scheduler
    uProcessor *p;
    {
	task1 t1( 1, 500, 0, 6, RTClust );
	task1 t2( 2, 400, 5, 0, RTClust );
	task1 t3( 3, 300, 15, 0, RTClust );
	task2 t4( 4, 200, 10, RTClust );

	//uCout << uAcquire << "Time  \t\tPhilosopher" << endl << uRelease;

	p = new uProcessor( RTClust );			// now create the processor to do the work
    }
    delete p;
    uCout << uAcquire << "successful completion" << endl << uRelease;
} // uMain::main

// Local Variables: //
// compile-command: "u++ DisinheritStatic.cc" //
// End: //
