




/* This file was automatically generated from twin_tunnel_c by m4/hw.m4h, do not edit! */


/*
 *  twin_tunnel_m4.c  --  implementation of libTT methods on "twin_tunnel" target display
 *
 *  Copyright (C) 2001,2002 by Massimiliano Ghilardi
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 */


























/*
 *                 WARNING!
 * 
 * this file is twin_tunnel_c and is preprocessed by m4 to produce twin_tunnel_m4.c
 * 
 * It must be a valid m4 file, and must produce a valid C file.
 * 
 */


#include <Tw/Tw.h>
#include <Tw/Twavl.h>
#include <Tw/Twstat.h>
#include <Tw/Twstat_defs.h>
#include <Tw/Twerrno.h>




/* order is crucial here! */

#ifdef CONF_SOCKET_PTHREADS
# include <pthread.h>
#endif

/* include our internal copy of TT.h instead of the public one */
#include "TT.h"
#include <TT/TTerrno.h>

#include "mutex.h"

#include "TTextern.h"
#include "TTassert.h"

#include "utils.h"
#include "inlines.h"
#include "seterrno.h"
#include "theme.h"
#include "common_m4.h"

static s_ttclasses twin_tunnel_TTClasses;



#include "array.h"

static ttobject OverwriteIdFromNative(ttobject o);
static ttany TunnelCall(opaque method_order, ...);

/*
 * We need to write down almost all methods in orded to call them on the server
 */







    
    
    
    
    
    
    
    
    
    
/* ttobject hand-made methods */


static ttobject twin_tunnel_Build_ttobject(ttobject o) {
    /*
     * rough but simple method: we redefine object ->id to be the same
     * as the returned ->native.
     */
    o->native = TunnelCall(ttmethod_New, (ttany)o->Class->id);
    
    return OverwriteIdFromNative(o);
}

static void twin_tunnel_Break_ttobject(ttobject o) {
    TunnelCall(ttmethod_Del, o->native);
}


/* ttnative hand-made methods */

static ttnative twin_tunnel_GetRoot_ttnative(void) {
    /*
     * FIXME: Create_ttnative also calls TNEW()... which creates
     * another ttnative on server side libTT: leak!
     */
    ttnative o = Create_ttnative(TunnelCall(ttmethod_GetRoot_ttnative));

    return (ttnative)OverwriteIdFromNative((ttobject)o);
}


/* ttapplication hand-made methods */

static ttapplication twin_tunnel_Build_ttapplication(ttapplication o) {
    o->native = TunnelCall(ttmethod_Create_ttapplication, (ttany)(opaque)o->name);

    return (ttapplication)OverwriteIdFromNative((ttobject)o);
}





/* autogenerated methods */





 
/* ttclass */
 
/* ttobject */
    
/*
 *   WARNING:   undefined protected tunnel_New_ttobject()
 */
            
/*
 *   WARNING:   undefined protected tunnel_Del_ttobject()
 */
 
/* ttvector */
    
static ttany twin_tunnel_GetAt_ttvector(TT_ARG_READ ttvector o, ttopaque pos) {
    return (ttany)TunnelCall(ttmethod_GetAt_ttvector, (ttany)o, (ttany)pos);
}    
static ttbyte twin_tunnel_SetAt_ttvector(ttvector o, ttopaque pos, ttany value) {
    return (ttbyte)TunnelCall(ttmethod_SetAt_ttvector, (ttany)o, (ttany)pos, (ttany)value);
}    
static ttbyte twin_tunnel_AddY_ttvector(ttvector o, ttopaque pos, ttopaque value_n, TT_ARG_READ TT_ARG_ARRAY((_P(2))) ttany * values) {
    return (ttbyte)TunnelCall(ttmethod_AddY_ttvector, (ttany)o, (ttany)pos, (ttany)value_n, (ttany)values);
}    
static ttopaque twin_tunnel_ContainsValue_ttvector(TT_ARG_READ ttvector o, ttopaque pos_start, ttany value) {
    return (ttopaque)TunnelCall(ttmethod_ContainsValue_ttvector, (ttany)o, (ttany)pos_start, (ttany)value);
}    
static ttbyte twin_tunnel_RemoveRange_ttvector(ttvector o, ttopaque pos_start, ttopaque pos_n) {
    return (ttbyte)TunnelCall(ttmethod_RemoveRange_ttvector, (ttany)o, (ttany)pos_start, (ttany)pos_n);
} 
/* ttfield */
 
/* ttmethod */
 
/* ttevent */
 
/* tteventbig */
 
/* ttbitmask */
 
/* tteventmask */
 
/* ttcallback */
    
/*
 *   WARNING:   undefined protected tunnel_Create_ttcallback()
 */
 
/* ttlistener */
    
static void twin_tunnel_AddTo_ttlistener(ttlistener o, ttcomponent c) {
    TunnelCall(ttmethod_AddTo_ttlistener, (ttany)o, (ttany)c);
}    
static void twin_tunnel_Remove_ttlistener(ttlistener o) {
    TunnelCall(ttmethod_Remove_ttlistener, (ttany)o);
} 
/* tttimer */
    
static void twin_tunnel_SetEnabled_tttimer(tttimer o, ttbyte enabled) {
    TunnelCall(ttmethod_SetEnabled_tttimer, (ttany)o, (ttany)enabled);
}    
static ttbyte twin_tunnel_IsEnabled_tttimer(TT_ARG_READ tttimer o) {
    return (ttbyte)TunnelCall(ttmethod_IsEnabled_tttimer, (ttany)o);
} 
/* ttcomponent */
 
/* ttdata */
    
/*
 *   WARNING:   undefined protected tunnel_AddTo_ttdata()
 */
    
/*
 *   WARNING:   undefined protected tunnel_Remove_ttdata()
 */
 
/* ttvisible */
    
static void twin_tunnel_AddTo_ttvisible(ttvisible o, ttvisible parent, ttany constraint) {
    TunnelCall(ttmethod_AddTo_ttvisible, (ttany)o, (ttany)parent, (ttany)constraint);
}    
static void twin_tunnel_Validate_ttvisible(ttvisible o) {
    TunnelCall(ttmethod_Validate_ttvisible, (ttany)o);
}    
static void twin_tunnel_Remove_ttvisible(ttvisible o) {
    TunnelCall(ttmethod_Remove_ttvisible, (ttany)o);
}    
static void twin_tunnel_Invalidate_ttvisible(ttvisible o) {
    TunnelCall(ttmethod_Invalidate_ttvisible, (ttany)o);
}    
static void twin_tunnel_SetVisible_ttvisible(ttvisible o, ttbyte visible) {
    TunnelCall(ttmethod_SetVisible_ttvisible, (ttany)o, (ttany)visible);
}    
static ttbyte twin_tunnel_SetTheme_ttvisible(ttvisible o, TT_ARG_READ tttheme theme) {
    return (ttbyte)TunnelCall(ttmethod_SetTheme_ttvisible, (ttany)o, (ttany)theme);
}    
static void twin_tunnel_Draw_ttvisible(ttvisible o, ttshort x, ttshort y, ttshort w, ttshort h, ttshort pitch, TT_ARG_READ TT_ARG_ARRAY((_P(5),*,_P(6))) ttbyte * asciidata, TT_ARG_READ TT_ARG_ARRAY((_P(5),*,_P(6))) ttfont * fontdata, TT_ARG_READ TT_ARG_ARRAY((_P(5),*,_P(6))) ttattr * attrdata) {
    TunnelCall(ttmethod_Draw_ttvisible, (ttany)o, (ttany)x, (ttany)y, (ttany)w, (ttany)h, (ttany)pitch, (ttany)(opaque)asciidata, (ttany)(opaque)fontdata, (ttany)(opaque)attrdata);
}    
static void twin_tunnel_BuiltinRepaint_ttvisible(ttvisible o, ttshort x, ttshort y, ttshort w, ttshort h) {
    TunnelCall(ttmethod_BuiltinRepaint_ttvisible, (ttany)o, (ttany)x, (ttany)y, (ttany)w, (ttany)h);
}
 
/* ttlayout */
    
/*
 *   WARNING:   undefined protected tunnel_SetWidget_ttlayout()
 */
    
/*
 *   WARNING:   undefined protected tunnel_DoLayout_ttlayout()
 */
 
/* ttboxlayout */
 
/* ttborderlayout */
 
/* ttnative */
        
static ttshort twin_tunnel_GetW_ttnative(TT_ARG_READ ttnative o) {
    return (ttshort)TunnelCall(ttmethod_GetW_ttnative, (ttany)o);
}    
static ttshort twin_tunnel_GetH_ttnative(TT_ARG_READ ttnative o) {
    return (ttshort)TunnelCall(ttmethod_GetH_ttnative, (ttany)o);
} 
/* ttwidget */
    
static void twin_tunnel_SetLayout_ttwidget(ttwidget o, ttlayout l) {
    TunnelCall(ttmethod_SetLayout_ttwidget, (ttany)o, (ttany)l);
}    
static ttbyte twin_tunnel_SetXY_ttwidget(ttwidget o, ttshort x, ttshort y) {
    return (ttbyte)TunnelCall(ttmethod_SetXY_ttwidget, (ttany)o, (ttany)x, (ttany)y);
}    
static ttbyte twin_tunnel_SetWH_ttwidget(ttwidget o, ttshort w, ttshort h) {
    return (ttbyte)TunnelCall(ttmethod_SetWH_ttwidget, (ttany)o, (ttany)w, (ttany)h);
}    
static ttbyte twin_tunnel_SetXl_ttwidget(ttwidget o, ttint xl) {
    return (ttbyte)TunnelCall(ttmethod_SetXl_ttwidget, (ttany)o, (ttany)xl);
}    
static ttbyte twin_tunnel_SetYl_ttwidget(ttwidget o, ttint yl) {
    return (ttbyte)TunnelCall(ttmethod_SetYl_ttwidget, (ttany)o, (ttany)yl);
}    
static ttbyte twin_tunnel_SetWl_ttwidget(ttwidget o, ttint wl) {
    return (ttbyte)TunnelCall(ttmethod_SetWl_ttwidget, (ttany)o, (ttany)wl);
}    
static ttbyte twin_tunnel_SetHl_ttwidget(ttwidget o, ttint hl) {
    return (ttbyte)TunnelCall(ttmethod_SetHl_ttwidget, (ttany)o, (ttany)hl);
}    
static ttbyte twin_tunnel_SetTooltip_ttwidget(ttwidget o, TT_ARG_DIE tttooltip t) {
    return (ttbyte)TunnelCall(ttmethod_SetTooltip_ttwidget, (ttany)o, (ttany)t);
} 
/* ttlabel */
    
static void twin_tunnel_SetFontD_ttlabel(ttlabel o, ttopaque text_len, TT_ARG_DIE TT_ARG_ARRAY((_P(2))) ttfont * text) {
    TunnelCall(ttmethod_SetFontD_ttlabel, (ttany)o, (ttany)text_len, (ttany)text);
} 
/* tttooltip */
    
static ttbyte twin_tunnel_SetWidget_tttooltip(TT_ARG_DIE tttooltip o, ttwidget w) {
    return (ttbyte)TunnelCall(ttmethod_SetWidget_tttooltip, (ttany)o, (ttany)w);
} 
/* ttbuttongroup */
    
static void twin_tunnel_Add_ttbuttongroup(ttbuttongroup o, ttradiobutton r) {
    TunnelCall(ttmethod_Add_ttbuttongroup, (ttany)o, (ttany)r);
}    
static void twin_tunnel_Remove_ttbuttongroup(ttbuttongroup o, ttradiobutton r) {
    TunnelCall(ttmethod_Remove_ttbuttongroup, (ttany)o, (ttany)r);
}    
static void twin_tunnel_SetChecked_ttbuttongroup(ttbuttongroup o, ttradiobutton r) {
    TunnelCall(ttmethod_SetChecked_ttbuttongroup, (ttany)o, (ttany)r);
} 
/* ttanybutton */
    
/*
 *   WARNING:   undefined protected tunnel_CacheThemeShape_ttanybutton()
 */
    
static void twin_tunnel_SetAttrD_ttanybutton(ttanybutton o, ttshort w, ttshort h, ttshort pitch, TT_ARG_DIE TT_ARG_ARRAY((_P(3),*,_P(4))) ttattr * text) {
    TunnelCall(ttmethod_SetAttrD_ttanybutton, (ttany)o, (ttany)w, (ttany)h, (ttany)pitch, (ttany)(opaque)text);
} 
/* ttbutton */
    
static void twin_tunnel_SetPressed_ttbutton(ttbutton o, ttbyte pressed) {
    TunnelCall(ttmethod_SetPressed_ttbutton, (ttany)o, (ttany)pressed);
} 
/* ttcheckbutton */
    
static void twin_tunnel_SetChecked_ttcheckbutton(ttcheckbutton o, ttbyte checked) {
    TunnelCall(ttmethod_SetChecked_ttcheckbutton, (ttany)o, (ttany)checked);
} 
/* ttradiobutton */
 
/* ttanyscroll */
    
/*
 *   WARNING:   undefined protected tunnel_Recalculate_ttanyscroll()
 */
    
/*
 *   WARNING:   undefined protected tunnel_SetState_ttanyscroll()
 */
    
static ttbyte twin_tunnel_SetOrientation_ttanyscroll(ttanyscroll o, ttbyte orientation) {
    return (ttbyte)TunnelCall(ttmethod_SetOrientation_ttanyscroll, (ttany)o, (ttany)orientation);
}    
static ttbyte twin_tunnel_SetSize_ttanyscroll(ttanyscroll o, ttint size) {
    return (ttbyte)TunnelCall(ttmethod_SetSize_ttanyscroll, (ttany)o, (ttany)size);
}    
static ttbyte twin_tunnel_SetRealSize_ttanyscroll(ttanyscroll o, ttint real_size) {
    return (ttbyte)TunnelCall(ttmethod_SetRealSize_ttanyscroll, (ttany)o, (ttany)real_size);
}    
static ttbyte twin_tunnel_SetViewSize_ttanyscroll(ttanyscroll o, ttint view_size) {
    return (ttbyte)TunnelCall(ttmethod_SetViewSize_ttanyscroll, (ttany)o, (ttany)view_size);
}    
static ttbyte twin_tunnel_SetPosition_ttanyscroll(ttanyscroll o, ttint position) {
    return (ttbyte)TunnelCall(ttmethod_SetPosition_ttanyscroll, (ttany)o, (ttany)position);
} 
/* ttscrollbar */
 
/* ttslider */
    
static ttbyte twin_tunnel_SetSlideMin_ttslider(ttslider o, ttint slide_min) {
    return (ttbyte)TunnelCall(ttmethod_SetSlideMin_ttslider, (ttany)o, (ttany)slide_min);
}    
static ttbyte twin_tunnel_SetSlideMax_ttslider(ttslider o, ttint slide_max) {
    return (ttbyte)TunnelCall(ttmethod_SetSlideMax_ttslider, (ttany)o, (ttany)slide_max);
}    
static ttbyte twin_tunnel_SetSlideValue_ttslider(ttslider o, ttint slide_value) {
    return (ttbyte)TunnelCall(ttmethod_SetSlideValue_ttslider, (ttany)o, (ttany)slide_value);
} 
/* ttprogressbar */
 
/* ttscrollpane */
    
static ttbyte twin_tunnel_SetBarX_ttscrollpane(ttscrollpane o, ttscrollbar bar_x) {
    return (ttbyte)TunnelCall(ttmethod_SetBarX_ttscrollpane, (ttany)o, (ttany)bar_x);
}    
static ttbyte twin_tunnel_SetBarY_ttscrollpane(ttscrollpane o, ttscrollbar bar_y) {
    return (ttbyte)TunnelCall(ttmethod_SetBarY_ttscrollpane, (ttany)o, (ttany)bar_y);
} 
/* ttwindow */
    
static ttbyte twin_tunnel_SetTitle_ttwindow(ttwindow o, TT_ARG_READ TT_ARG_ARRAY_Z ttbyte * title) {
    return (ttbyte)TunnelCall(ttmethod_SetTitle_ttwindow, (ttany)o, (ttany)title);
} 
/* ttframe */
    
static ttbyte twin_tunnel_SetMenubar_ttframe(ttframe o, TT_ARG_READ ttmenubar m) {
    return (ttbyte)TunnelCall(ttmethod_SetMenubar_ttframe, (ttany)o, (ttany)m);
} 
/* ttscroller */
 
/* ttmenuitem */
 
/* ttcheckmenuitem */
 
/* ttradiomenuitem */
 
/* ttmenu */
 
/* ttmenubar */
 
/* ttanytext */
 
/* tttextfield */
 
/* tttextarea */
 
/* tttheme */
 
/* ttapplication */











static ttbyte twin_tunnel_Sync(void) {
    return TwSync();
}
static ttbyte twin_tunnel_Flush(void) {
    return TwFlush();
}
static ttbyte twin_tunnel_TimidFlush(void) {
    return TwTimidFlush();
}
static ttbyte twin_tunnel_MainLoopOnce(ttbyte wait) {
    tmsg Msg;
    
    /* loop until all already queued messages are dispatched */
    do {
        if ((Msg = TwCloneReadMsg(wait))) {
	    TwDispatchMsg(Msg);
	    TwFreeMem(Msg);
	}
    } while (TwPendingMsg());
    
    return !TwInPanic();
}
static void twin_tunnel_DeleteCallback(ttcallback o) {
    if (o->native != (opaque)TW_NOID)
	TwDeleteListener((tlistener)(opaque)o->native);
}
static void twin_tunnel_Close(void) {
    TwClose();
}
static int twin_tunnel_ConnectionFd(void) {
    return TwConnectionFd();
}
static ttuint twin_tunnel_GetErrno(void) {
    return TwErrno;
}
static ttuint twin_tunnel_GetErrnoDetail(void) {
    return TwErrnoDetail;
}
static TT_CONST ttbyte *twin_tunnel_StrError(ttuint E) {
    return TwStrError(E);
}
static TT_CONST ttbyte *twin_tunnel_StrErrorDetail(ttuint E, ttuint S) {
    return TwStrErrorDetail(E,S);
}

	



static textension eid = TW_NOID;

TW_DECL_MAGIC(TT_Tw_magic);


#ifdef THIS_MODULE
ttclasses InitModule(tthw *HW)
#else
ttclasses _TT_twin_tunnel_InitHW(tthw *HW)
#endif
{
    ttuint tunnel_libTT_version;
    /*
     * (*HW) must be set even if initialization fails,
     * to report error messages.
     */
    *HW = &twin_tunnel_TTClasses.HW;
    
    TwConfigMalloc(TTAllocMem, TTReallocMem, TTFreeMem);
    
    if (TwCheckMagic(TT_Tw_magic) && TwOpen(TTD.HWOptions)) {
	if ((eid = TwOpenExtension(2, "TT"))) {
	    if ((tunnel_libTT_version = TunnelCall(ttmethod_LibraryVersion)) == TT_PROTOCOL_VERSION)
		return &twin_tunnel_TTClasses;
	    else
		FAIL_TT(TT_ETARGET_BAD_EXTENSION_VERSION, tunnel_libTT_version);
	} else {
	    FAIL_TT(TT_ETARGET_NO_EXTENSION, TT_EDETAIL_TARGET_TWIN_TUNNEL);
	}
	TwClose();
    }
    
    if (TwErrno)
	FAIL(TwErrno, TwErrnoDetail);
    
    return (ttclasses)0;
}


static udat TTType2TWS(ttopaque type) {
    udat tws_type = 0;
    
    if (type & ttclass_type_array)
	tws_type |= TWS_vec|TWS_vecW;

    switch ((opaque)TTFromType_ttclass(type) & TT_MAGIC_MASK) {
#define C(t1,t2) case TT_CAT(order_,t1): tws_type |= TT_CAT(TWS_,t2); break;
	C(void,     void);
	C(ttbyte,   byte);
	C(ttshort,  dat);
	C(ttint,    ldat);
	C(ttcol,    hwcol);
	C(ttfont,   hwfont);
	C(ttattr,   hwattr);
	C(ttopaque, topaque);
	C(ttany,    tany);
#undef C
      default:
	tws_type |= TWS_tany;
    }
    return tws_type;
}

/*
 * rough but simple method: we redefine object ->id to be the same
 * as the returned ->native.
 */
static ttobject OverwriteIdFromNative(ttobject o) {
    ttopaque saved_id;
    
    /* fast-failure or fast-success */
    if (!o || o->native == o->id)
	return o;
    
    /* sanity checks */
    if (o->native && o->native == (ttopaque)o->native && 
	(o->native >> TT_MAGIC_SHIFT) == (o->id >> TT_MAGIC_SHIFT) &&
	!ID2OBJ(o->native)) {
	
	saved_id = o->id;
	DropId((ttobj)o);
	o->id = (ttopaque)o->native;
	if (FixedAssignId((ttclass)o->Class, (ttobj)o))
	    return o;
	
	/* try to recover... */
	o->id = saved_id;
	(void)FixedAssignId((ttclass)o->Class, (ttobj)o);
    }
    return NULL;
}

#ifdef DEBUG_TUNNEL
static void debug_method(ttopaque args_n, tsfield a) {
    ttopaque i;
    
    printf("%s(", TTGetName_ttmethod((tt_obj)(ttopaque)a[1].TWS_field_scalar));

    for (i = 2; i <= args_n + 1; i++) {
	if (i == args_n + 1) {
	    i = 0;
	    printf(") =\t ");
	} else if (i != 2) {
	    printf(", ");
	}
	
	if (a[i].type == (TWS_vec|TWS_vecW|TWS_byte))
	    printf("\"%.*s\"", (int)a[i].TWS_field_vecL, (TW_CONST byte *)a[i].TWS_field_vecV);
	else if (a[i].type & TWS_vec)
	    printf("0x%08lX[%ld]", (unsigned long)a[i].TWS_field_vecV, (unsigned long)a[i].TWS_field_vecL);
	else if (a[i].type == TWS_void)
	    printf("<void>");
	else if (a[i].TWS_field_scalar > 0xFFFF)
	    printf("0x%08lX", (unsigned long)a[i].TWS_field_scalar);
	else
	    printf("%ld", (unsigned long)a[i].TWS_field_scalar);
	
	if (i == 0)
	    break;
    }
    printf("\n");
    fflush(stdout);
}
#endif

static ttany TunnelCall(opaque o, ...) {
    struct s_tsfield ta[TT_MAX_ARG_N];
    ttarg aa[TT_MAX_ARG_N];
    
    tsfield a;
    va_list vargs;
    ttmethod M;
    ttopaque type, i, args_n;
    ttany *args_type;
    tany val;
    ttobject O;
    tt_obj _Class;
    ttclass Class;
    
    /*
     * FIXME: if we work on a user-created ttobject it's ok,
     * else we should work on our local copy, NOT call the server-side libTT
     */
    
    if (!(M = (ttmethod)IdList[order_ttmethod][o]))
	return (ttany)0;
	
    args_n = M->parameter_type->array_n;
    args_type = M->parameter_type->array;
    if (args_n >= TT_MAX_ARG_N - 2)
	return (ttany)0;

    /* set type of return value */
    ta[0].type = TTType2TWS(M->return_type);

    /* set first arg (method) */
    ta[1].type = TWS_tany;
    ta[1].TWS_field_scalar = o | (order_ttmethod << TT_MAGIC_SHIFT);
    
    va_start(vargs, o);
    
    /* skip a[0] (return value) */
    /* skip a[1] (method, already encoded above) */
    for (a = ta+2, i = 0; i < args_n; i++) {

	
	a[i].type = TTType2TWS(	aa[i].type = type = *args_type );

	val = va_arg(vargs, tany);

	_Class = TTFromType_ttclass(type);
	
	if (type == id_ttclass_void) {
	    ;
	} else if (type & ttclass_type_array) {
	    
	    a[i].TWS_field_vecV = (void *)(opaque)( aa[i].value = val );
	    a[i].TWS_field_vecL = aa[i].size =
		TTGetArraySizeA_ttmethod((tt_obj)M->id, i, args_n, aa);
	    
	} else {
	    if ((Class = ID2CLASS(_Class)) && ISCLASS(ttobj, Class) && /* we are sending a libTT obj */
		(O = (ttobject)(opaque)val) && Is(Class, O)) { /* and it is a valid obj of the correct type */
		
		if (IS(ttobject,O) &&
		    !(O->oflags & (ttobject_oflags_static|ttobject_oflags_const)))
		    /* it is a user-created ttobject */
		    
		    val = O->native;
		else
		    /* it is a library immutable object */
		    val = O->id;
		
	    }
	    aa[i].value = a[i].TWS_field_scalar = val;
	    break;
	}
    }
    va_end(vargs);
    
#ifdef DEBUG_TUNNEL
    TwCallTExtension(eid, args_n+1, ta);
    
    debug_method(args_n+1, ta);
    return a->TWS_field_scalar;
#else
    
    /* FIXME: if the return value is an object of server-side libTT,
     * we must must find our object having ->native equal to the return value */
    
    /* (args_n+1) since we prepended method to invoke (o) as first arg */
    return (ttany)TwCallTExtension(eid, args_n+1, a);
#endif
}






/*
 * use default values for methods not implemented in twin_tunnel_c
 *
 * null display target MUST IMPLEMENT ALL METHODS, even if as stubs.
 */











static s_ttclasses twin_tunnel_TTClasses = {

 
  {
    Class_ttobj,
    id_ttobj,
    magicmask_ttobj,
    magic_ttobj,
    size_ttobj,

  },
 
  {
    Class_ttclass,
    id_ttclass,
    magicmask_ttclass,
    magic_ttclass,
    size_ttclass,

    /* extends ttclass_ttobj */

  },
 
  {
    Class_ttobject,
    id_ttobject,
    magicmask_ttobject,
    magic_ttobject,
    size_ttobject,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttobject */,
    twin_tunnel_Build_ttobject,
    twin_tunnel_Break_ttobject,
    (void *)NULL /* UNDEFINED: Del_ttobject */,

  },
 
  {
    Class_ttvector,
    id_ttvector,
    magicmask_ttvector,
    magic_ttvector,
    size_ttvector,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttvector */,
    (void *)NULL /* inherits:  Build_ttvector >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttvector >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttvector */,

    /* extends ttclass_ttobject */
    twin_tunnel_GetAt_ttvector,
    twin_tunnel_SetAt_ttvector,
    twin_tunnel_AddY_ttvector,
    twin_tunnel_ContainsValue_ttvector,
    twin_tunnel_RemoveRange_ttvector,

  },
 
  {
    Class_ttfield,
    id_ttfield,
    magicmask_ttfield,
    magic_ttfield,
    size_ttfield,

    /* extends ttclass_ttobj */

  },
 
  {
    Class_ttmethod,
    id_ttmethod,
    magicmask_ttmethod,
    magic_ttmethod,
    size_ttmethod,

    /* extends ttclass_ttobj */

  },
 
  {
    Class_ttevent,
    id_ttevent,
    magicmask_ttevent,
    magic_ttevent,
    size_ttevent,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttevent */,
    (void *)NULL /* inherits:  Build_ttevent >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttevent >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttevent */,

    /* extends ttclass_ttobject */

  },
 
  {
    Class_tteventbig,
    id_tteventbig,
    magicmask_tteventbig,
    magic_tteventbig,
    size_tteventbig,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tteventbig */,
    (void *)NULL /* inherits:  Build_tteventbig >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tteventbig >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tteventbig */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttevent */

  },
 
  {
    Class_ttbitmask,
    id_ttbitmask,
    magicmask_ttbitmask,
    magic_ttbitmask,
    size_ttbitmask,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttbitmask */,
    (void *)NULL /* inherits:  Build_ttbitmask >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttbitmask >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttbitmask */,

    /* extends ttclass_ttobject */

  },
 
  {
    Class_tteventmask,
    id_tteventmask,
    magicmask_tteventmask,
    magic_tteventmask,
    size_tteventmask,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tteventmask */,
    (void *)NULL /* inherits:  Build_tteventmask >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tteventmask >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tteventmask */,

    /* extends ttclass_ttobject */

  },
 
  {
    Class_ttcallback,
    id_ttcallback,
    magicmask_ttcallback,
    magic_ttcallback,
    size_ttcallback,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttcallback */,
    (void *)NULL /* inherits:  Build_ttcallback >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttcallback >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttcallback */,

    /* extends ttclass_ttobject */
    (void *)NULL /* UNDEFINED: Create_ttcallback */,

  },
 
  {
    Class_ttlistener,
    id_ttlistener,
    magicmask_ttlistener,
    magic_ttlistener,
    size_ttlistener,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttlistener */,
    (void *)NULL /* inherits:  Build_ttlistener >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttlistener >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttlistener */,

    /* extends ttclass_ttobject */
    (void *)NULL /* UNDEFINED: Create_ttlistener */,

    /* extends ttclass_ttcallback */
    twin_tunnel_AddTo_ttlistener,
    twin_tunnel_Remove_ttlistener,

  },
 
  {
    Class_tttimer,
    id_tttimer,
    magicmask_tttimer,
    magic_tttimer,
    size_tttimer,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tttimer */,
    (void *)NULL /* inherits:  Build_tttimer >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tttimer >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tttimer */,

    /* extends ttclass_ttobject */
    (void *)NULL /* UNDEFINED: Create_tttimer */,

    /* extends ttclass_ttcallback */
    (void *)NULL /* inherits:  AddTo_tttimer >> AddTo_ttlistener */,
    (void *)NULL /* inherits:  Remove_tttimer >> Remove_ttlistener */,

    /* extends ttclass_ttlistener */
    twin_tunnel_SetEnabled_tttimer,
    twin_tunnel_IsEnabled_tttimer,

  },
 
  {
    Class_ttcomponent,
    id_ttcomponent,
    magicmask_ttcomponent,
    magic_ttcomponent,
    size_ttcomponent,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttcomponent */,
    (void *)NULL /* inherits:  Build_ttcomponent >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttcomponent >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttcomponent */,

    /* extends ttclass_ttobject */

  },
 
  {
    Class_ttdata,
    id_ttdata,
    magicmask_ttdata,
    magic_ttdata,
    size_ttdata,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttdata */,
    (void *)NULL /* inherits:  Build_ttdata >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttdata >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttdata */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* UNDEFINED: AddTo_ttdata */,
    (void *)NULL /* UNDEFINED: Remove_ttdata */,

  },
 
  {
    Class_ttvisible,
    id_ttvisible,
    magicmask_ttvisible,
    magic_ttvisible,
    size_ttvisible,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttvisible */,
    (void *)NULL /* inherits:  Build_ttvisible >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttvisible >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttvisible */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    twin_tunnel_AddTo_ttvisible,
    twin_tunnel_Validate_ttvisible,
    twin_tunnel_Remove_ttvisible,
    twin_tunnel_Invalidate_ttvisible,
    twin_tunnel_SetVisible_ttvisible,
    twin_tunnel_SetTheme_ttvisible,
    twin_tunnel_Draw_ttvisible,
    twin_tunnel_BuiltinRepaint_ttvisible,


  },
 
  {
    Class_ttlayout,
    id_ttlayout,
    magicmask_ttlayout,
    magic_ttlayout,
    size_ttlayout,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttlayout */,
    (void *)NULL /* inherits:  Build_ttlayout >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttlayout >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttlayout */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* UNDEFINED: SetWidget_ttlayout */,
    (void *)NULL /* UNDEFINED: DoLayout_ttlayout */,

  },
 
  {
    Class_ttboxlayout,
    id_ttboxlayout,
    magicmask_ttboxlayout,
    magic_ttboxlayout,
    size_ttboxlayout,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttboxlayout */,
    (void *)NULL /* inherits:  Build_ttboxlayout >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttboxlayout >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttboxlayout */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* UNDEFINED: SetWidget_ttboxlayout */,
    (void *)NULL /* UNDEFINED: DoLayout_ttboxlayout */,

    /* extends ttclass_ttlayout */

  },
 
  {
    Class_ttborderlayout,
    id_ttborderlayout,
    magicmask_ttborderlayout,
    magic_ttborderlayout,
    size_ttborderlayout,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttborderlayout */,
    (void *)NULL /* inherits:  Build_ttborderlayout >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttborderlayout >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttborderlayout */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* UNDEFINED: SetWidget_ttborderlayout */,
    (void *)NULL /* UNDEFINED: DoLayout_ttborderlayout */,

    /* extends ttclass_ttlayout */

  },
 
  {
    Class_ttnative,
    id_ttnative,
    magicmask_ttnative,
    magic_ttnative,
    size_ttnative,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttnative */,
    (void *)NULL /* inherits:  Build_ttnative >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttnative >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttnative */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttnative >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttnative >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttnative >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttnative >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttnative >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttnative >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttnative >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttnative >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    twin_tunnel_GetRoot_ttnative,
    twin_tunnel_GetW_ttnative,
    twin_tunnel_GetH_ttnative,

  },
 
  {
    Class_ttwidget,
    id_ttwidget,
    magicmask_ttwidget,
    magic_ttwidget,
    size_ttwidget,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttwidget */,
    (void *)NULL /* inherits:  Build_ttwidget >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttwidget >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttwidget */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttwidget >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttwidget >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttwidget >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttwidget >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttwidget >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttwidget >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttwidget >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttwidget >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    twin_tunnel_SetLayout_ttwidget,
    twin_tunnel_SetXY_ttwidget,
    twin_tunnel_SetWH_ttwidget,
    twin_tunnel_SetXl_ttwidget,
    twin_tunnel_SetYl_ttwidget,
    twin_tunnel_SetWl_ttwidget,
    twin_tunnel_SetHl_ttwidget,
    twin_tunnel_SetTooltip_ttwidget,

  },
 
  {
    Class_ttlabel,
    id_ttlabel,
    magicmask_ttlabel,
    magic_ttlabel,
    size_ttlabel,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttlabel */,
    (void *)NULL /* inherits:  Build_ttlabel >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttlabel >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttlabel */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttlabel >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttlabel >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttlabel >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttlabel >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttlabel >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttlabel >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttlabel >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttlabel >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttlabel >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttlabel >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttlabel >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttlabel >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttlabel >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttlabel >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttlabel >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttlabel >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    twin_tunnel_SetFontD_ttlabel,

  },
 
  {
    Class_tttooltip,
    id_tttooltip,
    magicmask_tttooltip,
    magic_tttooltip,
    size_tttooltip,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tttooltip */,
    (void *)NULL /* inherits:  Build_tttooltip >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tttooltip >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tttooltip */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_tttooltip >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_tttooltip >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_tttooltip >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_tttooltip >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_tttooltip >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_tttooltip >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_tttooltip >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_tttooltip >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_tttooltip >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_tttooltip >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_tttooltip >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_tttooltip >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_tttooltip >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_tttooltip >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_tttooltip >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_tttooltip >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* inherits:  SetFontD_tttooltip >> SetFontD_ttlabel */,

    /* extends ttclass_ttlabel */
    twin_tunnel_SetWidget_tttooltip,

  },
 
  {
    Class_ttbuttongroup,
    id_ttbuttongroup,
    magicmask_ttbuttongroup,
    magic_ttbuttongroup,
    size_ttbuttongroup,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttbuttongroup */,
    (void *)NULL /* inherits:  Build_ttbuttongroup >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttbuttongroup >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttbuttongroup */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    twin_tunnel_Add_ttbuttongroup,
    twin_tunnel_Remove_ttbuttongroup,
    twin_tunnel_SetChecked_ttbuttongroup,

  },
 
  {
    Class_ttanybutton,
    id_ttanybutton,
    magicmask_ttanybutton,
    magic_ttanybutton,
    size_ttanybutton,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttanybutton */,
    (void *)NULL /* inherits:  Build_ttanybutton >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttanybutton >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttanybutton */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttanybutton >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttanybutton >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttanybutton >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttanybutton >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttanybutton >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttanybutton >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttanybutton >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttanybutton >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttanybutton >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttanybutton >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttanybutton >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttanybutton >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttanybutton >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttanybutton >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttanybutton >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttanybutton >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttanybutton */,
    twin_tunnel_SetAttrD_ttanybutton,

  },
 
  {
    Class_ttbutton,
    id_ttbutton,
    magicmask_ttbutton,
    magic_ttbutton,
    size_ttbutton,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttbutton */,
    (void *)NULL /* inherits:  Build_ttbutton >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttbutton >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttbutton */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttbutton >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttbutton >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttbutton >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttbutton >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttbutton >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttbutton >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttbutton >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttbutton >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttbutton >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttbutton >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttbutton >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttbutton >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttbutton >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttbutton >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttbutton >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttbutton >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttbutton */,
    (void *)NULL /* inherits:  SetAttrD_ttbutton >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    twin_tunnel_SetPressed_ttbutton,

  },
 
  {
    Class_ttcheckbutton,
    id_ttcheckbutton,
    magicmask_ttcheckbutton,
    magic_ttcheckbutton,
    size_ttcheckbutton,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttcheckbutton */,
    (void *)NULL /* inherits:  Build_ttcheckbutton >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttcheckbutton >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttcheckbutton */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttcheckbutton >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttcheckbutton >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttcheckbutton >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttcheckbutton >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttcheckbutton >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttcheckbutton >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttcheckbutton >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttcheckbutton >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttcheckbutton >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttcheckbutton >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttcheckbutton >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttcheckbutton >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttcheckbutton >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttcheckbutton >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttcheckbutton >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttcheckbutton >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttcheckbutton */,
    (void *)NULL /* inherits:  SetAttrD_ttcheckbutton >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    (void *)NULL /* inherits:  SetPressed_ttcheckbutton >> SetPressed_ttbutton */,

    /* extends ttclass_ttbutton */
    twin_tunnel_SetChecked_ttcheckbutton,

  },
 
  {
    Class_ttradiobutton,
    id_ttradiobutton,
    magicmask_ttradiobutton,
    magic_ttradiobutton,
    size_ttradiobutton,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttradiobutton */,
    (void *)NULL /* inherits:  Build_ttradiobutton >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttradiobutton >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttradiobutton */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttradiobutton >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttradiobutton >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttradiobutton >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttradiobutton >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttradiobutton >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttradiobutton >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttradiobutton >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttradiobutton >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttradiobutton >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttradiobutton >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttradiobutton >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttradiobutton >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttradiobutton >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttradiobutton >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttradiobutton >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttradiobutton >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttradiobutton */,
    (void *)NULL /* inherits:  SetAttrD_ttradiobutton >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    (void *)NULL /* inherits:  SetPressed_ttradiobutton >> SetPressed_ttbutton */,

    /* extends ttclass_ttbutton */
    (void *)NULL /* inherits:  SetChecked_ttradiobutton >> SetChecked_ttcheckbutton */,

    /* extends ttclass_ttcheckbutton */

  },
 
  {
    Class_ttanyscroll,
    id_ttanyscroll,
    magicmask_ttanyscroll,
    magic_ttanyscroll,
    size_ttanyscroll,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttanyscroll */,
    (void *)NULL /* inherits:  Build_ttanyscroll >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttanyscroll >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttanyscroll */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttanyscroll >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttanyscroll >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttanyscroll >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttanyscroll >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttanyscroll >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttanyscroll >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttanyscroll >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttanyscroll >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttanyscroll >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttanyscroll >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttanyscroll >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttanyscroll >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttanyscroll >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttanyscroll >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttanyscroll >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttanyscroll >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttanyscroll */,
    (void *)NULL /* inherits:  SetAttrD_ttanyscroll >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    (void *)NULL /* UNDEFINED: Recalculate_ttanyscroll */,
    (void *)NULL /* UNDEFINED: SetState_ttanyscroll */,
    twin_tunnel_SetOrientation_ttanyscroll,
    twin_tunnel_SetSize_ttanyscroll,
    twin_tunnel_SetRealSize_ttanyscroll,
    twin_tunnel_SetViewSize_ttanyscroll,
    twin_tunnel_SetPosition_ttanyscroll,

  },
 
  {
    Class_ttscrollbar,
    id_ttscrollbar,
    magicmask_ttscrollbar,
    magic_ttscrollbar,
    size_ttscrollbar,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttscrollbar */,
    (void *)NULL /* inherits:  Build_ttscrollbar >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttscrollbar >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttscrollbar */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttscrollbar >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttscrollbar >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttscrollbar >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttscrollbar >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttscrollbar >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttscrollbar >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttscrollbar >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttscrollbar >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttscrollbar >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttscrollbar >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttscrollbar >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttscrollbar >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttscrollbar >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttscrollbar >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttscrollbar >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttscrollbar >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttscrollbar */,
    (void *)NULL /* inherits:  SetAttrD_ttscrollbar >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    (void *)NULL /* UNDEFINED: Recalculate_ttscrollbar */,
    (void *)NULL /* UNDEFINED: SetState_ttscrollbar */,
    (void *)NULL /* inherits:  SetOrientation_ttscrollbar >> SetOrientation_ttanyscroll */,
    (void *)NULL /* inherits:  SetSize_ttscrollbar >> SetSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetRealSize_ttscrollbar >> SetRealSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetViewSize_ttscrollbar >> SetViewSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetPosition_ttscrollbar >> SetPosition_ttanyscroll */,

    /* extends ttclass_ttanyscroll */

  },
 
  {
    Class_ttslider,
    id_ttslider,
    magicmask_ttslider,
    magic_ttslider,
    size_ttslider,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttslider */,
    (void *)NULL /* inherits:  Build_ttslider >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttslider >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttslider */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttslider >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttslider >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttslider >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttslider >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttslider >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttslider >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttslider >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttslider >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttslider >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttslider >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttslider >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttslider >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttslider >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttslider >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttslider >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttslider >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttslider */,
    (void *)NULL /* inherits:  SetAttrD_ttslider >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    (void *)NULL /* UNDEFINED: Recalculate_ttslider */,
    (void *)NULL /* UNDEFINED: SetState_ttslider */,
    (void *)NULL /* inherits:  SetOrientation_ttslider >> SetOrientation_ttanyscroll */,
    (void *)NULL /* inherits:  SetSize_ttslider >> SetSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetRealSize_ttslider >> SetRealSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetViewSize_ttslider >> SetViewSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetPosition_ttslider >> SetPosition_ttanyscroll */,

    /* extends ttclass_ttanyscroll */
    twin_tunnel_SetSlideMin_ttslider,
    twin_tunnel_SetSlideMax_ttslider,
    twin_tunnel_SetSlideValue_ttslider,

  },
 
  {
    Class_ttprogressbar,
    id_ttprogressbar,
    magicmask_ttprogressbar,
    magic_ttprogressbar,
    size_ttprogressbar,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttprogressbar */,
    (void *)NULL /* inherits:  Build_ttprogressbar >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttprogressbar >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttprogressbar */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttprogressbar >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttprogressbar >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttprogressbar >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttprogressbar >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttprogressbar >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttprogressbar >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttprogressbar >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttprogressbar >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttprogressbar >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttprogressbar >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttprogressbar >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttprogressbar >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttprogressbar >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttprogressbar >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttprogressbar >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttprogressbar >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* UNDEFINED: CacheThemeShape_ttprogressbar */,
    (void *)NULL /* inherits:  SetAttrD_ttprogressbar >> SetAttrD_ttanybutton */,

    /* extends ttclass_ttanybutton */
    (void *)NULL /* UNDEFINED: Recalculate_ttprogressbar */,
    (void *)NULL /* UNDEFINED: SetState_ttprogressbar */,
    (void *)NULL /* inherits:  SetOrientation_ttprogressbar >> SetOrientation_ttanyscroll */,
    (void *)NULL /* inherits:  SetSize_ttprogressbar >> SetSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetRealSize_ttprogressbar >> SetRealSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetViewSize_ttprogressbar >> SetViewSize_ttanyscroll */,
    (void *)NULL /* inherits:  SetPosition_ttprogressbar >> SetPosition_ttanyscroll */,

    /* extends ttclass_ttanyscroll */

  },
 
  {
    Class_ttscrollpane,
    id_ttscrollpane,
    magicmask_ttscrollpane,
    magic_ttscrollpane,
    size_ttscrollpane,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttscrollpane */,
    (void *)NULL /* inherits:  Build_ttscrollpane >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttscrollpane >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttscrollpane */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttscrollpane >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttscrollpane >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttscrollpane >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttscrollpane >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttscrollpane >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttscrollpane >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttscrollpane >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttscrollpane >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttscrollpane >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttscrollpane >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttscrollpane >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttscrollpane >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttscrollpane >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttscrollpane >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttscrollpane >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttscrollpane >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    twin_tunnel_SetBarX_ttscrollpane,
    twin_tunnel_SetBarY_ttscrollpane,

  },
 
  {
    Class_ttwindow,
    id_ttwindow,
    magicmask_ttwindow,
    magic_ttwindow,
    size_ttwindow,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttwindow */,
    (void *)NULL /* inherits:  Build_ttwindow >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttwindow >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttwindow */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttwindow >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttwindow >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttwindow >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttwindow >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttwindow >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttwindow >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttwindow >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttwindow >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttwindow >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttwindow >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttwindow >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttwindow >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttwindow >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttwindow >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttwindow >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttwindow >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    twin_tunnel_SetTitle_ttwindow,

  },
 
  {
    Class_ttframe,
    id_ttframe,
    magicmask_ttframe,
    magic_ttframe,
    size_ttframe,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttframe */,
    (void *)NULL /* inherits:  Build_ttframe >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttframe >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttframe */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttframe >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttframe >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttframe >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttframe >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttframe >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttframe >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttframe >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttframe >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttframe >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttframe >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttframe >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttframe >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttframe >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttframe >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttframe >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttframe >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* inherits:  SetTitle_ttframe >> SetTitle_ttwindow */,

    /* extends ttclass_ttwindow */
    twin_tunnel_SetMenubar_ttframe,

  },
 
  {
    Class_ttscroller,
    id_ttscroller,
    magicmask_ttscroller,
    magic_ttscroller,
    size_ttscroller,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttscroller */,
    (void *)NULL /* inherits:  Build_ttscroller >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttscroller >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttscroller */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttscroller >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttscroller >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttscroller >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttscroller >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttscroller >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttscroller >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttscroller >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttscroller >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttscroller >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttscroller >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttscroller >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttscroller >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttscroller >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttscroller >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttscroller >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttscroller >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* inherits:  SetTitle_ttscroller >> SetTitle_ttwindow */,

    /* extends ttclass_ttwindow */

  },
 
  {
    Class_ttmenuitem,
    id_ttmenuitem,
    magicmask_ttmenuitem,
    magic_ttmenuitem,
    size_ttmenuitem,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttmenuitem */,
    (void *)NULL /* inherits:  Build_ttmenuitem >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttmenuitem >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttmenuitem */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttmenuitem >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttmenuitem >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttmenuitem >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttmenuitem >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttmenuitem >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttmenuitem >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttmenuitem >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttmenuitem >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */

  },
 
  {
    Class_ttcheckmenuitem,
    id_ttcheckmenuitem,
    magicmask_ttcheckmenuitem,
    magic_ttcheckmenuitem,
    size_ttcheckmenuitem,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttcheckmenuitem */,
    (void *)NULL /* inherits:  Build_ttcheckmenuitem >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttcheckmenuitem >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttcheckmenuitem */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttcheckmenuitem >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttcheckmenuitem >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttcheckmenuitem >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttcheckmenuitem >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttcheckmenuitem >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttcheckmenuitem >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttcheckmenuitem >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttcheckmenuitem >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */

    /* extends ttclass_ttmenuitem */

  },
 
  {
    Class_ttradiomenuitem,
    id_ttradiomenuitem,
    magicmask_ttradiomenuitem,
    magic_ttradiomenuitem,
    size_ttradiomenuitem,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttradiomenuitem */,
    (void *)NULL /* inherits:  Build_ttradiomenuitem >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttradiomenuitem >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttradiomenuitem */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttradiomenuitem >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttradiomenuitem >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttradiomenuitem >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttradiomenuitem >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttradiomenuitem >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttradiomenuitem >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttradiomenuitem >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttradiomenuitem >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */

    /* extends ttclass_ttmenuitem */

    /* extends ttclass_ttcheckmenuitem */

  },
 
  {
    Class_ttmenu,
    id_ttmenu,
    magicmask_ttmenu,
    magic_ttmenu,
    size_ttmenu,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttmenu */,
    (void *)NULL /* inherits:  Build_ttmenu >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttmenu >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttmenu */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttmenu >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttmenu >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttmenu >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttmenu >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttmenu >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttmenu >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttmenu >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttmenu >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */

    /* extends ttclass_ttmenuitem */

  },
 
  {
    Class_ttmenubar,
    id_ttmenubar,
    magicmask_ttmenubar,
    magic_ttmenubar,
    size_ttmenubar,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttmenubar */,
    (void *)NULL /* inherits:  Build_ttmenubar >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttmenubar >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttmenubar */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttmenubar >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttmenubar >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttmenubar >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttmenubar >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttmenubar >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttmenubar >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttmenubar >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttmenubar >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */

  },
 
  {
    Class_ttanytext,
    id_ttanytext,
    magicmask_ttanytext,
    magic_ttanytext,
    size_ttanytext,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttanytext */,
    (void *)NULL /* inherits:  Build_ttanytext >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_ttanytext >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttanytext */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_ttanytext >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_ttanytext >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_ttanytext >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_ttanytext >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_ttanytext >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_ttanytext >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_ttanytext >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_ttanytext >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_ttanytext >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_ttanytext >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_ttanytext >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_ttanytext >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_ttanytext >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_ttanytext >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_ttanytext >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_ttanytext >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* inherits:  SetTitle_ttanytext >> SetTitle_ttwindow */,

    /* extends ttclass_ttwindow */

  },
 
  {
    Class_tttextfield,
    id_tttextfield,
    magicmask_tttextfield,
    magic_tttextfield,
    size_tttextfield,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tttextfield */,
    (void *)NULL /* inherits:  Build_tttextfield >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tttextfield >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tttextfield */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_tttextfield >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_tttextfield >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_tttextfield >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_tttextfield >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_tttextfield >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_tttextfield >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_tttextfield >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_tttextfield >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_tttextfield >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_tttextfield >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_tttextfield >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_tttextfield >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_tttextfield >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_tttextfield >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_tttextfield >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_tttextfield >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* inherits:  SetTitle_tttextfield >> SetTitle_ttwindow */,

    /* extends ttclass_ttwindow */

    /* extends ttclass_ttanytext */

  },
 
  {
    Class_tttextarea,
    id_tttextarea,
    magicmask_tttextarea,
    magic_tttextarea,
    size_tttextarea,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tttextarea */,
    (void *)NULL /* inherits:  Build_tttextarea >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tttextarea >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tttextarea */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */
    (void *)NULL /* inherits:  AddTo_tttextarea >> AddTo_ttvisible */,
    (void *)NULL /* inherits:  Validate_tttextarea >> Validate_ttvisible */,
    (void *)NULL /* inherits:  Remove_tttextarea >> Remove_ttvisible */,
    (void *)NULL /* inherits:  Invalidate_tttextarea >> Invalidate_ttvisible */,
    (void *)NULL /* inherits:  SetVisible_tttextarea >> SetVisible_ttvisible */,
    (void *)NULL /* inherits:  SetTheme_tttextarea >> SetTheme_ttvisible */,
    (void *)NULL /* inherits:  Draw_tttextarea >> Draw_ttvisible */,
    (void *)NULL /* inherits:  BuiltinRepaint_tttextarea >> BuiltinRepaint_ttvisible */,


    /* extends ttclass_ttvisible */
    (void *)NULL /* inherits:  SetLayout_tttextarea >> SetLayout_ttwidget */,
    (void *)NULL /* inherits:  SetXY_tttextarea >> SetXY_ttwidget */,
    (void *)NULL /* inherits:  SetWH_tttextarea >> SetWH_ttwidget */,
    (void *)NULL /* inherits:  SetXl_tttextarea >> SetXl_ttwidget */,
    (void *)NULL /* inherits:  SetYl_tttextarea >> SetYl_ttwidget */,
    (void *)NULL /* inherits:  SetWl_tttextarea >> SetWl_ttwidget */,
    (void *)NULL /* inherits:  SetHl_tttextarea >> SetHl_ttwidget */,
    (void *)NULL /* inherits:  SetTooltip_tttextarea >> SetTooltip_ttwidget */,

    /* extends ttclass_ttwidget */
    (void *)NULL /* inherits:  SetTitle_tttextarea >> SetTitle_ttwindow */,

    /* extends ttclass_ttwindow */

    /* extends ttclass_ttanytext */

    /* extends ttclass_tttextfield */

  },
 
  {
    Class_tttheme,
    id_tttheme,
    magicmask_tttheme,
    magic_tttheme,
    size_tttheme,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_tttheme */,
    (void *)NULL /* inherits:  Build_tttheme >> Build_ttobject */,
    (void *)NULL /* inherits:  Break_tttheme >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_tttheme */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */

  },
 
  {
    Class_ttapplication,
    id_ttapplication,
    magicmask_ttapplication,
    magic_ttapplication,
    size_ttapplication,

    /* extends ttclass_ttobj */
    (void *)NULL /* UNDEFINED: New_ttapplication */,
    twin_tunnel_Build_ttapplication,
    (void *)NULL /* inherits:  Break_ttapplication >> Break_ttobject */,
    (void *)NULL /* UNDEFINED: Del_ttapplication */,

    /* extends ttclass_ttobject */

    /* extends ttclass_ttcomponent */

  },



  {

    twin_tunnel_Sync, 
    twin_tunnel_Flush, 
    twin_tunnel_TimidFlush, 
    twin_tunnel_MainLoopOnce, 
    twin_tunnel_DeleteCallback,    
    twin_tunnel_Close, 
    twin_tunnel_ConnectionFd, 
    twin_tunnel_GetErrno, 
    twin_tunnel_GetErrnoDetail,    
    twin_tunnel_StrError, 
    twin_tunnel_StrErrorDetail,   
  },
};





