<?php	// TWIG		TEST Script ?>
<html>
 <head>
  <title>TWIG [Test Suite]</title>
  </head>

 <body bgcolor="#ffffff" link="#0000ff" vlink="#0000ff" alink="#C01010">

<?php

 $config_dir="config/";

 if(!ereg("/$", $config_dir)) {$config_dir .= "/";}

 // Load the config options
 require($config_dir . "config.inc.php3");	// Global Configuration Variables

 // Load the database config file
 require($config_dir . "dbconfig.inc.php3");

 // Load the image source files
 require($config_dir . "images.inc.php3");

 // Load virtual host configuration files if they exist
 if( $vhosts[$SERVER_NAME] )
        {
        if( !ereg("/$",$vhosts[$SERVER_NAME]) ) {$vhosts[$SERVER_NAME] .= "/";}
        if( is_readable( $vhosts[$SERVER_NAME] . "config.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "config.inc.php3" ); }
	if( is_readable( $vhosts[$SERVER_NAME] . "dbconfig.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "dbconfig.inc.php3" ); }
	if( is_readable( $vhosts[$SERVER_NAME] . "images.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "images.inc.php3" ); }
        }

 // Load the common functions lib...
 require( "features/common.inc.php3" );

 // Set up database
  if (!$dbconfig["sqltype"]) { $dbconfig["sqltype"] = "mysql"; }
  if( file_exists( "lib/db/" . $dbconfig["sqltype"] . ".db.inc.php3" ) )
  	{
  	require("lib/db/" . $dbconfig["sqltype"] . ".db.inc.php3");
  	}
 else
 	{
	echo "<font color=\"#FF0000\" size=\"+2\"><b>Error</b>:  You have set your database type to '" . $dbconfig["sqltype"] . "' in config/dbconfig.inc.php3, but this module cannot be found. Please check these settings and try again.</font><br><br>\n";
	}

 if( !$config["imap_server"]) { $config["imap_server"]="localhost"; }
 if( !$config["imap_port"]) { $config["imap_port"] = 143; }

 if( !$config["imap_servertype"] ) { $config["imap_servertype"] = "php-imap"; }
 require( "lib/mail/" . $config["imap_servertype"] . ".inc.php3" );		// include the mail subsystem

 // This test script should run independently of the configuration
 // if( $vhosts[$SERVER_NAME] && is_readable($vhosts[$SERVER_NAME] . "header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "header.inc.php3");}
 // else {include($config_dir . "header.inc.php3");}

?>

  <table border=0 cellspacing=0 width="100%">
   <tr bgcolor="<?php echo $config["cellheadcolor"];?>">
    <td>
     <font color="<?php echo $config["cellheadtext"];?>">
     <a name=GENERAL><b>General</b></a>
     </font>
    </td>
    <td colspan=2 align=right>
     <font color="<?php echo $config["cellheadtext"];?>">
     Back to <a href="#top">top</a>.
     </font>
    </td>
   </tr>
  </table>
  
  <BR>
  Welcome to the TWIG test page!<BR>
  <BR>
  If you've executed a test that has failed and can no longer see the complete form click <a href="test.php3">here</a> to get back to a clean form.<br>
  <br>
  This page is divied in to several sections:<br>
  <ul>
  <li>This section</li>
  <li><a href="#IMAP">An IMAP test</a></li>
  <li><a href="#SQL">A SQL test</a></li>
  <li><a href="#PHP">A PHP compliance test</a></li>
  <li><a href="#PHPINFO">PHP Version Information</a></li>
  </ul>
 
  <?php echo $config["hr"];?>
<?php
$phpver = explode( ".", phpversion() );

if( $phpver[0] <= 3 )
	{
	if( $phpver[0] == 3 )
		{
		if( $phpver[1] == 0 )
			{
			if( $phpver[2] < 12 )
				{
				echo "<H1><FONT COLOR=\"#FF0000\"><B>WARNING: You are running a version " . phpversion() ." of PHP, however TWIG needs at least version 3.0.12.</B></FONT></H1><BR><HR>";
				}
			}
		}
	else
		{
		echo "<H1><FONT COLOR=\"#FF0000\"><B>WARNING: You are running a version " . phpversion() ." of PHP, however TWIG needs at least version 3.0.12.</B></FONT></H1><BR><HR>";
		}
	}

 flush();
?>

  <table border=0 cellspacing=0 width="100%">
   <tr bgcolor="<?php echo $config["cellheadcolor"];?>">
    <td>
     <font color="<?php echo $config["cellheadtext"];?>">
     <a name=IMAP><b>IMAP</b></a>
     </font>
    </td>
    <td colspan=2 align=right>
     <font color="<?php echo $config["cellheadtext"];?>">
     Back to <a href="#top">top</a>.
     </font>
    </td>
   </tr>
   <tr>
    <td valign=top width="33%">
     <B>Test #1</B><BR>
     <BR>
     This IMAP test will check to see that the IMAP functions are compiled into your PHP installed.<BR>
     <BR>
<?php 
 if( function_exists( "imap_open" ) )
	{
	echo "<font color=\"#009900\">IMAP functions are installed.</font><br>\n";
	}
 else
 	{
	echo "<font color=\"#FF0000\">Error</font>.  IMAP functions are not installed. You will either need to get the IMAP module for PHP or recompile PHP entirely in order to add this support.<br><br>\n";
	}
?>
    </td>
    <td valign=top width="33%">
     <B>Test #2</B><BR>
     <BR>
     This IMAP test will execute a php imap function, if imap is compiled in to php a result should be returned, otherwise php will generate an undefined function error.<BR>
     <BR>
     <form action="test.php3#IMAP" method=post>
      <input type=submit name=currenttest value="Execute IMAP Test">
     </form>
     Test result: <font color="#FF0000">
<?php 
 if( $currenttest == "Execute IMAP Test" ) 
	{
	$aparse = TWIGMailParseAddresssList( "twig@screwdriver.net", $config["fromdomain"] );

	if( count( $aparse ) > 0 ) { echo "Works"; } else { echo "Failed"; }
	}
 else
	{
	echo "Test not run";
	}
?>
     </font>
    </td>
    <td valign=top width="33%">
     <B>Test #3</B><BR>
     <BR>
     This IMAP test will try and connect to:<br>
     <BR>
     <table border=0>
      <tr>
       <td align=right>Server name:</td>
       <td><?php echo $config["imap_server"]?></td>
      </tr>
      <tr>
       <td align=right>Server port:</td>
       <td><?php echo $config["imap_port"]?></td>
      </tr>
     </table>
     <br>
     Enter a username and password to connect to the IMAP server
     <form action="test.php3#IMAP" method=post>
      <table>
       <tr>
        <td>Name<br><input name=username></td>
        <td>Password<br><input name=password type=password></td>
       </tr>
      </table>
      <input type=submit name=currenttest value="Execute IMAP Connection Test">
     </form>
     Test result: <font color="#FF0000">
<?php 
 if( $currenttest == "Execute IMAP Connection Test" ) 
	{
 	$mbox = @TWIGMailOpenMailbox( TWIGMailGetFolderString( $config["imap_server"], $config["imap_port"], "", "INBOX" ), $username, $password, "" );

	if( $mbox )
		{
		echo "Works";
		}
	else
		{
		$mbox = @TWIGMailOpenMailbox( TWIGMailGetFolderString( $config["imap_server"], $config["imap_port"] . "/notls", "", "INBOX" ), $username, $password, "" );
		if( $mbox )
			{
			echo "Works with /notls option.  I recommend you change<br>&nbsp;&nbsp;\$config[\"imap_port\"]=$config[imap_port]<br>to<br>&nbsp;&nbsp;\$config[\"imap_port\"]=$config[imap_port]/notls<br>";
			}
		else
			{
			echo "Failed";
			}
		}
	}
 else
	{
	echo "Test not run";
	}
?>
     </font>
    </td>
   </tr>
  </table>
  
  <?php echo $config["hr"];?>
 
  <table border=0 cellspacing=0 width="100%">
   <tr bgcolor="<?php echo $config["cellheadcolor"];?>">
    <td>
     <font color="<?php echo $config["cellheadtext"];?>">
     <a name=SQL><b>SQL</b></a>
     </font>
    </td>
    <td colspan=2 align=right>
     <font color="<?php echo $config["cellheadtext"];?>">
     Back to <a href="#top">top</a>.
     </font>
    </td>
   </tr>
   <tr>
    <td valign=top width="33%">
     <B>Test #1</B><BR>
     <BR>
     This SQL test will check to see which database types are compiled into your PHP installation, and make sure that you've configured TWIG to use a database type which is installed.<BR>
     <BR>
     <UL>
<?php 

 $databases["MySQL"]				= array( "config" => "mysql",		"func" => "mysql_query" );
 $databases["PostgreSQL (for PHP<=4.2.0)"]	= array( "config" => "pgsql,pgsql-new", "func" => "pg_exec" );
 $databases["PostgreSQL (for PHP >4.2.0)"]	= array( "config" => "unsupported",	"func" => "pg_query" );
 $databases["MS-SQL"]				= array( "config" => "mssql",		"func" => "mssql_query" );
 $databases["Sybase"]				= array( "config" => "sybase",		"func" => "sybase_query" );
 $databases["InterBase"]			= array( "config" => "ibase",		"func" => "ibase_query" );
 $databases["dBase files"]			= array( "config" => "dbasesql",	"func" => "dbase_open" );
 $databases["Oracle via OCI8 (supported)"]	= array( "config" => "oracle",		"func" => "OCIExecute" );
 $databases["Oracle direct (not supported)"]	= array( "config" => "unsupported",	"func" => "Ora_Exec" );

 while( list( $key, $val ) = each( $databases ) )
 	{
 	if( function_exists( $val["func"] ) )
		{
		echo "<li><font color=\"#009900\">$key functions are installed.</font>\n";
		$installed[$val["config"]] = true;
		}
 	else
 		{
		echo "<li><font color=\"#FF0000\">$key functions are not installed.</font>\n";
		}
	}
?>
     </UL>
    </td>
    <td valign=top width="66%">
     <B>Test #2</B><BR>
     <BR>
     This SQL test will try and connect to:<br>
     <BR>
     <table border=0>
      <tr>
       <td align=right>Server type:</td><td><?php echo $dbconfig["sqltype"]; ?></td>
      </tr><tr>
       <td align=right colspan=2><?php
       	if( $installed[$dbconfig["sqltype"]] )
		{
		echo "<font color=\"#009900\">Support for this database is installed.</font>\n";
		}
	else
		{
		echo "<font color=\"#FF0000\">Support for this database is <b>not</b> installed.</font>\n";
		}
	?></td>
      </tr><tr>
       <td align=right>Server name:</td><td><?php echo $dbconfig["sqlserver"]?></td>
      </tr><tr>
       <td align=right>Server port:</td><td><?php echo $dbconfig["sqlport"]?></td>
      </tr><tr>
       <td align=right>Database name:</td><td><?php echo $dbconfig["defaultdb"]?></td>
      </tr><tr>
       <td align=right>Database table:</td><td><?php echo $dbconfig["global_prefs_table"]?></td>
      </tr>
     </table>
     <BR>
     If sql is not compiled in to php will generate an undefined function error.<BR>
     <form action="test.php3#SQL" method=post>
      <input type=submit name=currenttest value="Execute SQL Connection Test">
     </form>
     Test result: <font color="#FF0000">
<?php 
   if( $currenttest == "Execute SQL Connection Test" ) 
          {
          $st = "SELECT * FROM " . $dbconfig["global_prefs_table"];
          $rc = dbQuery( $st );
  
          if( $rc ) { echo "Working"; } else { echo "Failed"; }
          }
   else
          {
          echo "Test not run";
          }
?>
     </font>
    </td>
   </tr>
  </table>
  
<?php echo $config["hr"];?>
   
  <table border=0 cellspacing=0 width="100%">
   <tr bgcolor="<?php echo $config["cellheadcolor"];?>">
    <td>
     <font color="<?php echo $config["cellheadtext"];?>">
     <a name=PHP><b>PHP Compliance</b></a>
     </font>
    </td>
    <td align=right>
     <font color="<?php echo $config["cellheadtext"];?>">
     Back to <a href="#top">top</a>.
     </font>
    </td>
   </tr>
   <tr>
    <td valign=top width="33%">
     <B>Test #1</B><BR>
     <BR>
     Checking if your PHP version works<br><br>
<?php
 $phpfver = phpversion();

 $knownbadphp[] = array( "ver"=>"3.0.15", "bug"=>"A bug in imap_delete caused wrong mail deletion." );
 $knownbadphp[] = array( "ver"=>"4.0.1", "bug"=>"I think something was wrong with this one..." );
 $knownbadphp[] = array( "ver"=>"4.0.6", "bug"=>"A bug in the PostgreSQL module. Do not use 4.0.6 and pgsql as your database library." );

 $hadproblems = false;
 while( list( $key, $val ) = each( $knownbadphp ) )
 	{
	if( $val["ver"] == $phpfver )
		{
		$problems = $val["bug"];
		$hadproblems = true;
		break;
		// We could only match once anyhow
		// so just break out of the while if we get here
		}
	}

 if( $hadproblems )
 	{
	echo "<font color=\"#FF0000\">Error</font>.  Your PHP version has a known problem that may affect
	TWIG. Here is the error message: $problems<br><br>\n";
	}
 else
 	{
	echo "<font color=\"#009900\">Your version of PHP has no known problems for TWIG.</font><br>\n";
	}
?>
    </td>
    <td valign=top width="66%">
     <B>Test #2</B><BR>
     <BR>
     Checking php configuration for possible problems<br><br>
<?php
 if( $phpver[0] <= 4 )
 	{
	// This section is all PHP4 functions and syntax.
 	$file_upload_option = ini_get( "file_uploads" );
 	$register_globals_option = ini_get( "register_globals" );

 	if( $file_upload_option === "" )
 		{
		echo "<font color=\"#FF0000\">Error</font>.  file_upload is set to off.  This may prevent you
		from sending email. Edit your php.ini file and set file_upload to on<br><br>\n";
		}
 	else
 		{
		echo "<font color=\"#009900\">file_uploads</font> configured correctly<br>\n";
		}

 	if( $register_globals_option === "" )
 		{
		echo "<font color=\"#FF0000\">Error</font>.  register_globals is set to off.  TWIG requires that register_globals be on.  This will be fixed in the future<br><br>\n";
		}
 	else
 		{
		echo "<font color=\"#009900\">register_globals</font> configured correctly<br>\n";
		}
	}
 else
 	{
	echo "Cannot get configuration information from PHP versions prior to 4.0<br>";
	}
?>
    </td>
   </tr>
  </table>
  
  <table border=0 cellspacing=0 width="100%">
   <tr bgcolor="<?php echo $config["cellheadcolor"];?>">
    <td align=left>
     <font color="<?php echo $config["cellheadtext"];?>">
     <a name=PHPINFO><b>PHP Version Information</b></a>
     </font>
    </td>
    <td align=right>
     <font color="<?php echo $config["cellheadtext"];?>">
     Back to <a href="#top">top</a>.
     </font>
    </td>
   </tr>
   <tr>
    <td width="80%" colspan=2>
     <?php phpinfo(); ?>
    </td>
   </tr>
  </table>
  
 </body>
</html>
  
 
  
  
  
  
  
  
  
  
 
  
  
 
  
  
  
 
  
  
 
  
  
 
  
  
  
 
