<?php	// TWIG		Search Feature Module for Bookmarks ?>
<?php 
 TWIGLoadLanguageFile( "features/bookmarks/strings/", "", $config["language"] );

 if( !$global )
 	{
	echo "<form action=" . $config["baseurl"] . " method=post>\n";
	echo TWIGSession( "put" );
	echo TWIGContext( "put" );

	$entry = 0;

	$tableheaders = array( $TWIGphrase["Item"], "&nbsp", $TWIGphrase["Criteria"] );

 	if( !isset( $search_groups ) )
 		{
		$search_groups = GetPref( "dgroup", $dbconfig["bookmarks_prefs_table"], $config["defaults"]["bookmarks"]["dgroup"] );
		}
 	$temp = "<select name=search_groups>\n";
 	$temp .= TWIGGroupsSelect( $login["username"], $search_groups, 1 );
 	$temp .= "</select>\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Group"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_name value=" . stripslashes( $search_name ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Name"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_description value=" . stripslashes( $search_description ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["Description"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	$temp = "<input type=text name=search_url value=" . stripslashes( $search_url ) . ">\n";
	$tablecontents[$entry] = array( array( "contents"=>"<b>" . $TWIGphrase["URL"] . ":</b>", "align"=>"right" ), "&nbsp", $temp ); $entry++;

	echo "<table><tr><td>\n";
	echo TWIGGenerateTable( $tableheaders, $tablecontents );
	echo "</td></tr>";
	echo "<tr><td align=center><input type=submit name=search value=\"" . $TWIGphrase["Search"] . "\">";

	echo "</td></tr></table>\n";
	echo "</form>\n";
	}

 unset( $tableheaders );
 unset( $tablecontents );

 if( $search ) 
	{
	// Yeah, do the search

	// Build a WHERE clause
	$searchquery = "";
	if( $global )
		{
		if( $search_text )
			{
			// The first four characters are going away anyhow.
			// Might as well have a little fun ;-)
			$searchquery .= "Bla ( item LIKE '%$search_text%' ";
			$searchquery .= "OR description LIKE '%$search_text%' ";
			$searchquery .= "OR url LIKE '%$search_text%' )";
			}
		}
	else
		{
		if( $search_name )
			{
			$searchquery .= "AND item LIKE '%$search_name%' ";
			}
		if( $search_description )
			{
			$searchquery .= "AND description LIKE '%$search_description%' ";
			}
		if( $search_url )
			{
			$searchquery .= "AND url LIKE '%$search_url%' ";
			}
		}
	if( isset( $search_groups ) )
		{
		$searchquery .= "AND (" . TWIGGroupsCreateSQLGroupQuery( $login["username"], array( $search_groups ) ) . ")";
		}
	if( $searchquery )
		{
		// If there is no $searchquery (ie we failed all the above) then why bother searching?

		// Strip the first four characters because we know they are 'AND '
		$searchquery = substr( $searchquery, 4 );

		$sortorder = array( "item"=>"item", "group"=>"groupid" );
		$sortordernum = array( "item"=>0, "groupid"=>1 );
		if( !$session["nsortby"] ) { $session["nsortby"] = $sortorder[GetPref( "sortby", $dbconfig["bookmarks_prefs_table"], $config["defaults"]["bookmarks"]["sortby"] )]; }
		if( !$session["nsortby"] ) { $session["nsortby"] = "item"; }
		$sortway = array( "", " DESC" );
		if( !$session["nsortbyway"] ) { $session["nsortbyway"] = $sortway[GetPref( "sortorder", $dbconfig["bookmarks_prefs_table"], $config["defaults"]["bookmarks"]["sortorder"] )]; }

		$hilights = array( array( "", "" ), array( "", "" ) );
		$hilights[$sortordernum[$session["nsortby"]]] = array( "[", "]" );

		if( $session["nsortbyway"] ) { $tmpsortbyway = ""; } else { $tmpsortbyway = " DESC"; }

		$soitem = array( array( "item"=>"nsortby", "value"=>"item" ), array( "item"=>"nsortbyway", "value"=>$tmpsortbyway ) );
		$sogroup = array( array( "item"=>"nsortby", "value"=>"groupid" ), array( "item"=>"nsortbyway", "value"=>$tmpsortbyway ) );

		$tableheaders = array( 	twigLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $hilights[0][0] . $TWIGphrase["item"] . $hilights[0][1] . "</font>", "bookmarks", "", "", "", $soitem ),
					"&nbsp;",
					twigLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $hilights[1][0] . $TWIGphrase["group"] . $hilights[1][1] . "</font>", "bookmarks", "", "", "", $sogroup ),
					"&nbsp;",
					twigLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $hilights[2][0] . $TWIGphrase["url"] . $hilights[2][1] . "</font>", "bookmarks", "", "", "", $sourl ),
					);

		$query = "SELECT * FROM " . $dbconfig["bookmarks_table"] . " WHERE (" . $searchquery . ") ORDER BY " . $session["nsortby"] . $session["nsortbyway"];
		$result = dbQuery( $query );
		TWIGDebug( $query );

		if( !$startmsg ) { $startmsg = 1; }
		$pagesize = GetPref( "pagesize", $dbconfig["bookmarks_prefs_table"], $config["defaults"]["bookmarks"]["pagesize"] );

		if( $submitbutton["selectall"] ) { $marked = " CHECKED"; } else { $marked = ""; }

		$total = dbNumRows( $result );
		if( ( $pagesize == 0 ) || ( $startmsg + $pagesize > $total ) ) { $highitem = $total; } else { $highitem = $startmsg + $pagesize - 1; }

		for( $i = $startmsg - 1; $i < $highitem; $i++ ) 
			{
			$data = dbResultArray( $result, $i );

			if( !$data["url"] )
				{
				$url = "&nbsp;";
				}
			else
				{
				if( strstr( $data["url"], "://" ) ) { $url = ""; } else { $url = "http://"; }
				$url = "<a href=\"" . $url . $data["url"] . "\" target=_blank>" . $data["url"] . "</a>";
				}

			$tablecontents[$i] = array(	twigLink( TWIGImage( $img["project"], $TWIGphrase["View Note"] ) . $data["item"], "bookmarks", "view", "ItemID=" . $data["id"] ), 
							"&nbsp;",
							twigLink( TWIGGroupsGetName( $data["groupid"] ), "bookmarks", "", "session[" . $featureprefix . "Group]=" . $data["groupid"] ),
							"&nbsp;",
							$url
							);
			}
?>
<table width=100% border=0 cellspacing=0 cellpadding=0>
 <tr>
  <td valign=top bgcolor="<?php echo $config["cellheadcolor"]?>">
   <font face="<?php echo $config["cellfont"]?>" size=<?php echo $config["textfontsize"];?>><b>
    <?php echo TWIGLink( "<font color=\"" . $config["cellheadtext"] . "\">" . $TWIGphrase["Bookmarks"] . "</font>", "bookmarks" ); ?>
   </b></font>
  </td>
 </tr>
 <tr>
  <td bgcolor=<?php echo $config["cellcolor"]?>>
   &nbsp;
  </td>
 </tr>
 <tr>
  <td valign=top bgcolor=<?php echo $config["cellcolor"]?>>
   <?php
   if( $tablecontents )
	{
	echo TWIGGenerateTable( $tableheaders, $tablecontents, "", "95%", "center" );
	}
   else
	{
	echo "<font face=" . $config["cellfont"] . " size=" . $config["textfontsize"] . ">";
	echo "<b><i>" . $TWIGphrase["No matches"] . "</i></b></font>\n";
	}
   ?>
  </td>
 </tr>
 <tr>
  <td bgcolor=<?php echo $config["cellcolor"]?>>
   &nbsp;
  </td>
 </tr>
</table>
<?php
		}
	}

?>
